/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.tableview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;

public class Column
implements JSONEnabled {
    public String uri;
    public String value = "";
    public List<RelatedTopic> children = null;
    public String type = "column";
    public Topic parentTopic;

    public Column(Topic parentTopic, String childTypeUri, List<RelatedTopic> children) {
        this.uri = childTypeUri;
        this.parentTopic = parentTopic;
        if (children != null) {
            this.children = children;
        }
    }

    public JSONObject toJSON() {
        HashMap<String, String> out = new HashMap<String, String>();
        out.put("uri", this.uri);
        ArrayList<String> values = new ArrayList<String>();
        if (this.children == null && this.parentTopic.getTypeUri().equals(this.uri)) {
            out.put("value", (String)this.parentTopic.getSimpleValue());
        } else if (this.children != null) {
            for (RelatedTopic topic : this.children) {
                if (topic == null) continue;
                values.add(topic.getSimpleValue().toString());
            }
            out.put("value", values.isEmpty() ? "" : String.join((CharSequence)", ", values));
        }
        out.put("type", this.type);
        return new JSONObject(out);
    }
}

