/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import systems.dmx.core.AssocType;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.CoreServiceImpl;
import systems.dmx.core.impl.InjectableService;
import systems.dmx.core.impl.PluginInfoImpl;
import systems.dmx.core.impl.RestResourcesPublication;
import systems.dmx.core.impl.StaticResourcesPublication;
import systems.dmx.core.osgi.PluginContext;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.EventListener;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.service.Plugin;
import systems.dmx.core.service.PluginInfo;
import systems.dmx.core.storage.spi.DMXTransaction;

public class PluginImpl
implements Plugin,
EventHandler {
    private static final String PLUGIN_DEFAULT_PACKAGE = "systems.dmx.core.osgi";
    private static final String PLUGIN_CONFIG_FILE = "/plugin.properties";
    private static final String PLUGIN_ACTIVATED = "de/deepamehta/core/plugin_activated";
    private PluginContext pluginContext;
    private BundleContext bundleContext;
    private Bundle pluginBundle;
    private String pluginUri;
    private Properties pluginProperties;
    private String pluginPackage;
    private PluginInfo pluginInfo;
    private List<String> pluginDependencies;
    private Topic pluginTopic;
    private CoreServiceImpl dmx;
    private ModelFactory mf;
    private EventAdmin eventService;
    private Map<Class<?>, InjectableService> injectableServices = new HashMap();
    private List<ServiceTracker> serviceTrackers = new ArrayList<ServiceTracker>();
    private String providedServiceInterface;
    private StaticResourcesPublication webResources;
    private StaticResourcesPublication fileSystemResources;
    private RestResourcesPublication restResources;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public PluginImpl(PluginContext pluginContext) {
        this.pluginContext = pluginContext;
        this.bundleContext = pluginContext.getBundleContext();
        this.pluginBundle = this.bundleContext.getBundle();
        this.pluginUri = this.pluginBundle.getSymbolicName();
        this.pluginProperties = this.readConfigFile();
        this.pluginPackage = this.getConfigProperty("dmx.plugin.main_package", pluginContext.getClass().getPackage().getName());
        this.pluginInfo = this.pluginInfo();
        this.pluginDependencies = this.pluginDependencies();
        this.providedServiceInterface = this.providedServiceInterface();
    }

    public void start() {
        if (this.pluginDependencies.size() > 0) {
            this.registerPluginActivatedEventListener();
        }
        this.createCoreServiceTrackers();
        this.createInjectedServiceTrackers();
        this.openServiceTrackers();
    }

    public void stop() {
        this.invokeShutdownHook();
        this.closeServiceTrackers();
    }

    public void publishFileSystem(String uriNamespace, String path) {
        try {
            this.logger.info("### Publishing file system \"" + path + "\" at URI namespace \"" + uriNamespace + "\"");
            if (this.fileSystemResources != null) {
                throw new RuntimeException(this + " has already published file system resources; only one directory per plugin is supported");
            }
            this.fileSystemResources = this.dmx.wpService.publishFileSystem(uriNamespace, path);
        }
        catch (Exception e) {
            throw new RuntimeException("Publishing file system \"" + path + "\" at URI namespace \"" + uriNamespace + "\" failed", e);
        }
    }

    public String getUri() {
        return this.pluginUri;
    }

    @Override
    public InputStream getStaticResource(String name) {
        try {
            URL url = this.pluginBundle.getResource(name);
            if (url == null) {
                throw new RuntimeException("Resource \"" + name + "\" not found");
            }
            return url.openStream();
        }
        catch (Exception e) {
            throw new RuntimeException("Accessing a static resource of " + this + " failed", e);
        }
    }

    @Override
    public boolean hasStaticResource(String name) {
        return this.getBundleEntry(name) != null;
    }

    public String toString() {
        return this.pluginContext.toString();
    }

    PluginInfo getInfo() {
        return this.pluginInfo;
    }

    PluginContext getContext() {
        return this.pluginContext;
    }

    Topic getPluginTopic() {
        return this.pluginTopic;
    }

    String getProvidedServiceInterface() {
        return this.providedServiceInterface;
    }

    String getConfigProperty(String key) {
        return this.getConfigProperty(key, null);
    }

    String getConfigProperty(String key, String defaultValue) {
        return this.pluginProperties.getProperty(key, defaultValue);
    }

    String getMigrationClassName(int migrationNr) {
        if (this.pluginPackage.equals(PLUGIN_DEFAULT_PACKAGE)) {
            return null;
        }
        return this.pluginPackage + ".migrations.Migration" + migrationNr;
    }

    void setMigrationNr(int migrationNr) {
        this.pluginTopic.update(this.mf.newChildTopicsModel().set("dmx.core.plugin_migration_nr", migrationNr));
    }

    Class loadClass(String className) {
        try {
            return this.pluginBundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Properties readConfigFile() {
        try {
            Properties properties = new Properties();
            if (!this.hasStaticResource(PLUGIN_CONFIG_FILE)) {
                this.logger.info("Reading config file \"/plugin.properties\" for " + this + " SKIPPED -- file does not exist");
                return properties;
            }
            this.logger.info("Reading config file \"/plugin.properties\" for " + this);
            properties.load(this.getStaticResource(PLUGIN_CONFIG_FILE));
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException("Reading config file \"/plugin.properties\" for " + this + " failed", e);
        }
    }

    private PluginInfo pluginInfo() {
        return new PluginInfoImpl(this.pluginUri, this.getSingleResource("/web", ".plugin.js"), this.getSingleResource("/web", ".style.css"));
    }

    private String getSingleResource(String path, String suffix) {
        String resource = "";
        List<String> resources = this.scanResources(path, suffix);
        int size = resources.size();
        if (size == 1) {
            resource = resources.get(0);
        } else if (size > 1) {
            throw new RuntimeException("Ambiguity: found " + size + " *" + suffix + " files in " + path);
        }
        return resource;
    }

    private void createCoreServiceTrackers() {
        this.serviceTrackers.add(this.createServiceTracker(CoreService.class));
        this.serviceTrackers.add(this.createServiceTracker(EventAdmin.class));
    }

    private void createInjectedServiceTrackers() {
        List<InjectableService> injectableServices = this.createInjectableServices();
        if (injectableServices.isEmpty()) {
            this.logger.info("Tracking services for " + this + " SKIPPED -- no services consumed");
            return;
        }
        this.logger.info("Tracking " + injectableServices.size() + " services for " + this + " " + injectableServices);
        for (InjectableService injectableService : injectableServices) {
            Class<?> serviceInterface = injectableService.getServiceInterface();
            this.injectableServices.put(serviceInterface, injectableService);
            this.serviceTrackers.add(this.createServiceTracker(serviceInterface));
        }
    }

    private List<InjectableService> createInjectableServices() {
        ArrayList<InjectableService> injectableServices = new ArrayList<InjectableService>();
        for (Field field : PluginImpl.getInjectableFields(this.pluginContext.getClass())) {
            Class<?> serviceInterface = field.getType();
            injectableServices.add(new InjectableService(this.pluginContext, serviceInterface, field));
        }
        return injectableServices;
    }

    private boolean injectedServicesAvailable() {
        for (InjectableService injectableService : this.injectableServices.values()) {
            if (injectableService.isServiceAvailable()) continue;
            return false;
        }
        return true;
    }

    static List<Field> getInjectableFields(Class<?> clazz) {
        ArrayList<Field> injectableFields = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            field.setAccessible(true);
            injectableFields.add(field);
        }
        return injectableFields;
    }

    Object getInjectedService(Class<?> serviceInterface) {
        InjectableService injectableService = this.injectableServices.get(serviceInterface);
        if (injectableService == null) {
            throw new RuntimeException("Service " + serviceInterface.getName() + " is not tracked by " + this);
        }
        return injectableService.getService();
    }

    private ServiceTracker createServiceTracker(final Class serviceInterface) {
        return new ServiceTracker(this.bundleContext, serviceInterface.getName(), null){

            public Object addingService(ServiceReference serviceRef) {
                Object service = null;
                try {
                    service = super.addingService(serviceRef);
                    PluginImpl.this.addService(service, serviceInterface);
                    PluginImpl.this.checkRequirementsForActivation();
                }
                catch (Throwable e) {
                    PluginImpl.this.logger.log(Level.SEVERE, "", e);
                }
                return service;
            }

            public void removedService(ServiceReference ref, Object service) {
                try {
                    PluginImpl.this.removeService(service, serviceInterface);
                    super.removedService(ref, service);
                }
                catch (Throwable e) {
                    PluginImpl.this.logger.log(Level.SEVERE, "", e);
                }
            }
        };
    }

    private void openServiceTrackers() {
        for (ServiceTracker serviceTracker : this.serviceTrackers) {
            serviceTracker.open();
        }
    }

    private void closeServiceTrackers() {
        for (ServiceTracker serviceTracker : this.serviceTrackers) {
            serviceTracker.close();
        }
    }

    private void addService(Object service, Class serviceInterface) {
        if (service instanceof CoreService) {
            this.logger.fine("Adding DMX core service to " + this);
            this.setCoreService((CoreServiceImpl)service);
            this.publishWebResources();
            this.publishRestResources();
        } else if (service instanceof EventAdmin) {
            this.logger.fine("Adding Event Admin service to " + this);
            this.eventService = (EventAdmin)service;
        } else {
            this.logger.fine("Adding " + serviceInterface.getName() + " to " + this);
            this.injectableServices.get(serviceInterface).injectService(service);
            this.pluginContext.serviceArrived(service);
        }
    }

    private void removeService(Object service, Class serviceInterface) {
        if (service == this.dmx) {
            this.logger.fine("Removing DMX core service from " + this);
            this.unpublishRestResources();
            this.unpublishWebResources();
            this.unpublishFileSystem();
            this.dmx.pluginManager.deactivatePlugin(this);
            this.setCoreService(null);
        } else if (service == this.eventService) {
            this.logger.fine("Removing Event Admin service from " + this);
            this.eventService = null;
        } else {
            this.logger.fine("Removing " + serviceInterface.getName() + " from " + this);
            this.pluginContext.serviceGone(service);
            this.injectableServices.get(serviceInterface).injectService(null);
        }
    }

    private void setCoreService(CoreServiceImpl dmx) {
        this.dmx = dmx;
        this.mf = dmx != null ? dmx.mf : null;
        this.pluginContext.setCoreService(dmx);
    }

    private void checkRequirementsForActivation() {
        if (this.dmx != null && this.eventService != null && this.injectedServicesAvailable() && this.dependenciesAvailable()) {
            this.dmx.pluginManager.activatePlugin(this);
        }
    }

    void activate() {
        try {
            this.logger.info("----- Activating " + this + " -----");
            this.invokePreInstallHook();
            this.installPluginInDB();
            this.registerListeners();
            this.registerProvidedService();
            this.invokeInitHook();
            this.logger.info("----- Activation of " + this + " complete -----");
            this.postPluginActivatedEvent();
        }
        catch (Throwable e) {
            throw new RuntimeException("Activating " + this + " failed", e);
        }
    }

    void deactivate() {
        this.unregisterListeners();
    }

    private void installPluginInDB() {
        DMXTransaction tx = this.dmx.beginTx();
        try {
            boolean isCleanInstall = this.createPluginTopicIfNotExists();
            this.dmx.migrationManager.runPluginMigrations(this, isCleanInstall);
            if (isCleanInstall) {
                this.introduceTopicTypesToPlugin();
                this.introduceAssocTypesToPlugin();
            }
            tx.success();
        }
        catch (Exception e) {
            this.logger.warning("ROLLBACK! (" + this + ")");
            throw new RuntimeException("Installing " + this + " in the database failed", e);
        }
        finally {
            tx.finish();
        }
    }

    private boolean createPluginTopicIfNotExists() {
        this.pluginTopic = this.fetchPluginTopic();
        if (this.pluginTopic != null) {
            this.logger.info("Installing " + this + " in the database SKIPPED -- already installed");
            return false;
        }
        this.logger.info("Installing " + this + " in the database");
        this.pluginTopic = this.createPluginTopic();
        return true;
    }

    private Topic createPluginTopic() {
        return this.dmx.createTopic(this.mf.newTopicModel(this.pluginUri, "dmx.core.plugin", this.mf.newChildTopicsModel().set("dmx.core.plugin_name", this.pluginName()).set("dmx.core.plugin_symbolic_name", this.pluginUri).set("dmx.core.plugin_migration_nr", 0)));
    }

    private Topic fetchPluginTopic() {
        return this.dmx.getTopicByUri(this.pluginUri);
    }

    private void introduceTopicTypesToPlugin() {
        try {
            for (TopicType topicType : this.dmx.getAllTopicTypes()) {
                this.dispatchEvent(CoreEvent.INTRODUCE_TOPIC_TYPE, topicType);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Introducing topic types to " + this + " failed", e);
        }
    }

    private void introduceAssocTypesToPlugin() {
        try {
            for (AssocType assocType : this.dmx.getAllAssocTypes()) {
                this.dispatchEvent(CoreEvent.INTRODUCE_ASSOCIATION_TYPE, assocType);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Introducing association types to " + this + " failed", e);
        }
    }

    private void invokePreInstallHook() {
        this.pluginContext.preInstall();
    }

    private void invokeInitHook() {
        this.pluginContext.init();
    }

    private void invokeShutdownHook() {
        try {
            this.pluginContext.shutdown();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "An error occurred in the shutdown() hook of " + this + ":", e);
        }
    }

    private void registerListeners() {
        try {
            List<DMXEvent> events = this.getEvents();
            if (events.size() == 0) {
                this.logger.info("Registering event listeners of " + this + " SKIPPED -- no event listeners implemented");
                return;
            }
            this.logger.info("Registering " + events.size() + " event listeners of " + this);
            for (DMXEvent event : events) {
                this.dmx.em.addListener(event, (EventListener)((Object)this.pluginContext));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Registering event listeners of " + this + " failed", e);
        }
    }

    private void unregisterListeners() {
        List<DMXEvent> events = this.getEvents();
        if (events.size() == 0) {
            return;
        }
        this.logger.info("Unregistering event listeners of " + this);
        for (DMXEvent event : events) {
            this.dmx.em.removeListener(event, (EventListener)((Object)this.pluginContext));
        }
    }

    private List<DMXEvent> getEvents() {
        ArrayList<DMXEvent> events = new ArrayList<DMXEvent>();
        for (Class<?> interfaze : this.pluginContext.getClass().getInterfaces()) {
            if (!this.isListenerInterface(interfaze)) continue;
            DMXEvent event = DMXEvent.getEvent(interfaze);
            this.logger.fine("### EventListener Interface: " + interfaze + ", event=" + event);
            events.add(event);
        }
        return events;
    }

    private void dispatchEvent(DMXEvent event, Object ... params) {
        this.dmx.em.dispatchEvent(this, event, params);
    }

    private boolean isListenerInterface(Class interfaze) {
        return EventListener.class.isAssignableFrom(interfaze);
    }

    private void registerProvidedService() {
        try {
            if (this.providedServiceInterface == null) {
                this.logger.info("Registering OSGi service of " + this + " SKIPPED -- no OSGi service provided");
                return;
            }
            this.logger.info("Registering service \"" + this.providedServiceInterface + "\" at OSGi framework");
            this.bundleContext.registerService(this.providedServiceInterface, (Object)this.pluginContext, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Registering service of " + this + " at OSGi framework failed", e);
        }
    }

    private String providedServiceInterface() {
        List<Class<?>> serviceInterfaces = this.getInterfaces("Service");
        switch (serviceInterfaces.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return serviceInterfaces.get(0).getName();
            }
        }
        throw new RuntimeException("Only one service interface per plugin is supported");
    }

    private void publishWebResources() {
        String uriNamespace = null;
        try {
            uriNamespace = this.getWebResourcesNamespace();
            if (uriNamespace == null) {
                this.logger.info("Publishing web resources of " + this + " SKIPPED -- no web resources provided");
                return;
            }
            this.logger.info("Publishing web resources of " + this + " at URI namespace \"" + uriNamespace + "\"");
            this.webResources = this.dmx.wpService.publishWebResources(uriNamespace, this.pluginBundle);
        }
        catch (Exception e) {
            throw new RuntimeException("Publishing web resources of " + this + " failed (URI namespace=\"" + uriNamespace + "\")", e);
        }
    }

    private void unpublishWebResources() {
        if (this.webResources != null) {
            this.logger.info("Unpublishing web resources of " + this);
            this.webResources.unpublish();
        }
    }

    private String getWebResourcesNamespace() {
        return this.getBundleEntry("/web") != null ? "/" + this.pluginUri : null;
    }

    private URL getBundleEntry(String path) {
        return this.pluginBundle.getEntry(path);
    }

    private void unpublishFileSystem() {
        if (this.fileSystemResources != null) {
            this.logger.info("Unpublishing file system resources of " + this);
            this.fileSystemResources.unpublish();
        }
    }

    private void publishRestResources() {
        try {
            List<Object> rootResources = this.getRootResources();
            if (rootResources.size() != 0) {
                String uriNamespace = this.dmx.wpService.getUriNamespace(this.pluginContext);
                this.logger.info("Publishing REST resources of " + this + " at URI namespace \"" + uriNamespace + "\"");
            } else {
                this.logger.info("Publishing REST resources of " + this + " SKIPPED -- no REST resources provided");
            }
            List<Class<?>> providerClasses = this.getProviderClasses();
            if (providerClasses.size() != 0) {
                this.logger.info("Registering " + providerClasses.size() + " provider classes of " + this);
            } else {
                this.logger.info("Registering provider classes of " + this + " SKIPPED -- no provider classes found");
            }
            if (rootResources.size() != 0 || providerClasses.size() != 0) {
                this.restResources = this.dmx.wpService.publishRestResources(rootResources, providerClasses);
            }
        }
        catch (Exception e) {
            this.unpublishWebResources();
            throw new RuntimeException("Publishing REST resources (including provider classes) of " + this + " failed", e);
        }
    }

    private void unpublishRestResources() {
        if (this.restResources != null) {
            this.logger.info("Unpublishing REST resources (including provider classes) of " + this);
            this.restResources.unpublish();
        }
    }

    private List<Object> getRootResources() {
        ArrayList<Object> rootResources = new ArrayList<Object>();
        if (this.dmx.wpService.isRootResource(this.pluginContext)) {
            rootResources.add(this.pluginContext);
        }
        return rootResources;
    }

    private List<Class<?>> getProviderClasses() throws IOException {
        ArrayList providerClasses = new ArrayList();
        for (String className : this.scanPackage("/provider")) {
            Class clazz = this.loadClass(className);
            if (clazz == null) {
                throw new RuntimeException("Loading provider class \"" + className + "\" failed");
            }
            if (!this.dmx.wpService.isProviderClass(clazz)) continue;
            providerClasses.add(clazz);
        }
        return providerClasses;
    }

    private List<String> pluginDependencies() {
        ArrayList<String> pluginDependencies = new ArrayList<String>();
        String dependencies = this.getConfigProperty("dmx.plugin.dependencies");
        if (dependencies != null) {
            String[] pluginUris = dependencies.split(", *");
            for (int i = 0; i < pluginUris.length; ++i) {
                pluginDependencies.add(pluginUris[i]);
            }
        }
        if (!pluginDependencies.isEmpty()) {
            this.logger.info("Tracking " + pluginDependencies.size() + " plugins for " + this + " " + pluginDependencies);
        } else {
            this.logger.info("Tracking plugins for " + this + " SKIPPED -- no plugin dependencies declared");
        }
        return pluginDependencies;
    }

    private boolean hasDependency(String pluginUri) {
        return this.pluginDependencies.contains(pluginUri);
    }

    private boolean dependenciesAvailable() {
        for (String pluginUri : this.pluginDependencies) {
            if (this.isPluginActivated(pluginUri)) continue;
            return false;
        }
        return true;
    }

    private boolean isPluginActivated(String pluginUri) {
        return this.dmx.pluginManager.isPluginActivated(pluginUri);
    }

    private void registerPluginActivatedEventListener() {
        String[] topics = new String[]{PLUGIN_ACTIVATED};
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("event.topics", topics);
        this.bundleContext.registerService(EventHandler.class.getName(), (Object)this, properties);
    }

    private void postPluginActivatedEvent() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("bundle.symbolicName", this.pluginUri);
        this.eventService.postEvent(new Event(PLUGIN_ACTIVATED, properties));
    }

    public void handleEvent(Event event) {
        String pluginUri = null;
        try {
            if (!event.getTopic().equals(PLUGIN_ACTIVATED)) {
                throw new RuntimeException("Unexpected event: " + event);
            }
            pluginUri = (String)event.getProperty("bundle.symbolicName");
            if (!this.hasDependency(pluginUri)) {
                return;
            }
            this.checkRequirementsForActivation();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "", e);
        }
    }

    private String pluginName() {
        return this.pluginContext.getPluginName();
    }

    private List<Class<?>> getInterfaces(String suffix) {
        ArrayList interfaces = new ArrayList();
        for (Class<?> interfaze : this.pluginContext.getClass().getInterfaces()) {
            if (!interfaze.getName().endsWith(suffix)) continue;
            interfaces.add(interfaze);
        }
        return interfaces;
    }

    private List<String> scanResources(String path, String suffix) {
        ArrayList<String> fileNames = new ArrayList<String>();
        Enumeration e = this.pluginBundle.getEntryPaths(path);
        if (e != null) {
            while (e.hasMoreElements()) {
                String entryPath = (String)e.nextElement();
                this.logger.fine("  # Found resource: \"" + entryPath + "\"");
                if (!entryPath.endsWith(suffix)) continue;
                String fileName = new File(entryPath).getName();
                fileNames.add(fileName);
            }
        }
        return fileNames;
    }

    private List<String> scanPackage(String relativePath) {
        ArrayList<String> classNames = new ArrayList<String>();
        Enumeration<String> e = this.getPluginPaths(relativePath);
        if (e != null) {
            while (e.hasMoreElements()) {
                String entryPath = e.nextElement();
                String className = this.entryPathToClassName(entryPath);
                this.logger.fine("  # Found class: " + className);
                classNames.add(className);
            }
        }
        return classNames;
    }

    private Enumeration<String> getPluginPaths(String relativePath) {
        String path = "/" + this.pluginPackage.replace('.', '/') + relativePath;
        this.logger.fine("### Scanning path \"" + path + "\"");
        return this.pluginBundle.getEntryPaths(path);
    }

    private String entryPathToClassName(String entryPath) {
        entryPath = entryPath.substring(0, entryPath.length() - 6);
        return entryPath.replace('/', '.');
    }
}

