/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.service;

import com.sun.jersey.spi.container.ContainerRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Cookie;

public class Cookies {
    private Map<String, String> values = new HashMap<String, String>();
    private static final ThreadLocal<ContainerRequest> threadLocalRequest = new ThreadLocal();

    private Cookies() {
    }

    private Cookies(Collection<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            this.values.put(cookie.getName(), cookie.getValue());
        }
    }

    public String get(String name) {
        String value = this.values.get(name);
        if (value == null) {
            throw new RuntimeException("Missing \"" + name + "\" cookie (cookies=" + this.values + ")");
        }
        return value;
    }

    public long getLong(String name) {
        try {
            return Long.parseLong(this.get(name));
        }
        catch (Exception e) {
            throw new RuntimeException("Getting a long value for the \"" + name + "\" cookie failed", e);
        }
    }

    public boolean has(String name) {
        return this.values.get(name) != null;
    }

    public static Cookies get() {
        ContainerRequest request = threadLocalRequest.get();
        if (request != null) {
            return new Cookies(request.getCookies().values());
        }
        return new Cookies();
    }

    public static void set(ContainerRequest request) {
        threadLocalRequest.set(request);
    }

    public String toString() {
        return this.values.toString();
    }
}

