/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.DMXObjectModel;

class ChildTopicsFetcher {
    private AccessLayer al;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ChildTopicsFetcher(AccessLayer al) {
        this.al = al;
    }

    void fetch(DMXObjectModel object, CompDefModel compDef, boolean deep) {
        block7: {
            try {
                ChildTopicsModel childTopics = object.getChildTopics();
                String cardinalityUri = compDef.getChildCardinalityUri();
                String compDefUri = compDef.getCompDefUri();
                if (cardinalityUri.equals("dmx.core.one")) {
                    RelatedTopicModelImpl childTopic = this.fetchChildTopic(object.getId(), compDef);
                    if (childTopic != null) {
                        childTopics.set(compDefUri, childTopic);
                        if (deep) {
                            this.fetchChildTopics(childTopic, deep);
                        }
                    }
                    break block7;
                }
                if (cardinalityUri.equals("dmx.core.many")) {
                    for (RelatedTopicModelImpl childTopic : this.fetchChildTopics(object.getId(), compDef)) {
                        childTopics.add(compDefUri, childTopic);
                        if (!deep) continue;
                        this.fetchChildTopics(childTopic, deep);
                    }
                    break block7;
                }
                throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
            }
            catch (Exception e) {
                throw new RuntimeException("Fetching the \"" + compDef.getCompDefUri() + "\" child topics of object " + object.getId() + " failed", e);
            }
        }
    }

    private void fetchChildTopics(DMXObjectModelImpl object, boolean deep) {
        for (CompDefModel compDefModel : object.getType().getCompDefs()) {
            this.fetch(object, compDefModel, deep);
        }
    }

    private RelatedTopicModelImpl fetchChildTopic(long objectId, CompDefModel compDef) {
        return this.al.sd.fetchRelatedTopic(objectId, compDef.getInstanceLevelAssocTypeUri(), "dmx.core.parent", "dmx.core.child", compDef.getChildTypeUri());
    }

    private List<RelatedTopicModelImpl> fetchChildTopics(long objectId, CompDefModel compDef) {
        return this.al.db.fetchRelatedTopics(objectId, compDef.getInstanceLevelAssocTypeUri(), "dmx.core.parent", "dmx.core.child", compDef.getChildTypeUri());
    }
}

