/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import systems.dmx.core.Assoc;
import systems.dmx.core.AssocType;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.AssocImpl;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.AssocTypeImpl;
import systems.dmx.core.impl.AssocTypeModelImpl;
import systems.dmx.core.impl.EventManager;
import systems.dmx.core.impl.InstantiationIterable;
import systems.dmx.core.impl.MigrationManager;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.PluginImpl;
import systems.dmx.core.impl.PluginManager;
import systems.dmx.core.impl.PrivilegedAccessImpl;
import systems.dmx.core.impl.TopicImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicTypeImpl;
import systems.dmx.core.impl.TopicTypeModelImpl;
import systems.dmx.core.impl.WebPublishingService;
import systems.dmx.core.impl.WebSocketServiceImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.AssocTypeModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicTypeModel;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.service.PluginInfo;
import systems.dmx.core.service.RelatedTopicResult;
import systems.dmx.core.service.TopicResult;
import systems.dmx.core.service.accesscontrol.PrivilegedAccess;
import systems.dmx.core.storage.spi.DMXTransaction;

public class CoreServiceImpl
implements CoreService {
    BundleContext bundleContext;
    AccessLayer al;
    EventManager em;
    ModelFactoryImpl mf;
    PrivilegedAccess ac;
    MigrationManager migrationManager;
    PluginManager pluginManager;
    WebSocketServiceImpl wss;
    WebPublishingService wpService;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public CoreServiceImpl(AccessLayer al, BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.al = al;
        this.em = al.em;
        this.mf = al.mf;
        this.ac = new PrivilegedAccessImpl(al);
        this.migrationManager = new MigrationManager(this);
        this.pluginManager = new PluginManager(this);
        this.wss = new WebSocketServiceImpl(this);
        this.wpService = new WebPublishingService(al, this.wss);
        this.setupDB();
    }

    @Override
    public Topic getTopic(long topicId) {
        return this.al.getTopic(topicId).instantiate();
    }

    @Override
    public Topic getTopicByUri(String uri) {
        TopicModelImpl topic = this.al.getTopicByUri(uri);
        return topic != null ? topic.instantiate() : null;
    }

    @Override
    public List<Topic> getTopicsByType(String topicTypeUri) {
        return this.al.instantiate(this.al.getTopicsByType(topicTypeUri));
    }

    @Override
    public Iterable<Topic> getAllTopics() {
        return new InstantiationIterable(this.al.getAllTopics());
    }

    @Override
    public Topic getTopicByValue(String typeUri, SimpleValue value) {
        TopicModelImpl topic = this.al.getTopicByValue(typeUri, value);
        return topic != null ? topic.instantiate() : null;
    }

    @Override
    public List<Topic> getTopicsByValue(String typeUri, SimpleValue value) {
        return this.al.instantiate(this.al.getTopicsByValue(typeUri, value));
    }

    @Override
    public List<Topic> queryTopics(String typeUri, String query) {
        return this.al.instantiate(this.al.queryTopics(typeUri, query));
    }

    @Override
    public TopicResult queryTopicsFulltext(String query, String typeUri, boolean searchChildTopics) {
        return new TopicResult(query, typeUri, searchChildTopics, this.al.instantiate(this.al.queryTopicsFulltext(query, typeUri, searchChildTopics)));
    }

    @Override
    public TopicImpl createTopic(TopicModel model) {
        return this.al.createTopic((TopicModelImpl)model).instantiate();
    }

    @Override
    public void updateTopic(TopicModel updateModel) {
        this.al.updateTopic((TopicModelImpl)updateModel);
    }

    @Override
    public void deleteTopic(long topicId) {
        this.al.deleteTopic(topicId);
    }

    @Override
    public Assoc getAssoc(long assocId) {
        return this.al.getAssoc(assocId).instantiate();
    }

    @Override
    public List<PlayerModel> getPlayerModels(long assocId) {
        return this.al.getPlayerModels(assocId);
    }

    @Override
    public List<Assoc> getAssocsByType(String assocTypeUri) {
        return this.al.instantiate(this.al.getAssocsByType(assocTypeUri));
    }

    @Override
    public List<Assoc> getAssocs(long topic1Id, long topic2Id) {
        return this.al.instantiate(this.al.getAssocs(topic1Id, topic2Id));
    }

    @Override
    public List<Assoc> getAssocs(long topic1Id, long topic2Id, String assocTypeUri) {
        return this.al.instantiate(this.al.getAssocs(assocTypeUri, topic1Id, topic2Id));
    }

    @Override
    public Assoc getAssocBetweenTopicAndTopic(String assocTypeUri, long topic1Id, long topic2Id, String roleTypeUri1, String roleTypeUri2) {
        AssocModelImpl assoc = this.al.getAssocBetweenTopicAndTopic(assocTypeUri, topic1Id, topic2Id, roleTypeUri1, roleTypeUri2);
        return assoc != null ? assoc.instantiate() : null;
    }

    @Override
    public Assoc getAssocBetweenTopicAndAssoc(String assocTypeUri, long topicId, long assocId, String topicRoleTypeUri, String assocRoleTypeUri) {
        AssocModelImpl assoc = this.al.getAssocBetweenTopicAndAssoc(assocTypeUri, topicId, assocId, topicRoleTypeUri, assocRoleTypeUri);
        return assoc != null ? assoc.instantiate() : null;
    }

    @Override
    public Iterable<Assoc> getAllAssocs() {
        return new InstantiationIterable(this.al.getAllAssocs());
    }

    @Override
    public Assoc getAssocByValue(String typeUri, SimpleValue value) {
        AssocModelImpl assoc = this.al.getAssocByValue(typeUri, value);
        return assoc != null ? assoc.instantiate() : null;
    }

    @Override
    public List<Assoc> queryAssocs(String typeUri, String query) {
        return this.al.instantiate(this.al.queryAssocs(typeUri, query));
    }

    @Override
    public AssocImpl createAssoc(AssocModel model) {
        return this.al.createAssoc((AssocModelImpl)model).instantiate();
    }

    @Override
    public void updateAssoc(AssocModel updateModel) {
        this.al.updateAssoc((AssocModelImpl)updateModel);
    }

    @Override
    public void deleteAssoc(long assocId) {
        this.al.deleteAssoc(assocId);
    }

    @Override
    public TopicTypeImpl getTopicType(String uri) {
        return this.al.getTopicType(uri).instantiate();
    }

    @Override
    public TopicTypeImpl getTopicTypeImplicitly(long topicId) {
        return this.al.getTopicTypeImplicitly(topicId).instantiate();
    }

    @Override
    public List<TopicType> getAllTopicTypes() {
        return this.al.instantiate(this.al.getAllTopicTypes());
    }

    @Override
    public TopicTypeImpl createTopicType(TopicTypeModel model) {
        return this.al.createTopicType((TopicTypeModelImpl)model).instantiate();
    }

    @Override
    public void updateTopicType(TopicTypeModel updateModel) {
        this.al.updateTopicType((TopicTypeModelImpl)updateModel);
    }

    @Override
    public void deleteTopicType(String topicTypeUri) {
        this.al.deleteTopicType(topicTypeUri);
    }

    @Override
    public AssocTypeImpl getAssocType(String uri) {
        return this.al.getAssocType(uri).instantiate();
    }

    @Override
    public AssocTypeImpl getAssocTypeImplicitly(long assocId) {
        return this.al.getAssocTypeImplicitly(assocId).instantiate();
    }

    @Override
    public List<AssocType> getAllAssocTypes() {
        return this.al.instantiate(this.al.getAllAssocTypes());
    }

    @Override
    public AssocTypeImpl createAssocType(AssocTypeModel model) {
        return this.al.createAssocType((AssocTypeModelImpl)model).instantiate();
    }

    @Override
    public void updateAssocType(AssocTypeModel updateModel) {
        this.al.updateAssocType((AssocTypeModelImpl)updateModel);
    }

    @Override
    public void deleteAssocType(String assocTypeUri) {
        this.al.deleteAssocType(assocTypeUri);
    }

    @Override
    public Topic createRoleType(TopicModel model) {
        return this.al.createRoleType((TopicModelImpl)model).instantiate();
    }

    @Override
    public DMXObject getObject(long id) {
        return this.al.getObject(id).instantiate();
    }

    @Override
    public RelatedTopicResult query(String topicQuery, String topicTypeUri, boolean searchTopicChildren, String assocQuery, String assocTypeUri, boolean searchAssocChildren) {
        return new RelatedTopicResult(topicQuery, topicTypeUri, searchTopicChildren, assocQuery, assocTypeUri, searchAssocChildren, this.al.instantiate(this.al.query(topicQuery, topicTypeUri, searchTopicChildren, assocQuery, assocTypeUri, searchAssocChildren)));
    }

    @Override
    public PluginImpl getPlugin(String pluginUri) {
        return this.pluginManager.getPlugin(pluginUri);
    }

    @Override
    public List<PluginInfo> getPluginInfo() {
        return this.pluginManager.getPluginInfo();
    }

    @Override
    public void fireEvent(DMXEvent event, Object ... params) {
        this.em.fireEvent(event, params);
    }

    @Override
    public void dispatchEvent(String pluginUri, DMXEvent event, Object ... params) {
        this.em.dispatchEvent(this.getPlugin(pluginUri), event, params);
    }

    @Override
    public Object getProperty(long id, String propUri) {
        return this.al.db.fetchProperty(id, propUri);
    }

    @Override
    public boolean hasProperty(long id, String propUri) {
        return this.al.db.hasProperty(id, propUri);
    }

    @Override
    public List<Topic> getTopicsByProperty(String propUri, Object propValue) {
        return this.al.instantiate(this.al.getTopicsByProperty(propUri, propValue));
    }

    @Override
    public List<Topic> getTopicsByPropertyRange(String propUri, Number from, Number to) {
        return this.al.instantiate(this.al.getTopicsByPropertyRange(propUri, from, to));
    }

    @Override
    public List<Assoc> getAssocsByProperty(String propUri, Object propValue) {
        return this.al.instantiate(this.al.getAssocsByProperty(propUri, propValue));
    }

    @Override
    public List<Assoc> getAssocsByPropertyRange(String propUri, Number from, Number to) {
        return this.al.instantiate(this.al.getAssocsByPropertyRange(propUri, from, to));
    }

    @Override
    public void addTopicPropertyIndex(String propUri) {
        int topics = 0;
        int added = 0;
        this.logger.info("########## Adding topic property index for \"" + propUri + "\"");
        for (Topic topic : this.getAllTopics()) {
            if (topic.hasProperty(propUri)) {
                Object value = topic.getProperty(propUri);
                this.al.db.indexTopicProperty(topic.getId(), propUri, value);
                ++added;
            }
            ++topics;
        }
        this.logger.info("########## Adding topic property index complete\n    Topics processed: " + topics + "\n    added to index: " + added);
    }

    @Override
    public void addAssocPropertyIndex(String propUri) {
        int assocs = 0;
        int added = 0;
        this.logger.info("########## Adding association property index for \"" + propUri + "\"");
        for (Assoc assoc : this.getAllAssocs()) {
            if (assoc.hasProperty(propUri)) {
                Object value = assoc.getProperty(propUri);
                this.al.db.indexAssocProperty(assoc.getId(), propUri, value);
                ++added;
            }
            ++assocs;
        }
        this.logger.info("########## Adding association property complete\n    Associations processed: " + assocs + "\n    added to index: " + added);
    }

    @Override
    public DMXTransaction beginTx() {
        return this.al.db.beginTx();
    }

    @Override
    public ModelFactory getModelFactory() {
        return this.mf;
    }

    @Override
    public PrivilegedAccess getPrivilegedAccess() {
        return this.ac;
    }

    @Override
    public WebSocketServiceImpl getWebSocketService() {
        return this.wss;
    }

    @Override
    public Object getDatabaseVendorObject() {
        return this.al.db.getDatabaseVendorObject();
    }

    public void shutdown() {
        this.wss.stop();
    }

    Assoc createAssoc(String typeUri, PlayerModel player1, PlayerModel player2) {
        return this.createAssoc(this.mf.newAssocModel(typeUri, player1, player2));
    }

    private void setupDB() {
        DMXTransaction tx = this.beginTx();
        try {
            this.logger.info("----- Setting up the database -----");
            boolean isCleanInstall = this.al.sd.init();
            if (isCleanInstall) {
                this.setupBootstrapContent();
            }
            this.migrationManager.runCoreMigrations(isCleanInstall);
            tx.success();
            tx.finish();
            this.logger.info("----- Setting up the database complete -----");
        }
        catch (Exception e) {
            this.logger.warning("ROLLBACK!");
            tx.finish();
            this.al.db.shutdown();
            throw new RuntimeException("Setting up the database failed", e);
        }
    }

    private void setupBootstrapContent() {
        try {
            TopicModelImpl t = this.mf.newTopicModel("dmx.core.topic_type", "dmx.core.meta_type", new SimpleValue("Topic Type"));
            TopicModelImpl a = this.mf.newTopicModel("dmx.core.assoc_type", "dmx.core.meta_type", new SimpleValue("Association Type"));
            this._createTopic(t);
            this._createTopic(a);
            TopicTypeModelImpl dataType = this.mf.newTopicTypeModel("dmx.core.data_type", "Data Type", "dmx.core.text");
            this._createTopic(dataType);
            TopicModelImpl text = this.mf.newTopicModel("dmx.core.text", "dmx.core.data_type", new SimpleValue("Text"));
            this._createTopic(text);
            AssocTypeModelImpl composition = this.mf.newAssocTypeModel("dmx.core.composition", "Composition", "dmx.core.text");
            this._createTopic(composition);
            AssocTypeModelImpl instn = this.mf.newAssocTypeModel("dmx.core.instantiation", "Instantiation", "dmx.core.text");
            this._createTopic(instn);
            this.al.createTopicInstantiation(t.getId(), t.getTypeUri());
            this.al.createTopicInstantiation(a.getId(), a.getTypeUri());
            this.al.createTopicInstantiation(dataType.getId(), dataType.getTypeUri());
            this.al.createTopicInstantiation(text.getId(), text.getTypeUri());
            this.al.createTopicInstantiation(composition.getId(), composition.getTypeUri());
            this.al.createTopicInstantiation(instn.getId(), instn.getTypeUri());
            this._associateDataType("dmx.core.meta_type", "dmx.core.text");
            this._associateDataType("dmx.core.topic_type", "dmx.core.text");
            this._associateDataType("dmx.core.assoc_type", "dmx.core.text");
            this._associateDataType("dmx.core.data_type", "dmx.core.text");
            this._associateDataType("dmx.core.composition", "dmx.core.text");
            this._associateDataType("dmx.core.instantiation", "dmx.core.text");
        }
        catch (Exception e) {
            throw new RuntimeException("Setting up the bootstrap content failed", e);
        }
    }

    private void _createTopic(TopicModelImpl model) {
        this.al.db.storeTopic(model);
        this.al.db.storeTopicValue(model.id, model.value, model.typeUri, false);
    }

    private void _associateDataType(String typeUri, String dataTypeUri) {
        AssocModelImpl assoc = this.mf.newAssocModel("dmx.core.composition", this.mf.newTopicPlayerModel(typeUri, "dmx.core.parent"), this.mf.newTopicPlayerModel(dataTypeUri, "dmx.core.child"));
        this.al.db.storeAssoc(assoc);
        this.al.db.storeAssocValue(assoc.id, assoc.value, assoc.typeUri, false);
    }
}

