/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.Assoc;
import systems.dmx.core.AssocType;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.EventManager;
import systems.dmx.core.service.Directives;
import systems.dmx.core.service.DirectivesResponse;
import systems.dmx.core.service.RelatedTopicResult;
import systems.dmx.core.service.TopicResult;
import systems.dmx.core.service.websocket.WebSocketService;

class JerseyResponseFilter
implements ContainerResponseFilter {
    private EventManager em;
    private WebSocketService wss;
    @Context
    private HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    JerseyResponseFilter(EventManager em, WebSocketService wss) {
        this.em = em;
        this.wss = wss;
    }

    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        try {
            this.em.fireEvent(CoreEvent.SERVICE_RESPONSE_FILTER, response);
            Object entity = response.getEntity();
            if (entity != null) {
                boolean includeChildren = this.getIncludeChildren(request);
                boolean includeAssocChildren = this.getIncludeAssocChildren(request);
                if (entity instanceof DMXObject) {
                    this.loadChildTopics((DMXObject)entity, includeChildren, includeAssocChildren);
                } else if (this.isIterable(response, DMXObject.class)) {
                    this.loadChildTopics((Iterable)entity, includeChildren, includeAssocChildren);
                }
                Directives directives = null;
                if (entity instanceof DMXObject) {
                    this.firePreSend((DMXObject)entity);
                } else if (this.isIterable(response, DMXObject.class)) {
                    this.firePreSend((Iterable)entity);
                } else if (entity instanceof TopicResult) {
                    this.firePreSend(((TopicResult)entity).topics);
                } else if (entity instanceof RelatedTopicResult) {
                    this.firePreSend(((RelatedTopicResult)entity).topics);
                } else if (entity instanceof DirectivesResponse) {
                    this.firePreSend(((DirectivesResponse)entity).getObject());
                    directives = ((DirectivesResponse)entity).getDirectives();
                    this.firePreSend(directives);
                }
                if (directives != null) {
                    this.broadcast(directives);
                }
            }
            Directives.remove();
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException("Response filtering failed", e);
        }
    }

    private void loadChildTopics(DMXObject object, boolean includeChildren, boolean includeAssocChildren) {
        if (includeChildren) {
            object.loadChildTopics();
            if (includeAssocChildren) {
                this.loadRelatingAssocChildTopics(object);
            }
        }
    }

    private void loadChildTopics(Iterable<DMXObject> objects, boolean includeChildren, boolean includeAssocChildren) {
        for (DMXObject object : objects) {
            this.loadChildTopics(object, includeChildren, includeChildren);
        }
    }

    private void loadRelatingAssocChildTopics(DMXObject object) {
        ChildTopics childTopics = object.getChildTopics();
        for (String childTypeUri : childTopics) {
            Object value = childTopics.get(childTypeUri);
            if (value instanceof RelatedTopic) {
                RelatedTopic childTopic = (RelatedTopic)value;
                childTopic.getRelatingAssoc().loadChildTopics();
                this.loadRelatingAssocChildTopics(childTopic);
                continue;
            }
            if (value instanceof List) {
                for (RelatedTopic childTopic : (List)value) {
                    childTopic.getRelatingAssoc().loadChildTopics();
                    this.loadRelatingAssocChildTopics(childTopic);
                }
                continue;
            }
            throw new RuntimeException("Unexpected \"" + childTypeUri + "\" value in ChildTopics: " + value);
        }
    }

    private void firePreSend(DMXObject object) {
        if (object instanceof TopicType) {
            this.em.fireEvent(CoreEvent.PRE_SEND_TOPIC_TYPE, object);
        } else if (object instanceof AssocType) {
            this.em.fireEvent(CoreEvent.PRE_SEND_ASSOCIATION_TYPE, object);
        } else if (object instanceof Topic) {
            this.em.fireEvent(CoreEvent.PRE_SEND_TOPIC, object);
        } else if (object instanceof Assoc) {
            this.em.fireEvent(CoreEvent.PRE_SEND_ASSOCIATION, object);
        }
    }

    private void firePreSend(Iterable<? extends DMXObject> objects) {
        for (DMXObject dMXObject : objects) {
            this.firePreSend(dMXObject);
        }
    }

    private void firePreSend(Directives directives) {
        for (Directives.Entry entry : directives) {
            switch (entry.dir) {
                case UPDATE_TOPIC: 
                case UPDATE_ASSOCIATION: 
                case UPDATE_TOPIC_TYPE: 
                case UPDATE_ASSOCIATION_TYPE: {
                    this.firePreSend((DMXObject)entry.arg);
                }
            }
        }
    }

    private void broadcast(Directives directives) throws JSONException {
        JSONObject message = new JSONObject().put("type", (Object)"processDirectives").put("args", (Object)directives.toJSONArray());
        this.wss.sendToAllButOrigin(message.toString());
    }

    private boolean isIterable(ContainerResponse response, Class elementType) {
        Type genericType = response.getEntityType();
        if (genericType instanceof ParameterizedType) {
            Type[] typeArgs = ((ParameterizedType)genericType).getActualTypeArguments();
            Class<?> type = response.getEntity().getClass();
            if (typeArgs.length == 1 && Iterable.class.isAssignableFrom(type) && elementType.isAssignableFrom((Class)typeArgs[0])) {
                return true;
            }
        }
        return false;
    }

    private boolean getIncludeChildren(ContainerRequest request) {
        return this.getBooleanQueryParameter(request, "children");
    }

    private boolean getIncludeAssocChildren(ContainerRequest request) {
        return this.getBooleanQueryParameter(request, "assocChildren");
    }

    private boolean getBooleanQueryParameter(ContainerRequest request, String param) {
        return Boolean.parseBoolean((String)request.getQueryParameters().getFirst((Object)param));
    }
}

