/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import systems.dmx.core.service.websocket.WebSocketService;

public class Messages
implements Iterable<Message> {
    private List<Message> messages = new ArrayList<Message>();
    private static Logger logger = Logger.getLogger("systems.dmx.core.service.Messages");
    private static final ThreadLocal<Messages> threadLocalDirectives = new ThreadLocal(){

        protected Messages initialValue() {
            logger.fine("### Creating tread-local messages");
            return new Messages();
        }
    };

    public static Messages get() {
        return threadLocalDirectives.get();
    }

    public void add(Dest dest, String message, Object ... params) {
        this.messages.add(new Message(dest, message, params));
    }

    public static void remove() {
        logger.fine("### Removing tread-local messages");
        threadLocalDirectives.remove();
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }

    public class Message {
        public Dest dest;
        public String message;
        public Object[] params;

        private Message(Dest dest, String message, Object[] params) {
            this.dest = dest;
            this.message = message;
            this.params = params;
        }
    }

    public static enum Dest {
        ORIGIN{

            @Override
            public void send(Message message, WebSocketService wss) {
                wss.sendToOrigin(message.message);
            }
        }
        ,
        ALL{

            @Override
            public void send(Message message, WebSocketService wss) {
                wss.sendToAll(message.message);
            }
        }
        ,
        ALL_BUT_ORIGIN{

            @Override
            public void send(Message message, WebSocketService wss) {
                wss.sendToAllButOrigin(message.message);
            }
        }
        ,
        READ_ALLOWED{

            @Override
            public void send(Message message, WebSocketService wss) {
                wss.sendToReadAllowed(message.message, (Long)message.params[0]);
            }
        }
        ,
        SOME{

            @Override
            public void send(Message message, WebSocketService wss) {
                wss.sendToSome(message.message, (Predicate)message.params[0]);
            }
        };


        public abstract void send(Message var1, WebSocketService var2);
    }
}

