/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import systems.dmx.core.Player;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.model.PlayerModel;

abstract class PlayerModelImpl
implements PlayerModel {
    long id = -1L;
    String roleTypeUri;
    DMXObjectModelImpl object;
    AccessLayer al;
    ModelFactoryImpl mf;

    PlayerModelImpl(long playerId, String roleTypeUri, AccessLayer al) {
        this.id = playerId;
        this.setRoleTypeUri(roleTypeUri);
        this.al = al;
        this.mf = al.mf;
    }

    @Override
    public final long getId() {
        if (this.id == -1L) {
            throw new IllegalStateException("No player ID set in " + this);
        }
        return this.id;
    }

    @Override
    public final String getTypeUri() {
        return (String)this.al.db.fetchProperty(this.getId(), "typeUri");
    }

    @Override
    public final String getRoleTypeUri() {
        return this.roleTypeUri;
    }

    @Override
    public final void setRoleTypeUri(String roleTypeUri) {
        if (roleTypeUri == null) {
            throw new IllegalArgumentException("\"roleTypeUri\" must not be null");
        }
        this.roleTypeUri = roleTypeUri;
    }

    @Override
    public PlayerModel clone() {
        try {
            return (PlayerModel)super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning a PlayerModel failed", e);
        }
    }

    public String toString() {
        try {
            return this.getClass().getSimpleName() + " " + this.toJSON().toString(4);
        }
        catch (Exception e) {
            throw new RuntimeException("Prettyprinting failed", e);
        }
    }

    abstract Player instantiate(AssocModelImpl var1);

    abstract DMXObjectModelImpl getDMXObject(AssocModelImpl var1);

    <M extends DMXObjectModelImpl> M getDMXObject() {
        if (this.object == null) {
            this.object = this.al.db.fetchObject(this.getId());
        }
        return (M)this.object;
    }
}

