/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.websocket.WebSocket;
import systems.dmx.core.impl.WebSocketConnectionImpl;
import systems.dmx.core.impl.WebSocketConnectionPool;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.util.JavaUtils;

public class WebSocketServlet
extends org.eclipse.jetty.websocket.WebSocketServlet {
    private WebSocketConnectionPool pool;
    private CoreService dmx;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    WebSocketServlet(WebSocketConnectionPool pool, CoreService dmx) {
        this.pool = pool;
        this.dmx = dmx;
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        try {
            this.checkProtocol(protocol);
            return new WebSocketConnectionImpl(protocol, this.clientId(request), this.session(request), this.pool, this.dmx);
        }
        catch (Exception e) {
            throw new RuntimeException("Opening a WebSocket connection " + (protocol != null ? "for plugin \"" + protocol + "\" " : "") + "failed", e);
        }
    }

    private void checkProtocol(String pluginUri) {
        if (pluginUri == null) {
            throw new RuntimeException("A plugin URI is missing in the WebSocket handshake -- Add your plugin's URI as the 2nd argument to the JavaScript WebSocket constructor");
        }
        this.dmx.getPlugin(pluginUri);
    }

    private String clientId(HttpServletRequest request) {
        String clientId = JavaUtils.cookieValue(request, "dmx_client_id");
        if (clientId == null) {
            throw new RuntimeException("Missing \"dmx_client_id\" cookie in connection upgrade request");
        }
        return clientId;
    }

    private HttpSession session(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new RuntimeException("No (valid) session associated with connection upgrade request");
        }
        return session;
    }
}

