/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.service.ChangeReport;
import systems.dmx.core.util.DMXUtils;

class ChangeReportImpl
implements ChangeReport {
    private Map<String, List<ChangeReport.Change>> changes = new HashMap<String, List<ChangeReport.Change>>();

    ChangeReportImpl() {
    }

    @Override
    public List<ChangeReport.Change> getChanges(String compDefUri) {
        return this.changes.get(compDefUri);
    }

    @Override
    public JSONObject toJSON() {
        try {
            JSONObject o = new JSONObject();
            for (String compDefUri : this.changes.keySet()) {
                o.put(compDefUri, (Object)DMXUtils.toJSONArray((Iterable<? extends JSONEnabled>)this.changes.get(compDefUri)));
            }
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    public String toString() {
        return this.dump();
    }

    void add(String compDefUri, TopicModelImpl newValue, RelatedTopicModelImpl oldValue) {
        List<ChangeReport.Change> l = this.changes.get(compDefUri);
        if (l == null) {
            l = new ArrayList<ChangeReport.Change>();
            this.changes.put(compDefUri, l);
        }
        l.add(new ChangeReport.Change(newValue, oldValue));
    }
}

