/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.util;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.service.accesscontrol.AccessControlException;
import systems.dmx.core.util.JavaUtils;

public class UniversalExceptionMapper {
    private static Response.StatusType METHOD_NOT_ALLOWED = new Response.StatusType(){

        public int getStatusCode() {
            return 405;
        }

        public String getReasonPhrase() {
            return "Method Not Allowed";
        }

        public Response.Status.Family getFamily() {
            return Response.Status.Family.CLIENT_ERROR;
        }
    };
    private Throwable e;
    private HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public UniversalExceptionMapper(Throwable e, HttpServletRequest request) {
        this.e = e;
        this.request = request;
    }

    public Response toResponse() {
        Response response;
        if (this.e instanceof WebApplicationException) {
            response = ((WebApplicationException)this.e).getResponse();
            Response.StatusType status = this.fromStatusCode(response.getStatus());
            Response.Status.Family family = status.getFamily();
            if (family == Response.Status.Family.CLIENT_ERROR || family == Response.Status.Family.SERVER_ERROR) {
                Throwable cause = this.e.getCause();
                Throwable originalException = cause != null ? cause : this.e;
                this.logException(status, originalException);
                if (response.getEntity() == null) {
                    response = this.errorResponse(Response.fromResponse((Response)response), originalException);
                }
            }
        } else {
            Response.Status status = this.hasNestedAccessControlException(this.e) ? Response.Status.UNAUTHORIZED : Response.Status.INTERNAL_SERVER_ERROR;
            this.logException((Response.StatusType)status, this.e);
            response = this.errorResponse(Response.status((Response.StatusType)status), this.e);
        }
        return response;
    }

    public void initResponse(HttpServletResponse response) throws IOException {
        this.transferResponse(this.toResponse(), response);
    }

    private void logException(Response.StatusType status, Throwable e) {
        this.logger.log(Level.SEVERE, "Request \"" + JavaUtils.requestInfo(this.request) + "\" failed. Responding with " + JavaUtils.responseInfo(status) + ". The original exception/error is:", e);
    }

    private Response errorResponse(Response.ResponseBuilder builder, Throwable e) {
        return builder.type("application/json").entity((Object)new ErrorReport(e)).build();
    }

    private boolean hasNestedAccessControlException(Throwable e) {
        while (e != null) {
            if (e instanceof AccessControlException) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    private Response.StatusType fromStatusCode(int statusCode) {
        Response.StatusType status;
        if (statusCode == 405) {
            status = METHOD_NOT_ALLOWED;
        } else {
            status = Response.Status.fromStatusCode((int)statusCode);
            if (status == null) {
                throw new RuntimeException(statusCode + " is an unexpected status code");
            }
        }
        return status;
    }

    private void transferResponse(Response response, HttpServletResponse servletResponse) throws IOException {
        servletResponse.setStatus(response.getStatus());
        MultivaluedMap metadata = response.getMetadata();
        for (String header : metadata.keySet()) {
            for (Object value : (List)metadata.get((Object)header)) {
                servletResponse.addHeader(header, value.toString());
            }
        }
        servletResponse.getWriter().write(response.getEntity().toString());
    }

    private static class ErrorReport
    implements JSONEnabled {
        private JSONObject json;

        private ErrorReport(Throwable e) {
            try {
                String problem = e.getMessage();
                String cause = this.getRootCause(e).getMessage();
                this.json = new JSONObject().put("problem", (Object)(problem != null ? problem : "")).put("cause", (Object)(cause != null ? cause : ""));
            }
            catch (JSONException je) {
                throw new RuntimeException("Generating error report failed", je);
            }
        }

        private Throwable getRootCause(Throwable e) {
            Throwable cause;
            while ((cause = e.getCause()) != null) {
                e = cause;
            }
            return e;
        }

        @Override
        public JSONObject toJSON() {
            return this.json;
        }

        public String toString() {
            return this.json.toString();
        }
    }
}

