/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.listener;

import java.util.ArrayList;
import java.util.Iterator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractListenerManager<ListenerType>
extends ServiceTracker {
    private ArrayList<ListenerType> allContextListeners;
    private final Object lock = new Object();

    protected AbstractListenerManager(BundleContext context, Class<ListenerType> clazz) {
        super(context, clazz.getName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Iterator<ListenerType> getContextListeners() {
        ArrayList<Object> result = this.allContextListeners;
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.allContextListeners == null) {
                    Object[] services = this.getServices();
                    if (services != null && services.length > 0) {
                        result = new ArrayList(services.length);
                        for (Object service : services) {
                            result.add(service);
                        }
                    } else {
                        result = new ArrayList(0);
                    }
                    this.allContextListeners = result;
                } else {
                    result = this.allContextListeners;
                }
            }
        }
        return result.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        Object object = this.lock;
        synchronized (object) {
            this.allContextListeners = null;
        }
        return super.addingService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference reference, Object service) {
        Object object = this.lock;
        synchronized (object) {
            this.allContextListeners = null;
        }
        super.modifiedService(reference, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        Object object = this.lock;
        synchronized (object) {
            this.allContextListeners = null;
        }
        super.removedService(reference, service);
    }
}

