/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicReferenceModel;
import systems.dmx.core.model.ViewConfigModel;

class ViewConfigModelImpl
implements ViewConfigModel {
    private Map<String, TopicModelImpl> configTopics;
    private ModelFactoryImpl mf;

    ViewConfigModelImpl(Map<String, TopicModelImpl> configTopics, AccessLayer al) {
        this.configTopics = configTopics;
        this.mf = al.mf;
    }

    public Iterable<TopicModelImpl> getConfigTopics() {
        return this.configTopics.values();
    }

    @Override
    public TopicModelImpl getConfigTopic(String configTypeUri) {
        return this.configTopics.get(configTypeUri);
    }

    @Override
    public ViewConfigModel addConfigTopic(TopicModel configTopic) {
        String configTypeUri = configTopic.getTypeUri();
        if (this.getConfigTopic(configTypeUri) != null) {
            throw new RuntimeException("There is already a view configuration topic of type \"" + configTypeUri + "\"");
        }
        this.putConfigTopic(configTopic);
        return this;
    }

    @Override
    public void updateConfigTopic(TopicModel configTopic) {
        String configTypeUri = configTopic.getTypeUri();
        if (this.getConfigTopic(configTypeUri) == null) {
            throw new RuntimeException("There is no view configuration topic of type \"" + configTypeUri + "\"");
        }
        this.putConfigTopic(configTopic);
    }

    @Override
    public ViewConfigModel setConfigValue(String configTypeUri, String childTypeUri, Object value) {
        TopicModelImpl configTopic = this.getConfigTopic(configTypeUri);
        if (configTopic == null) {
            this.addConfigTopic(this.mf.newTopicModel(configTypeUri, this.mf.newChildTopicsModel().set(childTypeUri, value)));
        } else {
            configTopic.getChildTopics().set(childTypeUri, value);
        }
        return this;
    }

    @Override
    public ViewConfigModel setConfigValueRef(String configTypeUri, String childTypeUri, Object topicIdOrUri) {
        TopicModelImpl configTopic = this.getConfigTopic(configTypeUri);
        TopicReferenceModel valueRef = this.mf.newTopicReferenceModel(topicIdOrUri);
        if (configTopic == null) {
            this.addConfigTopic(this.mf.newTopicModel(configTypeUri, this.mf.newChildTopicsModel().set(childTypeUri, valueRef)));
        } else {
            configTopic.getChildTopics().set(childTypeUri, valueRef);
        }
        return this;
    }

    @Override
    public Object getConfigValue(String configTypeUri, String childTypeUri) {
        TopicModelImpl configTopic = this.getConfigTopic(configTypeUri);
        if (configTopic == null) {
            return null;
        }
        return configTopic.getChildTopics().getValue(childTypeUri, null);
    }

    @Override
    public JSONArray toJSONArray() {
        try {
            JSONArray configTopics = new JSONArray();
            for (TopicModel topicModel : this.getConfigTopics()) {
                configTopics.put((Object)topicModel.toJSON());
            }
            return configTopics;
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    public String toString() {
        return "view configuration " + this.configTopics;
    }

    public void putConfigTopic(TopicModel configTopic) {
        this.configTopics.put(configTopic.getTypeUri(), (TopicModelImpl)configTopic);
    }
}

