/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.config.ConfigDefinition;
import systems.dmx.config.ConfigDefinitions;
import systems.dmx.config.ConfigModificationRole;
import systems.dmx.config.ConfigService;
import systems.dmx.config.ConfigTarget;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.DirectivesResponse;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.PrivilegedAccess;
import systems.dmx.core.service.event.PostCreateTopic;

@Path(value="/config")
@Produces(value={"application/json"})
public class ConfigPlugin
extends PluginActivator
implements ConfigService,
PostCreateTopic {
    private Map<String, List<ConfigDefinition>> registry = new HashMap<String, List<ConfigDefinition>>();
    @Context
    private HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    public ConfigDefinitions getConfigDefs() {
        try {
            JSONObject json = new JSONObject();
            PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
            for (String configurableUri : this.registry.keySet()) {
                JSONArray array = new JSONArray();
                for (ConfigDefinition configDef : this.lookupConfigDefinitions(configurableUri)) {
                    long workspaceId;
                    String username = pa.getUsername(this.request);
                    if (!pa.hasReadPermission(username, workspaceId = this.workspaceId(configDef.getConfigModificationRole()))) continue;
                    array.put((Object)configDef.getConfigTypeUri());
                }
                json.put(configurableUri, (Object)array);
            }
            return new ConfigDefinitions(json);
        }
        catch (Exception e) {
            throw new RuntimeException("Retrieving the registered config definitions failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/{configTypeUri}/topic/{topicId}")
    public RelatedTopic getConfigTopic(@PathParam(value="configTypeUri") String configTypeUri, @PathParam(value="topicId") long topicId) {
        return this._getConfigTopic(configTypeUri, topicId);
    }

    @Override
    @PUT
    @Path(value="/topic/{topicId}")
    @Transactional
    public DirectivesResponse updateConfigTopic(@PathParam(value="topicId") long topicId, TopicModel updateModel) {
        try {
            Topic topic = this.dmx.getTopic(topicId);
            String configTypeUri = updateModel.getTypeUri();
            RelatedTopic oldConfigTopic = this.getConfigTopic(configTypeUri, topicId);
            ConfigDefinition configDef = this.getApplicableConfigDefinition(topic, configTypeUri);
            long workspaceId = this.workspaceId(configDef.getConfigModificationRole());
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(workspaceId, () -> {
                Topic configTopic = this.dmx.createTopic(updateModel);
                if (!configTopic.equals(oldConfigTopic)) {
                    this.logger.info("change " + oldConfigTopic.getId() + " -> " + configTopic.getId());
                    oldConfigTopic.getRelatingAssoc().delete();
                    this.createConfigAssoc(topic, configTopic);
                } else {
                    this.logger.info("no change");
                }
                return null;
            });
            return new DirectivesResponse();
        }
        catch (Exception e) {
            throw new RuntimeException("Updating config for topic " + topicId + " failed", e);
        }
    }

    @Override
    public void createConfigTopic(String configTypeUri, Topic topic) {
        this._createConfigTopic(this.getApplicableConfigDefinition(topic, configTypeUri), topic);
    }

    @Override
    public void registerConfigDefinition(ConfigDefinition configDef) {
        try {
            if (this.isRegistered(configDef)) {
                throw new RuntimeException("A definition for config type \"" + configDef.getConfigTypeUri() + "\" is already registered");
            }
            String hashKey = configDef.getHashKey();
            List<ConfigDefinition> configDefs = this.lookupConfigDefinitions(hashKey);
            if (configDefs == null) {
                configDefs = new ArrayList<ConfigDefinition>();
                this.registry.put(hashKey, configDefs);
            }
            configDefs.add(configDef);
        }
        catch (Exception e) {
            throw new RuntimeException("Registering a config definition failed", e);
        }
    }

    @Override
    public void unregisterConfigDefinition(String configTypeUri) {
        try {
            for (List<ConfigDefinition> configDefs : this.registry.values()) {
                ConfigDefinition configDef = this.findByConfigTypeUri(configDefs, configTypeUri);
                if (configDef == null) continue;
                if (!configDefs.remove(configDef)) {
                    throw new RuntimeException("Config definition could not be removed from registry");
                }
                return;
            }
            throw new RuntimeException("No such config definition registered");
        }
        catch (Exception e) {
            throw new RuntimeException("Unregistering definition for config type \"" + configTypeUri + "\" failed", e);
        }
    }

    public void postCreateTopic(Topic topic) {
        for (ConfigDefinition configDef : this.getApplicableConfigDefinitions(topic)) {
            this._createConfigTopic(configDef, topic);
        }
    }

    private RelatedTopic _getConfigTopic(String configTypeUri, long topicId) {
        return this.dmx.getPrivilegedAccess().getConfigTopic(configTypeUri, topicId);
    }

    private RelatedTopic _createConfigTopic(ConfigDefinition configDef, Topic topic) {
        String configTypeUri = configDef.getConfigTypeUri();
        try {
            this.logger.info("### Creating config topic of type \"" + configTypeUri + "\" for topic " + topic.getId());
            PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
            long workspaceId = this.workspaceId(configDef.getConfigModificationRole());
            return (RelatedTopic)pa.runInWorkspaceContext(workspaceId, () -> {
                Topic configTopic = this.dmx.createTopic(configDef.getConfigValue(topic));
                this.createConfigAssoc(topic, configTopic);
                return this._getConfigTopic(configTypeUri, topic.getId());
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Creating config topic of type \"" + configTypeUri + "\" for topic " + topic.getId() + " failed", e);
        }
    }

    private void createConfigAssoc(Topic topic, Topic configTopic) {
        this.dmx.createAssoc(this.mf.newAssocModel("dmx.config.configuration", (PlayerModel)this.mf.newTopicPlayerModel(topic.getId(), "dmx.config.configurable"), (PlayerModel)this.mf.newTopicPlayerModel(configTopic.getId(), "dmx.core.default")));
    }

    private long workspaceId(ConfigModificationRole role) {
        PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
        switch (role) {
            case ADMIN: {
                return pa.getAdminWorkspaceId();
            }
            case SYSTEM: {
                return pa.getSystemWorkspaceId();
            }
        }
        throw new RuntimeException("Modification role \"" + (Object)((Object)role) + "\" not yet implemented");
    }

    private List<ConfigDefinition> getApplicableConfigDefinitions(Topic topic) {
        ArrayList configDefs1 = this.lookupConfigDefinitions(ConfigTarget.SINGLETON.hashKey(topic));
        List<ConfigDefinition> configDefs2 = this.lookupConfigDefinitions(ConfigTarget.TYPE_INSTANCES.hashKey(topic));
        if (configDefs1 != null && configDefs2 != null) {
            ArrayList<ConfigDefinition> configDefs = new ArrayList<ConfigDefinition>();
            configDefs.addAll(configDefs1);
            configDefs.addAll(configDefs2);
            return configDefs;
        }
        return configDefs1 != null ? configDefs1 : (configDefs2 != null ? configDefs2 : new ArrayList());
    }

    private ConfigDefinition getApplicableConfigDefinition(Topic topic, String configTypeUri) {
        List<ConfigDefinition> configDefs = this.getApplicableConfigDefinitions(topic);
        if (configDefs.size() == 0) {
            throw new RuntimeException("None of the registered config definitions are applicable to " + this.info(topic));
        }
        ConfigDefinition configDef = this.findByConfigTypeUri(configDefs, configTypeUri);
        if (configDef == null) {
            throw new RuntimeException("For " + this.info(topic) + " no config definition for type \"" + configTypeUri + "\" registered");
        }
        return configDef;
    }

    private boolean isRegistered(ConfigDefinition configDef) {
        for (List<ConfigDefinition> configDefs : this.registry.values()) {
            if (!configDefs.contains(configDef)) continue;
            return true;
        }
        return false;
    }

    private ConfigDefinition findByConfigTypeUri(List<ConfigDefinition> configDefs, String configTypeUri) {
        for (ConfigDefinition configDef : configDefs) {
            if (!configDef.getConfigTypeUri().equals(configTypeUri)) continue;
            return configDef;
        }
        return null;
    }

    private List<ConfigDefinition> lookupConfigDefinitions(String hashKey) {
        return this.registry.get(hashKey);
    }

    private String info(Topic topic) {
        return "topic " + topic.getId() + " (value=\"" + topic.getSimpleValue() + "\", typeUri=\"" + topic.getTypeUri() + "\", uri=\"" + topic.getUri() + "\")";
    }
}

