/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.files;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import systems.dmx.files.DiskQuotaCheck;

public class UploadedFile {
    private String name;
    private long size;
    private InputStream in;
    private DiskQuotaCheck diskQuotaCheck;

    public UploadedFile(String name, long size, InputStream in, DiskQuotaCheck diskQuotaCheck) {
        this.name = name;
        this.size = size;
        this.in = in;
        this.diskQuotaCheck = diskQuotaCheck;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "\"" + this.name + "\" (" + this.size + " bytes)";
    }

    void write(File file) {
        try {
            this.diskQuotaCheck.check(this.size);
            FileOutputStream out = new FileOutputStream(file);
            IOUtils.copy((InputStream)this.in, (OutputStream)out);
            this.in.close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            throw new RuntimeException("Writing uploaded file to disk failed (" + this + ")", e);
        }
    }
}

