/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.util;

import java.util.Iterator;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.ModelFactory;

public class ChildTopicsSequence
implements Iterable<RelatedTopic> {
    private Topic parentTopic;
    private String childTypeUri;
    private String assocTypeUri;
    private CoreService dmx;
    private ModelFactory mf;

    public ChildTopicsSequence(Topic parentTopic, String childTypeUri, String assocTypeUri, CoreService dmx) {
        this.parentTopic = parentTopic;
        this.childTypeUri = childTypeUri;
        this.assocTypeUri = assocTypeUri;
        this.dmx = dmx;
        this.mf = dmx.getModelFactory();
    }

    @Override
    public Iterator<RelatedTopic> iterator() {
        return new Iterator(){
            private RelatedTopic topic;
            {
                this.topic = ChildTopicsSequence.this.getFirst();
            }

            @Override
            public boolean hasNext() {
                return this.topic != null;
            }

            public RelatedTopic next() {
                RelatedTopic _topic = this.topic;
                this.topic = ChildTopicsSequence.this.getSuccessor(this.topic);
                return _topic;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Topic insert(Topic childTopic, Topic predChildTopic) {
        long childTopicId = childTopic.getId();
        if (predChildTopic != null) {
            this.checkParent(predChildTopic);
            long predChildTopicId = predChildTopic.getId();
            RelatedTopic succ = this.getSuccessor(predChildTopic);
            if (succ != null) {
                this.insertInBetween(childTopicId, predChildTopicId, succ);
            } else {
                this.createSequenceSegment(predChildTopicId, childTopicId);
            }
        } else {
            RelatedTopic first = this.getFirst();
            if (first != null) {
                this.insertAtBegin(childTopicId, first);
            } else {
                this.createSequenceStart(childTopicId);
            }
        }
        return childTopic;
    }

    public void remove(Topic childTopic) {
        this.checkParent(childTopic);
        RelatedTopic pred = this.getPredecessor(childTopic);
        RelatedTopic succ = this.getSuccessor(childTopic);
        if (succ != null) {
            succ.getRelatingAssoc().delete();
        }
        if (pred != null) {
            pred.getRelatingAssoc().delete();
            if (succ != null) {
                this.createSequenceSegment(pred.getId(), succ.getId());
            }
        } else {
            this.getFirst().getRelatingAssoc().delete();
            if (succ != null) {
                this.createSequenceStart(succ.getId());
            }
        }
    }

    private void insertAtBegin(long childTopicId, RelatedTopic firstChildTopic) {
        firstChildTopic.getRelatingAssoc().delete();
        this.createSequenceStart(childTopicId);
        this.createSequenceSegment(childTopicId, firstChildTopic.getId());
    }

    private void insertInBetween(long childTopicId, long predChildTopicId, RelatedTopic succChildTopic) {
        succChildTopic.getRelatingAssoc().delete();
        this.createSequenceSegment(predChildTopicId, childTopicId);
        this.createSequenceSegment(childTopicId, succChildTopic.getId());
    }

    private void createSequenceStart(long childTopicId) {
        this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", this.mf.newTopicPlayerModel(this.parentTopic.getId(), "dmx.core.parent"), this.mf.newTopicPlayerModel(childTopicId, "dmx.core.sequence_start")));
    }

    private void createSequenceSegment(long predTopicId, long succTopicId) {
        this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.sequence", this.mf.newTopicPlayerModel(predTopicId, "dmx.core.predecessor"), this.mf.newTopicPlayerModel(succTopicId, "dmx.core.successor")));
    }

    private RelatedTopic getPredecessor(Topic childTopic) {
        return childTopic.getRelatedTopic("dmx.core.sequence", "dmx.core.successor", "dmx.core.predecessor", this.childTypeUri);
    }

    private RelatedTopic getSuccessor(Topic childTopic) {
        return childTopic.getRelatedTopic("dmx.core.sequence", "dmx.core.predecessor", "dmx.core.successor", this.childTypeUri);
    }

    private RelatedTopic getFirst() {
        return this.parentTopic.getRelatedTopic("dmx.core.association", "dmx.core.parent", "dmx.core.sequence_start", this.childTypeUri);
    }

    private void checkParent(Topic node) {
        if (!this.getParentNode(node).equals(this.parentTopic)) {
            throw new RuntimeException("Node " + node.getId() + " is not a child of node " + this.parentTopic.getId());
        }
    }

    private RelatedTopic getParentNode(Topic node) {
        RelatedTopic parentNode = this.getParentNodeIfExists(node);
        if (parentNode == null) {
            throw new RuntimeException("Node " + node.getId() + " has no parent node");
        }
        return parentNode;
    }

    private RelatedTopic getParentNodeIfExists(Topic node) {
        return node.getRelatedTopic(this.assocTypeUri, "dmx.core.child", "dmx.core.parent", this.parentTopic.getTypeUri());
    }
}

