/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.util;

import java.util.Iterator;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.ModelFactory;

public class ChildTopicsSequence
implements Iterable<RelatedTopic> {
    private Topic parentTopic;
    private String childTypeUri;
    private String assocTypeUri;
    private CoreService dmx;
    private ModelFactory mf;

    public ChildTopicsSequence(Topic parentTopic, String childTypeUri, String assocTypeUri, CoreService dmx) {
        this.parentTopic = parentTopic;
        this.childTypeUri = childTypeUri;
        this.assocTypeUri = assocTypeUri;
        this.dmx = dmx;
        this.mf = dmx.getModelFactory();
    }

    @Override
    public Iterator<RelatedTopic> iterator() {
        return new Iterator(){
            private RelatedTopic topic;
            {
                this.topic = ChildTopicsSequence.this.getFirst();
            }

            @Override
            public boolean hasNext() {
                return this.topic != null;
            }

            public RelatedTopic next() {
                RelatedTopic _topic = this.topic;
                this.topic = ChildTopicsSequence.this.getSuccessor(this.topic);
                return _topic;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Topic add(Topic childTopic, Topic beforeChildTopic) {
        long childTopicId = childTopic.getId();
        if (beforeChildTopic != null) {
            this.checkChildTopic(beforeChildTopic);
            RelatedTopic pred = this.getPredecessor(beforeChildTopic);
            if (pred != null) {
                this.insertInBetween(childTopicId, pred, beforeChildTopic.getId());
            } else {
                this.insertAtBegin(childTopicId, this.getFirst());
            }
        } else {
            RelatedTopic last = this.getLast();
            if (last != null) {
                this.createSequenceSegment(last.getId(), childTopicId);
            } else {
                this.createSequenceStart(childTopicId);
            }
        }
        return childTopic;
    }

    public void remove(Topic childTopic) {
        this.checkChildTopic(childTopic);
        RelatedTopic pred = this.getPredecessor(childTopic);
        RelatedTopic succ = this.getSuccessor(childTopic);
        if (succ != null) {
            succ.getRelatingAssoc().delete();
        }
        if (pred != null) {
            pred.getRelatingAssoc().delete();
            if (succ != null) {
                this.createSequenceSegment(pred.getId(), succ.getId());
            }
        } else {
            this.getFirst().getRelatingAssoc().delete();
            if (succ != null) {
                this.createSequenceStart(succ.getId());
            }
        }
    }

    private void insertAtBegin(long childTopicId, RelatedTopic firstChildTopic) {
        firstChildTopic.getRelatingAssoc().delete();
        this.createSequenceStart(childTopicId);
        this.createSequenceSegment(childTopicId, firstChildTopic.getId());
    }

    private void insertInBetween(long childTopicId, RelatedTopic predChildTopic, long succChildTopicId) {
        predChildTopic.getRelatingAssoc().delete();
        this.createSequenceSegment(predChildTopic.getId(), childTopicId);
        this.createSequenceSegment(childTopicId, succChildTopicId);
    }

    private void createSequenceStart(long childTopicId) {
        this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.sequence", this.mf.newTopicPlayerModel(this.parentTopic.getId(), "dmx.core.default"), this.mf.newTopicPlayerModel(childTopicId, "dmx.core.sequence_start")));
    }

    private void createSequenceSegment(long predTopicId, long succTopicId) {
        this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.sequence", this.mf.newTopicPlayerModel(predTopicId, "dmx.core.predecessor"), this.mf.newTopicPlayerModel(succTopicId, "dmx.core.successor")));
    }

    private RelatedTopic getPredecessor(Topic childTopic) {
        return childTopic.getRelatedTopic("dmx.core.sequence", "dmx.core.successor", "dmx.core.predecessor", this.childTypeUri);
    }

    private RelatedTopic getSuccessor(Topic childTopic) {
        return childTopic.getRelatedTopic("dmx.core.sequence", "dmx.core.predecessor", "dmx.core.successor", this.childTypeUri);
    }

    private RelatedTopic getFirst() {
        return this.parentTopic.getRelatedTopic("dmx.core.sequence", "dmx.core.default", "dmx.core.sequence_start", this.childTypeUri);
    }

    private RelatedTopic getLast() {
        RelatedTopic childTopic2 = null;
        for (RelatedTopic childTopic2 : this) {
        }
        return childTopic2;
    }

    private void checkChildTopic(Topic topic) {
        if (!this.getParentTopic(topic).equals(this.parentTopic)) {
            throw new RuntimeException("Topic " + topic.getId() + " is not a child of topic " + this.parentTopic.getId());
        }
    }

    private RelatedTopic getParentTopic(Topic topic) {
        RelatedTopic parentTopic = this.getParentTopicIfExists(topic);
        if (parentTopic == null) {
            throw new RuntimeException("Topic " + topic.getId() + " has no parent topic");
        }
        return parentTopic;
    }

    private RelatedTopic getParentTopicIfExists(Topic topic) {
        return topic.getRelatedTopic(this.assocTypeUri, "dmx.core.child", "dmx.core.parent", this.parentTopic.getTypeUri());
    }
}

