/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.AssocImpl;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.service.accesscontrol.Operation;
import systems.dmx.core.service.accesscontrol.PrivilegedAccess;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.util.ContextTracker;

class PrivilegedAccessImpl
implements PrivilegedAccess {
    private static final String USER_ACCOUNT = "dmx.accesscontrol.user_account";
    private static final String USERNAME = "dmx.accesscontrol.username";
    private static final String PASSWORD = "dmx.accesscontrol.password";
    private static final String WORKSPACE = "dmx.workspaces.workspace";
    private static final String SHARING_MODE = "dmx.workspaces.sharing_mode";
    private static final String EMAIL_ADDRESS = "dmx.contacts.email_address";
    private static final String MEMBERSHIP = "dmx.accesscontrol.membership";
    private static final String WORKSPACE_ASSIGNMENT = "dmx.workspaces.workspace_assignment";
    private static final String TOPICMAP_CONTEXT = "dmx.topicmaps.topicmap_context";
    private static final String CONFIGURATION = "dmx.config.configuration";
    private static final String USER_MAILBOX = "dmx.base.user_mailbox";
    private static final String CONFIGURABLE = "dmx.config.configurable";
    private static final String PROP_CREATOR = "dmx.accesscontrol.creator";
    private static final String PROP_OWNER = "dmx.accesscontrol.owner";
    private static final String PROP_WORKSPACE_ID = "dmx.workspaces.workspace_id";
    private static final String DMX_WORKSPACE_URI = "dmx.workspaces.dmx";
    private static final String ADMIN_WORKSPACE_URI = "dmx.workspaces.administration";
    private static final String SYSTEM_WORKSPACE_URI = "dmx.workspaces.system";
    private static final String ENCODED_PASSWORD_PREFIX = "-SHA256-";
    private ContextTracker contextTracker = new ContextTracker();
    private AccessLayer al;
    private ModelFactoryImpl mf;
    private long dmxWorkspaceId = -1L;
    private long adminWorkspaceId = -1L;
    private long systemWorkspaceId = -1L;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    PrivilegedAccessImpl(AccessLayer al) {
        this.al = al;
        this.mf = al.mf;
    }

    @Override
    public boolean hasPermission(String username, Operation operation, long objectId) {
        String typeUri = null;
        try {
            long workspaceId;
            typeUri = this.getTypeUri(objectId);
            if (typeUri.equals(WORKSPACE)) {
                workspaceId = objectId;
            } else {
                workspaceId = this.getAssignedWorkspaceId(objectId);
                if (workspaceId == -1L) {
                    return this.permissionIfNoWorkspaceIsAssigned(operation, objectId, typeUri);
                }
            }
            return this._hasPermission(username, operation, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Checking permission for object " + objectId + " failed, typeUri=" + typeUri + ", " + this.userInfo(username) + ", operation=" + (Object)((Object)operation), e);
        }
    }

    @Override
    public boolean hasReadPermission(String username, long workspaceId) {
        SharingMode sharingMode = this.getSharingMode(workspaceId);
        switch (sharingMode) {
            case PRIVATE: {
                return this.isOwner(username, workspaceId);
            }
            case CONFIDENTIAL: {
                return this.isOwner(username, workspaceId) || this.isMember(username, workspaceId);
            }
            case COLLABORATIVE: {
                return this.isOwner(username, workspaceId) || this.isMember(username, workspaceId);
            }
            case PUBLIC: {
                return workspaceId != this.getSystemWorkspaceId() || username != null;
            }
            case COMMON: {
                return true;
            }
        }
        throw new RuntimeException((Object)((Object)sharingMode) + " is an unsupported sharing mode");
    }

    @Override
    public boolean hasWritePermission(String username, long workspaceId) {
        SharingMode sharingMode = this.getSharingMode(workspaceId);
        switch (sharingMode) {
            case PRIVATE: {
                return this.isOwner(username, workspaceId);
            }
            case CONFIDENTIAL: {
                return this.isOwner(username, workspaceId);
            }
            case COLLABORATIVE: {
                return this.isOwner(username, workspaceId) || this.isMember(username, workspaceId);
            }
            case PUBLIC: {
                return this.isOwner(username, workspaceId) || this.isMember(username, workspaceId);
            }
            case COMMON: {
                return true;
            }
        }
        throw new RuntimeException((Object)((Object)sharingMode) + " is an unsupported sharing mode");
    }

    @Override
    public Topic checkCredentials(Credentials cred) {
        TopicModelImpl usernameTopic = null;
        try {
            usernameTopic = this._getUsernameTopic(cred.username);
            if (usernameTopic == null) {
                return null;
            }
            if (!this.matches(usernameTopic, cred.password)) {
                return null;
            }
            return usernameTopic.instantiate();
        }
        catch (Exception e) {
            throw new RuntimeException("Checking credentials for user \"" + cred.username + "\" failed, usernameTopic=" + usernameTopic, e);
        }
    }

    @Override
    public void changePassword(Credentials cred) {
        try {
            this.logger.info("##### Changing password for user \"" + cred.username + "\"");
            TopicModelImpl password = this.getPasswordTopic(this._getUsernameTopicOrThrow(cred.username));
            password._updateSimpleValue(new SimpleValue(cred.password));
        }
        catch (Exception e) {
            throw new RuntimeException("Changing password for user \"" + cred.username + "\" failed", e);
        }
    }

    @Override
    public Topic getUsernameTopic(String username) {
        TopicModelImpl usernameTopic = this._getUsernameTopic(username);
        return usernameTopic != null ? usernameTopic.instantiate() : null;
    }

    @Override
    public Topic getPrivateWorkspace(String username) {
        try {
            for (TopicModelImpl workspace : this.fetchTopicsByOwner(username, WORKSPACE)) {
                if (this.getSharingMode(workspace.getId()) != SharingMode.PRIVATE) continue;
                return workspace.instantiate();
            }
            throw new RuntimeException("User \"" + username + "\" has no private workspace");
        }
        catch (Exception e) {
            throw new RuntimeException("Private workspace of user \"" + username + "\" can't be determined", e);
        }
    }

    @Override
    public void createMembership(String username, long workspaceId) {
        try {
            Assoc membership = this.runInWorkspaceContext(-1L, () -> this.al.createAssoc(this.mf.newAssocModel(MEMBERSHIP, this.mf.newTopicPlayerModel(this._getUsernameTopicOrThrow(username).getId(), "dmx.core.default"), this.mf.newTopicPlayerModel(workspaceId, "dmx.core.default"))).instantiate());
            this.assignToWorkspace(membership, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating membership for user \"" + username + "\" and workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public boolean isMember(String username, long workspaceId) {
        try {
            if (username == null) {
                return false;
            }
            AssocModelImpl membership = this.al.sd.fetchAssoc(MEMBERSHIP, this._getUsernameTopicOrThrow(username).getId(), workspaceId, "dmx.core.default", "dmx.core.default");
            return membership != null;
        }
        catch (Exception e) {
            throw new RuntimeException("Checking membership of user \"" + username + "\" and workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public String getCreator(long objectId) {
        return this.al.db.hasProperty(objectId, PROP_CREATOR) ? (String)this.al.db.fetchProperty(objectId, PROP_CREATOR) : null;
    }

    @Override
    public String getUsername(HttpServletRequest request) {
        try {
            HttpSession session = request.getSession(false);
            if (session == null) {
                return null;
            }
            return this.username(session);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public Topic getUsernameTopic(HttpServletRequest request) {
        String username = this.getUsername(request);
        if (username == null) {
            return null;
        }
        return this._getUsernameTopicOrThrow(username).instantiate();
    }

    @Override
    public String username(HttpSession session) {
        return (String)session.getAttribute("username");
    }

    @Override
    public Topic getWorkspace(String uri) {
        return this._getWorkspace(uri).instantiate();
    }

    @Override
    public long getDMXWorkspaceId() {
        if (this.dmxWorkspaceId == -1L) {
            this.dmxWorkspaceId = this._getWorkspace(DMX_WORKSPACE_URI).getId();
        }
        return this.dmxWorkspaceId;
    }

    @Override
    public long getAdminWorkspaceId() {
        if (this.adminWorkspaceId == -1L) {
            this.adminWorkspaceId = this._getWorkspace(ADMIN_WORKSPACE_URI).getId();
        }
        return this.adminWorkspaceId;
    }

    @Override
    public long getSystemWorkspaceId() {
        if (this.systemWorkspaceId == -1L) {
            this.systemWorkspaceId = this._getWorkspace(SYSTEM_WORKSPACE_URI).getId();
        }
        return this.systemWorkspaceId;
    }

    @Override
    public long getAssignedWorkspaceId(long objectId) {
        try {
            long workspaceId = -1L;
            if (this.al.db.hasProperty(objectId, PROP_WORKSPACE_ID)) {
                workspaceId = (Long)this.al.db.fetchProperty(objectId, PROP_WORKSPACE_ID);
                this.checkWorkspaceId(workspaceId);
            }
            return workspaceId;
        }
        catch (Exception e) {
            throw new RuntimeException("Workspace assignment of object " + objectId + " can't be determined", e);
        }
    }

    @Override
    public void assignToWorkspace(DMXObject object, long workspaceId) {
        try {
            long _workspaceId = this.getAssignedWorkspaceId(object.getId());
            if (_workspaceId == -1L) {
                this.al.createAssoc(WORKSPACE_ASSIGNMENT, object.getModel().createPlayerModel("dmx.core.parent"), this.mf.newTopicPlayerModel(workspaceId, "dmx.core.child"));
                object.setProperty(PROP_WORKSPACE_ID, workspaceId, true);
            } else if (_workspaceId != workspaceId) {
                throw new RuntimeException("object " + object.getId() + " is already assigned to workspace " + _workspaceId);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Assigning object " + object.getId() + " to workspace " + workspaceId + " failed, object=" + object, e);
        }
    }

    @Override
    public <V> V runInWorkspaceContext(long workspaceId, Callable<V> callable) throws Exception {
        return this.contextTracker.run(workspaceId, callable);
    }

    @Override
    public Long getWorkspaceContext() {
        return this.contextTracker.getValue();
    }

    @Override
    public void deleteAssocMapcontext(Assoc assoc) {
        if (!assoc.getTypeUri().equals(TOPICMAP_CONTEXT)) {
            throw new RuntimeException("Assoc " + assoc.getId() + " not eligible for privileged deletion, assoc=" + assoc);
        }
        ((AssocImpl)assoc).getModel().delete();
    }

    @Override
    public RelatedTopic getConfigTopic(String configTypeUri, long topicId) {
        try {
            RelatedTopicModelImpl configTopic = this.al.sd.fetchTopicRelatedTopic(topicId, CONFIGURATION, CONFIGURABLE, "dmx.core.default", configTypeUri);
            if (configTopic == null) {
                throw new RuntimeException("The \"" + configTypeUri + "\" configuration topic for topic " + topicId + " is missing");
            }
            return configTopic.instantiate();
        }
        catch (Exception e) {
            throw new RuntimeException("Getting the \"" + configTypeUri + "\" configuration topic for topic " + topicId + " failed", e);
        }
    }

    @Override
    public String getUsername(String emailAddress) {
        try {
            String username = this._getUsername(emailAddress);
            if (username == null) {
                throw new RuntimeException("No username is assigned to email address \"" + emailAddress + "\"");
            }
            return username;
        }
        catch (Exception e) {
            throw new RuntimeException("Getting the username for email address \"" + emailAddress + "\" failed", e);
        }
    }

    @Override
    public String getEmailAddress(String username) {
        try {
            String emailAddress = this._getEmailAddress(username);
            if (emailAddress == null) {
                throw new RuntimeException("No email address is assigned to username \"" + username + "\"");
            }
            return emailAddress;
        }
        catch (Exception e) {
            throw new RuntimeException("Getting the email address for username \"" + username + "\" failed", e);
        }
    }

    @Override
    public boolean emailAddressExists(String emailAddress) {
        return this._getUsername(emailAddress) != null;
    }

    private boolean matches(TopicModel usernameTopic, String password) {
        String _password = this.getPasswordTopic(usernameTopic).getSimpleValue().toString();
        if (!_password.startsWith(ENCODED_PASSWORD_PREFIX)) {
            throw new RuntimeException("Stored password is not SHA256 encoded");
        }
        return _password.equals(password);
    }

    private TopicModelImpl getPasswordTopic(TopicModel usernameTopic) {
        return this._getPasswordTopic(this._getUserAccount(usernameTopic));
    }

    private TopicModelImpl _getUserAccount(TopicModel usernameTopic) {
        RelatedTopicModelImpl userAccount = this.al.sd.fetchTopicRelatedTopic(usernameTopic.getId(), "dmx.core.composition", "dmx.core.child", "dmx.core.parent", USER_ACCOUNT);
        if (userAccount == null) {
            throw new RuntimeException("No User Account topic for username \"" + usernameTopic.getSimpleValue() + "\", usernameTopic=" + usernameTopic);
        }
        return userAccount;
    }

    private TopicModelImpl _getPasswordTopic(TopicModel userAccount) {
        RelatedTopicModelImpl password = this.al.sd.fetchTopicRelatedTopic(userAccount.getId(), "dmx.core.composition", "dmx.core.parent", "dmx.core.child", PASSWORD);
        if (password == null) {
            throw new RuntimeException("No Password topic for User Account \"" + userAccount.getSimpleValue() + "\", userAccount=" + userAccount);
        }
        return password;
    }

    private boolean permissionIfNoWorkspaceIsAssigned(Operation operation, long objectId, String typeUri) {
        switch (operation) {
            case READ: {
                this.logger.fine("Object " + objectId + " (typeUri=" + typeUri + ") is not assigned to any workspace -- READ permission is granted");
                return true;
            }
            case WRITE: {
                this.logger.warning("Object " + objectId + " (typeUri=" + typeUri + ") is not assigned to any workspace -- WRITE permission is refused");
                return false;
            }
        }
        throw new RuntimeException((Object)((Object)operation) + " is an unsupported operation");
    }

    private boolean _hasPermission(String username, Operation operation, long workspaceId) {
        switch (operation) {
            case READ: {
                return this.hasReadPermission(username, workspaceId);
            }
            case WRITE: {
                return this.hasWritePermission(username, workspaceId);
            }
        }
        throw new RuntimeException((Object)((Object)operation) + " is an unsupported operation");
    }

    private boolean isOwner(String username, long workspaceId) {
        try {
            if (username == null) {
                return false;
            }
            return this.getOwner(workspaceId).equals(username);
        }
        catch (Exception e) {
            throw new RuntimeException("Checking ownership of workspace " + workspaceId + " and user \"" + username + "\" failed", e);
        }
    }

    private SharingMode getSharingMode(long workspaceId) {
        RelatedTopicModelImpl sharingMode = this.al.sd.fetchTopicRelatedTopic(workspaceId, "dmx.core.composition", "dmx.core.parent", "dmx.core.child", SHARING_MODE);
        if (sharingMode == null) {
            throw new RuntimeException("No sharing mode is assigned to workspace " + workspaceId);
        }
        return SharingMode.fromString(sharingMode.getUri());
    }

    private void checkWorkspaceId(long workspaceId) {
        String typeUri = this.getTypeUri(workspaceId);
        if (!typeUri.equals(WORKSPACE)) {
            throw new RuntimeException("Object " + workspaceId + " is not a workspace, but a \"" + typeUri + "\"");
        }
    }

    private String getOwner(long workspaceId) {
        if (!this.al.db.hasProperty(workspaceId, PROP_OWNER)) {
            throw new RuntimeException("No owner is assigned to workspace " + workspaceId);
        }
        return (String)this.al.db.fetchProperty(workspaceId, PROP_OWNER);
    }

    private String getTypeUri(long objectId) {
        return (String)this.al.db.fetchProperty(objectId, "typeUri");
    }

    private TopicModelImpl _getUsernameTopic(String username) {
        return this.al.sd.fetchTopic(USERNAME, username);
    }

    private TopicModelImpl _getUsernameTopicOrThrow(String username) {
        TopicModelImpl usernameTopic = this._getUsernameTopic(username);
        if (usernameTopic == null) {
            throw new RuntimeException("Unknown user \"" + username + "\"");
        }
        return usernameTopic;
    }

    private String _getUsername(String emailAddress) {
        String username = null;
        for (TopicModelImpl emailAddressTopic : this.al.db.fetchTopics(EMAIL_ADDRESS, emailAddress)) {
            RelatedTopicModelImpl usernameTopic = emailAddressTopic.getRelatedTopic(USER_MAILBOX, "dmx.core.child", "dmx.core.parent", USERNAME);
            if (usernameTopic == null) continue;
            if (username != null) {
                throw new RuntimeException("Ambiguity: the Username assignment for email address \"" + emailAddress + "\" is not unique");
            }
            username = usernameTopic.getSimpleValue().toString();
        }
        return username;
    }

    private String _getEmailAddress(String username) {
        RelatedTopicModelImpl emailAddress = this._getUsernameTopicOrThrow(username).getRelatedTopic(USER_MAILBOX, "dmx.core.parent", "dmx.core.child", EMAIL_ADDRESS);
        return emailAddress != null ? emailAddress.getSimpleValue().toString() : null;
    }

    private List<TopicModelImpl> fetchTopicsByOwner(String username, String typeUri) {
        ArrayList<TopicModelImpl> topics = new ArrayList<TopicModelImpl>();
        for (TopicModelImpl topic : this.al.db.fetchTopicsByProperty(PROP_OWNER, username)) {
            if (!topic.getTypeUri().equals(typeUri)) continue;
            topics.add(topic);
        }
        return topics;
    }

    private TopicModelImpl _getWorkspace(String uri) {
        TopicModelImpl workspace = this.al.sd.fetchTopic("uri", uri);
        if (workspace == null) {
            throw new RuntimeException("Unknown workspace \"" + uri + "\"");
        }
        if (!workspace.getTypeUri().equals(WORKSPACE)) {
            throw new RuntimeException("Topic \"" + uri + "\" is not a workspace but a \"" + workspace.getTypeUri() + "\"");
        }
        return workspace;
    }

    private String userInfo(String username) {
        return "user " + (username != null ? "\"" + username + "\"" : "<anonymous>");
    }
}

