/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Assoc;
import systems.dmx.core.RelatedAssoc;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.ModelFactory;

public class ChildTopicsSequence
implements Iterable<RelatedAssoc> {
    private Topic parentTopic;
    private String childTypeUri;
    private String assocTypeUri;
    private CoreService dmx;
    private ModelFactory mf;
    private CycleDetection detection;

    public ChildTopicsSequence(Topic parentTopic, String childTypeUri, String assocTypeUri, CoreService dmx) {
        this.parentTopic = parentTopic;
        this.childTypeUri = childTypeUri;
        this.assocTypeUri = assocTypeUri;
        this.dmx = dmx;
        this.mf = dmx.getModelFactory();
    }

    @Override
    public Iterator<RelatedAssoc> iterator() {
        return new Iterator(){
            private RelatedAssoc assoc;
            {
                this.assoc = ChildTopicsSequence.this.getFirstAssoc();
            }

            @Override
            public boolean hasNext() {
                return this.assoc != null;
            }

            public RelatedAssoc next() {
                RelatedAssoc _assoc = this.assoc;
                this.assoc = ChildTopicsSequence.this.getSuccessorAssoc(this.assoc);
                return _assoc;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Topic insert(long childTopicId, long predTopicId) {
        try {
            RelatedTopic childTopic = this.getChildTopic(childTopicId);
            this._insert(childTopic.getRelatingAssoc(), predTopicId);
            return childTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Inserting topic " + childTopicId + " into sequence of parent topic " + this.parentTopic.getId() + " failed (predTopicId=" + predTopicId + ")", e);
        }
    }

    public void insert(Assoc assoc, long predTopicId) {
        try {
            this._insert(assoc, predTopicId);
        }
        catch (Exception e) {
            throw new RuntimeException("Inserting association " + assoc.getId() + " into sequence of parent topic " + this.parentTopic.getId() + " failed (predTopicId=" + predTopicId + ")", e);
        }
    }

    public RelatedTopic remove(long childTopicId) {
        try {
            RelatedTopic childTopic = this.getChildTopic(childTopicId);
            this._remove(childTopic.getRelatingAssoc());
            return childTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Removing topic " + childTopicId + " from sequence of parent topic " + this.parentTopic.getId() + " failed", e);
        }
    }

    public RelatedTopic remove(Assoc assoc) {
        try {
            this._remove(assoc);
            return this.childTopic(assoc);
        }
        catch (Exception e) {
            throw new RuntimeException("Removing association " + assoc.getId() + " from sequence of parent topic " + this.parentTopic.getId() + " failed", e);
        }
    }

    private void _insert(Assoc assoc, long predTopicId) {
        long assocId = assoc.getId();
        if (predTopicId != -1L) {
            Assoc predAssoc = this.getChildTopic(predTopicId).getRelatingAssoc();
            RelatedAssoc succAssoc = this.getSuccessorAssoc(predAssoc);
            if (succAssoc != null) {
                this.insertInBetween(assocId, predAssoc, succAssoc);
            } else {
                this.createSequenceSegment(predAssoc.getId(), assocId);
            }
        } else {
            RelatedAssoc first = this.getFirstAssoc();
            if (first != null) {
                this.insertAtBegin(assocId, first);
            } else {
                this.createSequenceStart(assocId);
            }
        }
    }

    private void _remove(Assoc assoc) {
        RelatedAssoc pred = this.getPredecessorAssoc(assoc);
        RelatedAssoc succ = this.getSuccessorAssoc(assoc);
        if (succ != null) {
            succ.getRelatingAssoc().delete();
        }
        if (pred != null) {
            pred.getRelatingAssoc().delete();
            if (succ != null) {
                this.createSequenceSegment(pred.getId(), succ.getId());
            }
        } else {
            this.getFirstAssoc().getRelatingAssoc().delete();
            if (succ != null) {
                this.createSequenceStart(succ.getId());
            }
        }
    }

    private void insertAtBegin(long assocId, RelatedAssoc firstChildAssoc) {
        firstChildAssoc.getRelatingAssoc().delete();
        this.createSequenceStart(assocId);
        this.createSequenceSegment(assocId, firstChildAssoc.getId());
    }

    private void insertInBetween(long assocId, Assoc predAssoc, RelatedAssoc succAssoc) {
        succAssoc.getRelatingAssoc().delete();
        this.createSequenceSegment(predAssoc.getId(), assocId);
        this.createSequenceSegment(assocId, succAssoc.getId());
    }

    private void createSequenceStart(long assocId) {
        this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.sequence", this.mf.newTopicPlayerModel(this.parentTopic.getId(), "dmx.core.default"), this.mf.newAssocPlayerModel(assocId, "dmx.core.sequence_start")));
    }

    private void createSequenceSegment(long predAssocId, long succAssocId) {
        this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.sequence", this.mf.newAssocPlayerModel(predAssocId, "dmx.core.predecessor"), this.mf.newAssocPlayerModel(succAssocId, "dmx.core.successor")));
    }

    private RelatedAssoc getPredecessorAssoc(RelatedTopic childTopic) {
        return this.getPredecessorAssoc(childTopic.getRelatingAssoc());
    }

    private RelatedAssoc getPredecessorAssoc(Assoc assoc) {
        RelatedAssoc predAssoc = assoc.getRelatedAssoc("dmx.core.sequence", "dmx.core.successor", "dmx.core.predecessor", this.assocTypeUri);
        if (predAssoc != null) {
            this.checkAssoc(predAssoc);
        }
        return predAssoc;
    }

    private RelatedAssoc getFirstAssoc() {
        RelatedAssoc assoc = this.parentTopic.getRelatedAssoc("dmx.core.sequence", "dmx.core.default", "dmx.core.sequence_start", this.assocTypeUri);
        if (assoc != null) {
            this.checkAssoc(assoc);
        }
        return assoc;
    }

    private RelatedTopic getFirstTopic() {
        RelatedAssoc assoc = this.getFirstAssoc();
        return assoc != null ? this.childTopic(assoc) : null;
    }

    private RelatedTopic getSuccessorTopic(RelatedTopic childTopic) {
        RelatedAssoc assoc = this.getSuccessorAssoc(childTopic);
        return assoc != null ? this.childTopic(assoc) : null;
    }

    private RelatedAssoc getSuccessorAssoc(RelatedTopic childTopic) {
        return this.getSuccessorAssoc(childTopic.getRelatingAssoc());
    }

    private RelatedAssoc getSuccessorAssoc(Assoc assoc) {
        List<RelatedAssoc> succAssocs = assoc.getRelatedAssocs("dmx.core.sequence", "dmx.core.predecessor", "dmx.core.successor", this.assocTypeUri);
        RelatedAssoc succAssoc = null;
        int size = succAssocs.size();
        if (size >= 1) {
            succAssoc = succAssocs.get(0);
            if (size > 1) {
                this.detection.reportAmbiguity(this.parentTopic, assoc, succAssocs);
            }
        }
        if (succAssoc != null) {
            this.checkAssoc(succAssoc);
        }
        return succAssoc;
    }

    private RelatedTopic getChildTopic(long childTopicId) {
        Assoc assoc = this.dmx.getAssocBetweenTopicAndTopic(this.assocTypeUri, this.parentTopic.getId(), childTopicId, "dmx.core.parent", "dmx.core.child");
        if (assoc == null) {
            throw new RuntimeException("Topic " + childTopicId + " is not a child of topic " + this.parentTopic.getId());
        }
        this.checkAssoc(assoc);
        RelatedTopic childTopic = this.childTopic(assoc);
        this.checkTopic(childTopic);
        return childTopic;
    }

    private RelatedTopic childTopic(Assoc assoc) {
        return (RelatedTopic)assoc.getDMXObjectByRole("dmx.core.child");
    }

    private long assocId(RelatedTopic childTopic) {
        return childTopic.getRelatingAssoc().getId();
    }

    private void checkTopic(Topic topic) {
        String typeUri = topic.getTypeUri();
        if (!typeUri.equals(this.childTypeUri)) {
            throw new RuntimeException("Topic " + topic.getId() + " is of type \"" + typeUri + "\" but expected is \"" + this.childTypeUri + "\"");
        }
    }

    private void checkAssoc(Assoc assoc) {
        String typeUri = assoc.getTypeUri();
        if (!typeUri.equals(this.assocTypeUri)) {
            throw new RuntimeException("Assoc " + assoc.getId() + " is of type \"" + typeUri + "\" but expected is \"" + this.assocTypeUri + "\"");
        }
    }

    private static class CycleDetection {
        Topic parentNode;
        List<Long> childNodeIds;
        int sequenceCycles = 0;
        int sequenceAmbiguities = 0;
        private Logger logger = Logger.getLogger(this.getClass().getName());

        private CycleDetection() {
        }

        void startSequence(Topic parentNode) {
            this.parentNode = parentNode;
            this.childNodeIds = new ArrayList<Long>();
        }

        boolean checkSequence(long nodeId) {
            boolean cycle = this.childNodeIds.contains(nodeId);
            if (!cycle) {
                this.childNodeIds.add(nodeId);
            } else {
                this.logger.warning("### Cycle detected in child node sequence of parent node " + this.parentNode.getId() + ". Offending node ID: " + nodeId + ". Nodes in sequence so far: " + this.childNodeIds.size());
                ++this.sequenceCycles;
            }
            return !cycle;
        }

        void reportAmbiguity(Topic parentTopic, Assoc assoc, List<RelatedAssoc> succAssocs) {
            this.logger.warning("### Ambiguity detected in child node sequence of parent node " + this.parentNode.getId() + ". Assoc " + assoc.getId() + " has " + succAssocs.size() + " successors: " + succAssocs);
            ++this.sequenceAmbiguities;
        }
    }
}

