/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;

class ChildTopicsSequence
implements Iterable<RelatedAssocModelImpl> {
    private long parentTopicId;
    private String childTypeUri;
    private String assocTypeUri;
    private AccessLayer al;
    private ModelFactoryImpl mf;

    ChildTopicsSequence(long parentTopicId, String childTypeUri, String assocTypeUri, AccessLayer al) {
        this.parentTopicId = parentTopicId;
        this.childTypeUri = childTypeUri;
        this.assocTypeUri = assocTypeUri;
        this.al = al;
        this.mf = al.mf;
    }

    @Override
    public Iterator<RelatedAssocModelImpl> iterator() {
        return new Iterator(){
            private RelatedAssocModelImpl assoc;
            private List assocIds;
            {
                this.assoc = ChildTopicsSequence.this.getFirstAssoc();
                this.assocIds = new ArrayList();
            }

            @Override
            public boolean hasNext() {
                return this.assoc != null;
            }

            public RelatedAssocModelImpl next() {
                RelatedAssocModelImpl _assoc = this.assoc;
                this.assoc = ChildTopicsSequence.this.getSuccessorAssoc(this.assoc);
                if (this.assocIds.contains(_assoc.id)) {
                    throw new RuntimeException("Cycle detected: assoc " + _assoc.id + " already in " + this.assocIds);
                }
                this.assocIds.add(_assoc.id);
                return _assoc;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    RelatedTopicModelImpl insert(long childTopicId, long predTopicId) {
        try {
            RelatedTopicModelImpl childTopic = this.getChildTopic(childTopicId);
            this._insert(childTopic.getRelatingAssoc(), predTopicId);
            return childTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Inserting topic " + childTopicId + " into sequence of parent topic " + this.parentTopicId + " failed (predTopicId=" + predTopicId + ")", e);
        }
    }

    void insert(AssocModelImpl assoc, long predTopicId) {
        try {
            this._insert(assoc, predTopicId);
        }
        catch (Exception e) {
            throw new RuntimeException("Inserting association " + assoc.getId() + " into sequence of parent topic " + this.parentTopicId + " failed (predTopicId=" + predTopicId + ")", e);
        }
    }

    RelatedTopicModelImpl remove(long childTopicId) {
        try {
            RelatedTopicModelImpl childTopic = this.getChildTopic(childTopicId);
            this._remove(childTopic.getRelatingAssoc());
            return childTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Removing topic " + childTopicId + " from sequence of parent topic " + this.parentTopicId + " failed", e);
        }
    }

    RelatedTopicModelImpl remove(AssocModelImpl assoc) {
        try {
            this._remove(assoc);
            return this.childTopic(assoc);
        }
        catch (Exception e) {
            throw new RuntimeException("Removing association " + assoc.getId() + " from sequence of parent topic " + this.parentTopicId + " failed", e);
        }
    }

    private void _insert(AssocModelImpl assoc, long predTopicId) {
        long assocId = assoc.getId();
        if (predTopicId != -1L) {
            AssocModelImpl predAssoc = this.getChildTopic(predTopicId).getRelatingAssoc();
            RelatedAssocModelImpl succAssoc = this.getSuccessorAssoc(predAssoc);
            if (succAssoc != null) {
                this.insertInBetween(assocId, predAssoc, succAssoc);
            } else {
                this.createSequenceSegment(predAssoc.getId(), assocId);
            }
        } else {
            RelatedAssocModelImpl first = this.getFirstAssoc();
            if (first != null) {
                this.insertAtBegin(assocId, first);
            } else {
                this.createSequenceStart(assocId);
            }
        }
    }

    private void _remove(AssocModelImpl assoc) {
        RelatedAssocModelImpl pred = this.getPredecessorAssoc(assoc.id);
        RelatedAssocModelImpl succ = this.getSuccessorAssoc(assoc);
        if (succ != null) {
            succ.getRelatingAssoc().delete();
        }
        if (pred != null) {
            pred.getRelatingAssoc().delete();
            if (succ != null) {
                this.createSequenceSegment(pred.getId(), succ.getId());
            }
        } else {
            this.getFirstAssoc().getRelatingAssoc().delete();
            if (succ != null) {
                this.createSequenceStart(succ.getId());
            }
        }
    }

    private void insertAtBegin(long assocId, RelatedAssocModelImpl firstChildAssoc) {
        firstChildAssoc.getRelatingAssoc().delete();
        this.createSequenceStart(assocId);
        this.createSequenceSegment(assocId, firstChildAssoc.getId());
    }

    private void insertInBetween(long assocId, AssocModelImpl predAssoc, RelatedAssocModelImpl succAssoc) {
        succAssoc.getRelatingAssoc().delete();
        this.createSequenceSegment(predAssoc.getId(), assocId);
        this.createSequenceSegment(assocId, succAssoc.getId());
    }

    private void createSequenceStart(long assocId) {
        this.al.createAssoc(this.mf.newAssocModel("dmx.core.sequence", this.mf.newTopicPlayerModel(this.parentTopicId, "dmx.core.default"), this.mf.newAssocPlayerModel(assocId, "dmx.core.sequence_start")));
    }

    private void createSequenceSegment(long predAssocId, long succAssocId) {
        this.al.createAssoc(this.mf.newAssocModel("dmx.core.sequence", this.mf.newAssocPlayerModel(predAssocId, "dmx.core.predecessor"), this.mf.newAssocPlayerModel(succAssocId, "dmx.core.successor")));
    }

    private RelatedAssocModelImpl getPredecessorAssoc(long assocId) {
        return this.al.getAssocRelatedAssoc(assocId, "dmx.core.sequence", "dmx.core.successor", "dmx.core.predecessor", this.assocTypeUri);
    }

    private RelatedAssocModelImpl getFirstAssoc() {
        return this.al.getTopicRelatedAssoc(this.parentTopicId, "dmx.core.sequence", "dmx.core.default", "dmx.core.sequence_start", this.assocTypeUri);
    }

    private RelatedTopicModelImpl getFirstTopic() {
        RelatedAssocModelImpl assoc = this.getFirstAssoc();
        return assoc != null ? this.childTopic(assoc) : null;
    }

    private RelatedTopicModelImpl getSuccessorTopic(RelatedTopicModelImpl childTopic) {
        RelatedAssocModelImpl assoc = this.getSuccessorAssoc(childTopic);
        return assoc != null ? this.childTopic(assoc) : null;
    }

    private RelatedAssocModelImpl getSuccessorAssoc(RelatedTopicModelImpl childTopic) {
        return this.getSuccessorAssoc(childTopic.getRelatingAssoc());
    }

    private RelatedAssocModelImpl getSuccessorAssoc(AssocModelImpl assoc) {
        List<RelatedAssocModelImpl> succAssocs = this.al.getAssocRelatedAssocs(assoc.id, "dmx.core.sequence", "dmx.core.predecessor", "dmx.core.successor", this.assocTypeUri);
        RelatedAssocModelImpl succAssoc = null;
        int size = succAssocs.size();
        if (size >= 1) {
            succAssoc = succAssocs.get(0);
            if (size > 1) {
                throw new RuntimeException("Ambiguity detected: assoc " + assoc.id + " has " + size + " successors: " + succAssocs);
            }
        }
        return succAssoc;
    }

    private RelatedTopicModelImpl getChildTopic(long childTopicId) {
        AssocModelImpl assoc = this.al.getAssocBetweenTopicAndTopic(this.assocTypeUri, this.parentTopicId, childTopicId, "dmx.core.parent", "dmx.core.child");
        if (assoc == null) {
            throw new RuntimeException("Topic " + childTopicId + " is not a child of topic " + this.parentTopicId);
        }
        RelatedTopicModelImpl childTopic = this.childTopic(assoc);
        this.checkTopic(childTopic);
        return childTopic;
    }

    private RelatedTopicModelImpl childTopic(AssocModelImpl assoc) {
        return (RelatedTopicModelImpl)assoc.getDMXObjectByRole("dmx.core.child");
    }

    private long assocId(RelatedTopicModelImpl childTopic) {
        return childTopic.getRelatingAssoc().getId();
    }

    private void checkTopic(TopicModelImpl topic) {
        String typeUri = topic.getTypeUri();
        if (!typeUri.equals(this.childTypeUri)) {
            throw new RuntimeException("Topic " + topic.getId() + " is of type \"" + typeUri + "\" but expected is \"" + this.childTypeUri + "\"");
        }
    }
}

