/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.ChangeReportImpl;
import systems.dmx.core.impl.ChildTopicsModelImpl;
import systems.dmx.core.impl.ChildTopicsSequence;
import systems.dmx.core.impl.CoreEvent;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.EventManager;
import systems.dmx.core.impl.LabelCalculation;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicReferenceModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicDeletionModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicReferenceModel;
import systems.dmx.core.model.TypeModel;
import systems.dmx.core.util.DMXUtils;

class ValueIntegrator {
    private DMXObjectModelImpl newValues;
    private DMXObjectModelImpl targetObject;
    private CompDefModel compDef;
    private TypeModelImpl type;
    private boolean isAssoc;
    private boolean isType;
    private boolean isFacetUpdate;
    private AccessLayer al;
    private ModelFactoryImpl mf;
    private EventManager em;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ValueIntegrator(AccessLayer al) {
        this.al = al;
        this.mf = al.mf;
        this.em = al.em;
    }

    <M extends DMXObjectModelImpl> UnifiedValue<M> integrate(M newValues, M targetObject, CompDefModel compDef) {
        try {
            this.newValues = newValues;
            this.targetObject = targetObject;
            this.compDef = compDef;
            this.isAssoc = newValues instanceof AssocModel;
            this.isType = newValues instanceof TypeModel;
            boolean bl = this.isFacetUpdate = compDef != null;
            if (newValues instanceof TopicReferenceModel || newValues instanceof TopicDeletionModel) {
                return this.resolveRef();
            }
            if (newValues.typeUri == null && targetObject != null) {
                newValues.typeUri = targetObject.typeUri;
            }
            if (newValues.typeUri == null) {
                throw new IllegalArgumentException("Tried to integrate values whose \"typeUri\" is not set, newValues=" + newValues + ", targetObject=" + targetObject);
            }
            this.type = newValues.getType();
            UnifiedValue value = newValues.isSimple() && !this.isFacetUpdate ? this.integrateSimple() : this.integrateComposite();
            Object _value = value.value;
            this.idTransfer((DMXObjectModelImpl)_value);
            if (value.created) {
                ((DMXObjectModelImpl)_value).postCreate();
                this.em.fireEvent(CoreEvent.POST_CREATE_TOPIC, ((DMXObjectModelImpl)_value).instantiate());
            }
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("Value integration failed, newValues=" + newValues + ", targetObject=" + targetObject + ", compDef=" + compDef, e);
        }
    }

    private UnifiedValue resolveRef() {
        if (this.newValues instanceof TopicDeletionModel) {
            return new UnifiedValue(this);
        }
        TopicReferenceModelImpl ref = (TopicReferenceModelImpl)this.newValues;
        if (!ref.isEmptyRef()) {
            TopicModelImpl object = ref.resolve();
            this.logger.fine("Referencing " + object);
            return new UnifiedValue(this, (DMXObjectModelImpl)object, ref.originalId);
        }
        return new UnifiedValue(this);
    }

    private void idTransfer(DMXObjectModelImpl value) {
        if (value != null) {
            if (value.id == -1L) {
                throw new RuntimeException("ID of unification result is not initialized: " + value);
            }
            this.newValues.id = value.id;
        }
    }

    private UnifiedValue integrateSimple() {
        if (this.isAssoc || this.isType) {
            return new UnifiedValue(this, this.storeAssocSimpleValue());
        }
        if (this.newValues.getSimpleValue().toString().isEmpty()) {
            return new UnifiedValue(this);
        }
        return this.unifySimple();
    }

    private DMXObjectModelImpl storeAssocSimpleValue() {
        if (this.targetObject != null) {
            this.targetObject._updateSimpleValue(this.newValues.getSimpleValue());
            return this.targetObject;
        }
        this.newValues.storeSimpleValue();
        return this.newValues;
    }

    private UnifiedValue unifySimple() {
        TopicModelImpl topic;
        boolean created = false;
        SimpleValue newValue = this.newValues.value.trim();
        List<TopicModelImpl> topics = this.al.getTopicsByValue(this.type.uri, newValue);
        int size = topics.size();
        if (size > 0) {
            topic = topics.get(0);
            if (size > 1) {
                this.logger.warning("ValueIntegrator ambiguity: there are " + size + " readable \"" + newValue + "\" topics (typeUri=\"" + this.type.uri + "\", " + DMXUtils.idList(topics) + ") => using " + topic.id);
            }
            this.logger.fine("Reusing simple value " + topic.id + " \"" + newValue + "\" (typeUri=\"" + this.type.uri + "\")");
        } else {
            topic = this.al.createSingleTopic(this.mf.newTopicModel(this.newValues.uri, this.newValues.typeUri, this.newValues.value));
            created = true;
            this.logger.fine("### Creating simple value " + topic.id + " \"" + newValue + "\" (typeUri=\"" + this.type.uri + "\")");
        }
        return new UnifiedValue(this, (DMXObjectModelImpl)topic, created);
    }

    private UnifiedValue integrateComposite() {
        HashMap<String, Object> childValues = new HashMap<String, Object>();
        ChildTopicsModelImpl childTopics = this.newValues.getChildTopics();
        for (String compDefUri : this.compDefUris()) {
            Object newChildValue = this.isOne(compDefUri) ? childTopics.getTopicOrNull(compDefUri) : childTopics.getTopicsOrNull(compDefUri);
            if (newChildValue == null) continue;
            Object childValue = this.integrateChildValue(newChildValue, compDefUri);
            childValues.put(compDefUri, childValue);
        }
        UnifiedValue value = this.unifyComposite(childValues);
        boolean updated = value.report != null ? value.report.hasChanges() : false;
        this.logger.fine("### typeUri=" + this.type.getUri() + ", created=" + value.created + ", updated=" + updated);
        if (!this.isFacetUpdate && value.value != null) {
            if (value.created || updated) {
                new LabelCalculation((DMXObjectModelImpl)value.value).calculate();
            } else if (this.isAssoc) {
                this.storeAssocSimpleValue();
            }
        }
        return value;
    }

    private Iterable<String> compDefUris() {
        return !this.isFacetUpdate ? this.type : Arrays.asList(this.compDef.getCompDefUri());
    }

    private Object integrateChildValue(Object childValue, String compDefUri) {
        if (this.isOne(compDefUri)) {
            return new ValueIntegrator(this.al).integrate((RelatedTopicModelImpl)childValue, null, null);
        }
        ArrayList<UnifiedValue<Object>> values = new ArrayList<UnifiedValue<Object>>();
        for (RelatedTopicModelImpl value : (List)childValue) {
            values.add(new ValueIntegrator(this.al).integrate(value, null, null));
        }
        return values;
    }

    private UnifiedValue unifyComposite(Map<String, Object> childValues) {
        if (this.isValueType() && !this.isFacetUpdate) {
            return this.unifyChildTopics(childValues, this.type);
        }
        UnifiedValue value = this.identifyParent(childValues);
        Object parent = value.value;
        if (parent != null) {
            ChangeReportImpl report;
            value.report = report = this.updateAssignments((DMXObjectModelImpl)parent, childValues);
        }
        return value;
    }

    private UnifiedValue identifyParent(Map<String, Object> childValues) {
        if (this.targetObject != null) {
            return new UnifiedValue(this, this.targetObject);
        }
        if (this.isAssoc) {
            if (this.newValues.id == -1L) {
                throw new RuntimeException("newValues has no ID set");
            }
            AssocModelImpl _newValues = (AssocModelImpl)this.newValues;
            return new UnifiedValue(this, this.mf.newAssocModel(this.newValues.id, this.newValues.uri, this.newValues.typeUri, _newValues.player1, _newValues.player2));
        }
        List<String> identityCompDefUris = this.type.getIdentityAttrs();
        if (identityCompDefUris.size() > 0) {
            if (childValues.isEmpty()) {
                return new UnifiedValue(this);
            }
            Map<String, Object> childTopics = this.identityChildValues(childValues, identityCompDefUris);
            return this.unifyChildTopics(childTopics, identityCompDefUris);
        }
        return new UnifiedValue(this, (DMXObjectModelImpl)this.createCompositeTopic(childValues), true);
    }

    private Map<String, Object> identityChildValues(Map<String, Object> childValues, List<String> identityCompDefUris) {
        try {
            HashMap<String, Object> identityChildValues = new HashMap<String, Object>();
            for (String compDefUri : identityCompDefUris) {
                if (!this.isOne(compDefUri)) {
                    throw new RuntimeException("Cardinality \"many\" identity attributes not supported");
                }
                UnifiedValue childValue = (UnifiedValue)childValues.get(compDefUri);
                if (childValue == null) {
                    throw new RuntimeException("Identity value \"" + compDefUri + "\" is missing in " + childValues.keySet());
                }
                if (childValue.value == null) continue;
                identityChildValues.put(compDefUri, childValue);
            }
            return identityChildValues;
        }
        catch (Exception e) {
            throw new RuntimeException("Selecting identity values " + identityCompDefUris + " failed, childValues=" + childValues, e);
        }
    }

    private ChangeReportImpl updateAssignments(DMXObjectModelImpl parent, Map<String, Object> childValues) {
        ChangeReportImpl report = new ChangeReportImpl();
        for (String compDefUri : this.compDefUris()) {
            parent.loadChildTopics(this.compDef(compDefUri), true);
            Object childValue = childValues.get(compDefUri);
            if (childValue == null) continue;
            if (this.isOne(compDefUri)) {
                this.updateAssignmentsOne(parent, (UnifiedValue)childValue, compDefUri, report);
                continue;
            }
            this.updateAssignmentsMany(parent, (List)childValue, compDefUri, report);
        }
        return report;
    }

    private void updateAssignmentsOne(DMXObjectModelImpl parent, UnifiedValue<TopicModelImpl> childValue, String compDefUri, ChangeReportImpl report) {
        try {
            boolean changed;
            boolean oldValueExists;
            ChildTopicsModelImpl oldChildTopics = parent.getChildTopics();
            RelatedTopicModelImpl oldValue = oldChildTopics.getTopicOrNull(compDefUri);
            boolean bl = oldValueExists = oldValue != null;
            if (oldValueExists && oldValue.id == -1L) {
                throw new RuntimeException("Old value's ID is not initialized, oldValue=" + oldValue);
            }
            TopicModelImpl newValue = (TopicModelImpl)childValue.value;
            long newId = newValue != null ? newValue.getId() : -1L;
            boolean newValueIsEmpty = newId == -1L;
            boolean valueChanged = oldValueExists && oldValue.id != newId;
            boolean bl2 = changed = valueChanged || !oldValueExists && !newValueIsEmpty;
            if (changed) {
                report.add(compDefUri, !newValueIsEmpty ? newValue.instantiate() : null, oldValueExists ? oldValue.instantiate() : null);
            }
            boolean deleted = false;
            if (valueChanged) {
                deleted = true;
                oldValue.getRelatingAssoc().delete();
                if (newValueIsEmpty) {
                    this.logger.fine("### Deleting assignment (compDefUri=\"" + compDefUri + "\") from composite " + parent.id + " (typeUri=\"" + this.type.uri + "\")");
                    oldChildTopics.remove(compDefUri);
                }
            }
            AssocModelImpl assoc = null;
            if (!(newValueIsEmpty || oldValueExists && !valueChanged)) {
                assoc = this.createChildAssoc(parent, newValue, compDefUri, deleted);
                oldChildTopics.set(compDefUri, this.mf.newRelatedTopicModel(newValue, (AssocModel)assoc));
            }
            if (assoc == null && oldValueExists && !deleted) {
                assoc = oldValue.getRelatingAssoc();
            }
            if (assoc != null) {
                RelatedTopicModelImpl _newValues = this.newValues.getChildTopics().getTopicOrNull(compDefUri);
                this.updateRelatingAssoc(assoc, compDefUri, _newValues);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Updating assigment failed, parent=" + parent + ", childValue=" + childValue + ", compDefUri=\"" + compDefUri + "\"", e);
        }
    }

    private void updateAssignmentsMany(DMXObjectModelImpl parent, List<UnifiedValue> childValues, String compDefUri, ChangeReportImpl report) {
        ChildTopicsModelImpl oldChildTopics = parent.getChildTopics();
        List<RelatedTopicModelImpl> oldValues = oldChildTopics.getTopicsOrNull(compDefUri);
        CompDefModel compDef = this.compDef(compDefUri);
        boolean sequenceHasChanges = false;
        for (UnifiedValue childValue : childValues) {
            boolean valueAdded;
            TopicModelImpl newValue = (TopicModelImpl)childValue.value;
            long newId = newValue != null ? newValue.getId() : -1L;
            boolean newValueIsEmpty = newId == -1L;
            RelatedTopicModelImpl oldValue = null;
            long originalId = childValue.originalId;
            if (originalId != -1L) {
                if (oldValues == null) {
                    throw new RuntimeException("Tried to replace original topic " + originalId + " when there are no old topics (null)");
                }
                oldValue = this.findTopic(oldValues, originalId);
            } else if (!newValueIsEmpty && oldValues != null) {
                oldValue = this.findTopicOrNull(oldValues, newId);
            }
            boolean oldValueExists = oldValue != null;
            boolean valueChanged = oldValueExists && oldValue.id != newId;
            boolean bl = valueAdded = !oldValueExists && !newValueIsEmpty;
            if (valueChanged || valueAdded) {
                report.add(compDefUri, !newValueIsEmpty ? newValue.instantiate() : null, oldValueExists ? oldValue.instantiate() : null);
                if (!sequenceHasChanges) {
                    sequenceHasChanges = true;
                    this.deleteSequence(parent.id, compDef);
                }
            }
            if (valueChanged) {
                if (newValueIsEmpty) {
                    this.logger.fine("### Deleting assignment (compDefUri=\"" + compDefUri + "\") from composite " + parent.id + " (typeUri=\"" + this.type.uri + "\")");
                }
                oldValue.getRelatingAssoc().delete();
                this.removeTopic(oldValues, originalId);
            }
            AssocModelImpl assoc = null;
            if (!(newValueIsEmpty || oldValueExists && !valueChanged)) {
                assoc = this.createChildAssoc(parent, newValue, compDefUri, valueChanged);
                oldChildTopics.add(compDefUri, this.mf.newRelatedTopicModel(newValue, (AssocModel)assoc));
            }
            if (assoc == null && oldValueExists && !valueChanged) {
                assoc = oldValue.getRelatingAssoc();
            }
            if (assoc == null) continue;
            RelatedTopicModelImpl newValues = (RelatedTopicModelImpl)childValue._newValues;
            this.updateRelatingAssoc(assoc, compDefUri, newValues);
        }
        if (sequenceHasChanges) {
            this.createSequence(parent.id, compDef, oldChildTopics.getTopicsOrNull(compDefUri));
        }
    }

    private void updateRelatingAssoc(AssocModelImpl assoc, String compDefUri, RelatedTopicModelImpl newValues) {
        try {
            if (newValues != null) {
                AssocModelImpl _newValues = newValues.getRelatingAssoc();
                _newValues.setPlayer1(null);
                _newValues.setPlayer2(null);
                if (_newValues.typeUri != null) {
                    assoc.update(_newValues);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Updating relating assoc " + assoc.id + " failed, compDefUri=\"" + compDefUri + "\", assoc=" + assoc, e);
        }
    }

    private void createSequence(long parentTopicId, CompDefModel compDef, List<RelatedTopicModelImpl> values) {
        ChildTopicsSequence s = this.newChildTopicsSequence(parentTopicId, compDef);
        AssocModelImpl predAssoc = null;
        int n = 0;
        for (RelatedTopicModelImpl value : values) {
            predAssoc = s.insert(value.getRelatingAssoc(), predAssoc);
            ++n;
        }
        this.logger.info("### " + n + " sequence segments created");
    }

    private void deleteSequence(long parentTopicId, CompDefModel compDef) {
        int n = 0;
        for (RelatedAssocModelImpl assoc : this.newChildTopicsSequence(parentTopicId, compDef)) {
            assoc.getRelatingAssoc().delete();
            ++n;
        }
        this.logger.info("### " + n + " sequence segments deleted");
    }

    private ChildTopicsSequence newChildTopicsSequence(long parentTopicId, CompDefModel compDef) {
        return new ChildTopicsSequence(parentTopicId, compDef.getChildTypeUri(), compDef.getInstanceLevelAssocTypeUri(), this.al);
    }

    private UnifiedValue unifyChildTopics(Map<String, Object> childValues, Iterable<String> compDefUris) {
        int size;
        List<? extends TopicModelImpl> candidates = this.parentCandidates(childValues);
        if (candidates == null) {
            return new UnifiedValue(this);
        }
        for (String compDefUri : compDefUris) {
            if (this.isOne(compDefUri)) {
                UnifiedValue value = (UnifiedValue)childValues.get(compDefUri);
                this.eliminateParentCandidates(candidates, value != null ? (TopicModelImpl)value.value : null, compDefUri);
            } else {
                List values = (List)childValues.get(compDefUri);
                this.eliminateParentCandidates(candidates, values, compDefUri);
            }
            if (!candidates.isEmpty()) continue;
            break;
        }
        if ((size = candidates.size()) > 0) {
            DMXObjectModelImpl comp = candidates.get(0);
            if (size > 1) {
                this.logger.warning("ValueIntegrator ambiguity: there are " + candidates.size() + " parents (typeUri=\"" + this.type.uri + "\", " + DMXUtils.idList(candidates) + ") which have the same " + childValues.values().size() + " child topics => using " + comp.id + ", child topics " + childValues.values());
            }
            return new UnifiedValue(this, comp);
        }
        return new UnifiedValue(this, (DMXObjectModelImpl)this.createCompositeTopic(childValues), true);
    }

    private List<? extends TopicModelImpl> parentCandidates(Map<String, Object> childValues) {
        DMXObjectModel childTopic = null;
        String compDefUri = null;
        for (String _compDefUri : childValues.keySet()) {
            childTopic = this.findNonEmptyChildTopic(childValues.get(_compDefUri), _compDefUri);
            if (childTopic == null) continue;
            compDefUri = _compDefUri;
            break;
        }
        return childTopic == null ? null : this.al.getTopicRelatedTopics(childTopic.getId(), this.compDef(compDefUri).getInstanceLevelAssocTypeUri(), "dmx.core.child", "dmx.core.parent", this.type.getUri());
    }

    private DMXObjectModel findNonEmptyChildTopic(Object childValue, String compDefUri) {
        DMXObjectModel childTopic = null;
        if (this.isOne(compDefUri)) {
            childTopic = (DMXObjectModel)((UnifiedValue)childValue).value;
        } else {
            for (UnifiedValue value : (List)childValue) {
                if (value.value == null) continue;
                childTopic = (DMXObjectModel)value.value;
                break;
            }
        }
        return childTopic;
    }

    private void eliminateParentCandidates(List<? extends TopicModelImpl> candidates, TopicModelImpl childTopic, String compDefUri) {
        CompDefModel compDef = this.compDef(compDefUri);
        Iterator<? extends TopicModelImpl> i = candidates.iterator();
        while (i.hasNext()) {
            TopicModelImpl parent = i.next();
            String assocTypeUri = compDef.getInstanceLevelAssocTypeUri();
            if (childTopic != null) {
                AssocModelImpl assoc = this.al.getAssocBetweenTopicAndTopic(assocTypeUri, parent.id, childTopic.id, "dmx.core.parent", "dmx.core.child");
                if (assoc != null) {
                    parent.getChildTopics().set(compDefUri, this.mf.newRelatedTopicModel(childTopic, (AssocModel)assoc));
                    continue;
                }
                i.remove();
                continue;
            }
            if (this.al.getTopicRelatedTopics(parent.id, assocTypeUri, "dmx.core.parent", "dmx.core.child", compDef.getChildTypeUri()).isEmpty()) continue;
            i.remove();
        }
    }

    private void eliminateParentCandidates(List<? extends TopicModelImpl> candidates, List<UnifiedValue> childValues, String compDefUri) {
        Iterator<? extends TopicModelImpl> i = candidates.iterator();
        while (i.hasNext()) {
            TopicModelImpl parent = i.next();
            parent.loadChildTopics(compDefUri, false);
            List<RelatedTopicModelImpl> childTopics = parent.getChildTopics().getTopics(compDefUri);
            if (ValueIntegrator.matches(childTopics, childValues)) continue;
            i.remove();
        }
    }

    private TopicModelImpl createCompositeTopic(Map<String, Object> childValues) {
        TopicModelImpl parent = this.al.createSingleTopic(this.mf.newTopicModel(this.newValues.uri, this.newValues.typeUri, this.newValues.value));
        this.logger.fine("### Creating composite " + parent.id + " (typeUri=\"" + this.type.uri + "\")");
        ChildTopicsModelImpl childTopics = parent.getChildTopics();
        for (String compDefUri : childValues.keySet()) {
            if (this.isOne(compDefUri)) {
                TopicModel childTopic = (TopicModel)((UnifiedValue)childValues.get((Object)compDefUri)).value;
                if (childTopic == null) continue;
                AssocModelImpl assoc = this.createChildAssoc(parent, childTopic, compDefUri);
                childTopics.set(compDefUri, this.mf.newRelatedTopicModel(childTopic, (AssocModel)assoc));
                continue;
            }
            for (UnifiedValue value : (List)childValues.get(compDefUri)) {
                TopicModel childTopic = (TopicModel)value.value;
                if (childTopic == null) continue;
                AssocModelImpl assoc = this.createChildAssoc(parent, childTopic, compDefUri);
                childTopics.add(compDefUri, this.mf.newRelatedTopicModel(childTopic, (AssocModel)assoc));
            }
        }
        return parent;
    }

    private AssocModelImpl createChildAssoc(DMXObjectModel parent, DMXObjectModel child, String compDefUri) {
        return this.createChildAssoc(parent, child, compDefUri, false);
    }

    private AssocModelImpl createChildAssoc(DMXObjectModel parent, DMXObjectModel child, String compDefUri, boolean deleted) {
        this.logger.fine("### " + (deleted ? "Reassigning" : "Assigning") + " child " + child.getId() + " (compDefUri=\"" + compDefUri + "\") to composite " + parent.getId() + " (typeUri=\"" + this.type.uri + "\")");
        return this.al.createAssoc(this.compDef(compDefUri).getInstanceLevelAssocTypeUri(), parent.createPlayerModel("dmx.core.parent"), child.createPlayerModel("dmx.core.child"));
    }

    private RelatedTopicModelImpl findTopic(List<RelatedTopicModelImpl> topics, long topicId) {
        RelatedTopicModelImpl topic = this.findTopicOrNull(topics, topicId);
        if (topic == null) {
            throw new RuntimeException("Topic " + topicId + " not found in " + topics);
        }
        return topic;
    }

    private RelatedTopicModelImpl findTopicOrNull(List<RelatedTopicModelImpl> topics, long topicId) {
        for (RelatedTopicModelImpl topic : topics) {
            if (topic.id != topicId) continue;
            return topic;
        }
        return null;
    }

    private void removeTopic(List<RelatedTopicModelImpl> topics, long topicId) {
        Iterator<RelatedTopicModelImpl> i = topics.iterator();
        while (i.hasNext()) {
            RelatedTopicModelImpl topic = i.next();
            if (topic.id != topicId) continue;
            i.remove();
            return;
        }
        throw new RuntimeException("Topic " + topicId + " not found in " + topics);
    }

    private static boolean matches(List<? extends TopicModel> topics, List<UnifiedValue> values) {
        int valueCount = 0;
        for (UnifiedValue value : values) {
            if (value.value == null) continue;
            if (!topics.contains(value)) {
                return false;
            }
            ++valueCount;
        }
        return topics.size() == valueCount;
    }

    private CompDefModel compDef(String compDefUri) {
        if (!this.isFacetUpdate) {
            return this.type.getCompDef(compDefUri);
        }
        if (!compDefUri.equals(this.compDef.getCompDefUri())) {
            throw new RuntimeException("URI mismatch: compDefUri=\"" + compDefUri + "\", facet compDefUri=\"" + this.compDef.getCompDefUri() + "\"");
        }
        return this.compDef;
    }

    private boolean isOne(String compDefUri) {
        return this.compDef(compDefUri).getChildCardinalityUri().equals("dmx.core.one");
    }

    private boolean isValueType() {
        return this.type.getDataTypeUri().equals("dmx.core.value");
    }

    class UnifiedValue<M extends DMXObjectModelImpl>
    implements JSONEnabled {
        M value;
        boolean created;
        DMXObjectModelImpl _newValues;
        long originalId;
        ChangeReportImpl report;
        final /* synthetic */ ValueIntegrator this$0;

        private UnifiedValue(ValueIntegrator this$0) {
            this(this$0, null);
        }

        private UnifiedValue(M value) {
            this(this$0, (DMXObjectModelImpl)value, false);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        private UnifiedValue(M value, boolean created) {
            this((ValueIntegrator)this$0, (DMXObjectModelImpl)value, created, ((ValueIntegrator)this$0).newValues.id);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private UnifiedValue(M originalId, long l) {
            this((ValueIntegrator)this$0, (DMXObjectModelImpl)value, false, (long)originalId);
            void value;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private UnifiedValue(M created, boolean originalId, long l) {
            void value;
            this.this$0 = (ValueIntegrator)this$0;
            this.value = value;
            this.created = created;
            this._newValues = ((ValueIntegrator)this$0).newValues;
            this.originalId = (long)originalId;
        }

        @Override
        public JSONObject toJSON() {
            try {
                return new JSONObject().put("value", this.value != null ? ((DMXObjectModelImpl)this.value).toJSON() : null).put("originalId", this.originalId);
            }
            catch (Exception e) {
                throw new RuntimeException("Serialization failed", e);
            }
        }

        public boolean equals(Object o) {
            return ((DMXObjectModelImpl)o).id == ((DMXObjectModelImpl)this.value).id;
        }

        public String toString() {
            return this.dump();
        }
    }
}

