/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.accesscontrol;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import systems.dmx.accesscontrol.AuthorizationMethod;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.service.accesscontrol.Permissions;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.util.IdList;

public interface AccessControlService {
    public static final String ADMIN_USERNAME = "admin";
    public static final String ADMIN_INITIAL_PASSWORD = System.getProperty("dmx.security.initial_admin_password", "");
    public static final String ADMIN_WORKSPACE_NAME = "Administration";
    public static final String ADMIN_WORKSPACE_URI = "dmx.workspaces.administration";
    public static final SharingMode ADMIN_WORKSPACE_SHARING_MODE = SharingMode.COLLABORATIVE;
    public static final String SYSTEM_WORKSPACE_NAME = "System";
    public static final String SYSTEM_WORKSPACE_URI = "dmx.workspaces.system";
    public static final SharingMode SYSTEM_WORKSPACE_SHARING_MODE = SharingMode.PUBLIC;
    public static final String DEFAULT_PRIVATE_WORKSPACE_NAME = "Private Workspace";

    public void login();

    public void logout();

    public String getUsername();

    public Topic getUsernameTopic();

    public Topic getPrivateWorkspace();

    public void checkAdmin();

    public Topic createUserAccount(Credentials var1);

    public Topic _createUserAccount(Credentials var1) throws Exception;

    public Topic createUsername(String var1);

    public Topic getUsernameTopic(String var1);

    public String getWorkspaceOwner(long var1);

    public void setWorkspaceOwner(Topic var1, String var2);

    public List<RelatedTopic> getMemberships(String var1);

    public List<RelatedTopic> getMemberships(long var1);

    public boolean isMember(String var1, long var2);

    public Assoc getMembership(String var1, long var2);

    public void createMembership(String var1, long var2);

    public List<RelatedTopic> bulkUpdateMemberships(String var1, IdList var2, IdList var3);

    public List<RelatedTopic> bulkUpdateMemberships(long var1, IdList var3, IdList var4);

    public long getAdminWorkspaceId();

    public Permissions getPermissions(long var1);

    public String getCreator(long var1);

    public String getModifier(long var1);

    public void enrichWithUserInfo(DMXObject var1);

    public Collection<Topic> getTopicsByCreator(String var1);

    public Collection<Topic> getTopicsByOwner(String var1);

    public Collection<Assoc> getAssocsByCreator(String var1);

    public Collection<Assoc> getAssocsByOwner(String var1);

    public Set<String> getAuthorizationMethods();

    public void registerAuthorizationMethod(String var1, AuthorizationMethod var2);

    public void unregisterAuthorizationMethod(String var1);
}

