/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicReferenceModel;

class TopicReferenceModelImpl
extends RelatedTopicModelImpl
implements TopicReferenceModel {
    long originalId = -1L;

    TopicReferenceModelImpl(RelatedTopicModelImpl relatedTopic) {
        super(relatedTopic);
    }

    @Override
    public boolean isReferenceById() {
        return this.getId() != -1L;
    }

    @Override
    public boolean isReferenceByUri() {
        return this.getUri() != null && !this.getUri().equals("");
    }

    @Override
    public boolean isEmptyRef() {
        return !this.isReferenceById() && !this.isReferenceByUri();
    }

    @Override
    public boolean isReferingTo(TopicModel topic) {
        if (this.isReferenceById()) {
            return this.getId() == topic.getId();
        }
        if (this.isReferenceByUri()) {
            return this.getUri().equals(topic.getUri());
        }
        throw new RuntimeException("Invalid " + this);
    }

    @Override
    public RelatedTopicModelImpl findReferencedTopic(List<? extends RelatedTopicModel> topics) {
        for (RelatedTopicModel relatedTopicModel : topics) {
            if (!this.isReferingTo(relatedTopicModel)) continue;
            return (RelatedTopicModelImpl)relatedTopicModel;
        }
        return null;
    }

    @Override
    String className() {
        return "topic reference";
    }

    TopicModelImpl resolve() {
        try {
            TopicModelImpl topic;
            if (this.isReferenceById()) {
                topic = this.al.db.fetchTopic(this.id);
            } else if (this.isReferenceByUri()) {
                topic = this.al.sd.fetchTopic("uri", this.uri);
                if (topic == null) {
                    throw new RuntimeException("Topic with URI \"" + this.uri + "\" not found");
                }
            } else {
                throw new RuntimeException("Invalid " + this);
            }
            this.set(topic.loadChildTopics(true));
            return topic;
        }
        catch (Exception e) {
            throw new RuntimeException("Resolving a topic reference failed (" + this + ")", e);
        }
    }
}

