/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.ChildTopicsSequence;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.util.DMXUtils;

class ChildTopicsFetcher {
    private AccessLayer al;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ChildTopicsFetcher(AccessLayer al) {
        this.al = al;
    }

    void fetch(DMXObjectModel object, CompDefModel compDef, boolean deep) {
        block14: {
            try {
                ChildTopicsModel childTopics = object.getChildTopics();
                String cardinalityUri = compDef.getChildCardinalityUri();
                String compDefUri = compDef.getCompDefUri();
                if (cardinalityUri.equals("dmx.core.one")) {
                    RelatedTopicModelImpl childTopic = this.fetchChildTopic(object.getId(), compDef);
                    if (childTopic != null) {
                        childTopics.set(compDefUri, childTopic);
                        if (deep) {
                            this.fetchChildTopics(childTopic, deep);
                        }
                    }
                    break block14;
                }
                if (cardinalityUri.equals("dmx.core.many")) {
                    List<? extends RelatedTopicModel> topics;
                    List<RelatedTopicModelImpl> _childTopics = this.fetchChildTopics(object.getId(), compDef);
                    int a = 0;
                    for (RelatedAssocModelImpl relatedAssocModelImpl : this.newChildTopicsSequence(object.getId(), compDef)) {
                        RelatedTopicModel relatedTopicModel = DMXUtils.findByAssoc(relatedAssocModelImpl.id, _childTopics);
                        if (relatedTopicModel == null) {
                            throw new RuntimeException("DB inconsistency: assoc " + relatedAssocModelImpl.id + " is in sequence but not in " + _childTopics + ", assoc=" + relatedAssocModelImpl + ", child topic=" + relatedAssocModelImpl.getDMXObjectByRole("dmx.core.child"));
                        }
                        childTopics.add(compDefUri, relatedTopicModel);
                        ++a;
                    }
                    if (a != _childTopics.size()) {
                        if (a > 0) {
                            throw new RuntimeException("DB inconsistency: " + a + " values in sequence when there should be " + _childTopics.size() + ", parentTopicId=" + object.getId() + ", compDefUri=\"" + compDefUri + "\"");
                        }
                        if (_childTopics.size() > 0) {
                            this.logger.fine("### No sequence for " + _childTopics.size() + " \"" + compDefUri + "\" values");
                            for (RelatedTopicModel relatedTopicModel : _childTopics) {
                                childTopics.add(compDefUri, relatedTopicModel);
                            }
                        }
                    }
                    if (deep && (topics = childTopics.getTopicsOrNull(compDefUri)) != null) {
                        for (RelatedTopicModel relatedTopicModel : topics) {
                            this.fetchChildTopics((DMXObjectModelImpl)((Object)relatedTopicModel), deep);
                        }
                    }
                    break block14;
                }
                throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
            }
            catch (Exception e) {
                throw new RuntimeException("Fetching the \"" + compDef.getCompDefUri() + "\" child topics of object " + object.getId() + " failed", e);
            }
        }
    }

    private ChildTopicsSequence newChildTopicsSequence(long parentTopicId, CompDefModel compDef) {
        return new ChildTopicsSequence(parentTopicId, compDef.getChildTypeUri(), compDef.getInstanceLevelAssocTypeUri(), this.al);
    }

    private void fetchChildTopics(DMXObjectModelImpl object, boolean deep) {
        for (CompDefModel compDefModel : object.getType().getCompDefs()) {
            this.fetch(object, compDefModel, deep);
        }
    }

    private RelatedTopicModelImpl fetchChildTopic(long objectId, CompDefModel compDef) {
        return this.al.sd.fetchRelatedTopic(objectId, compDef.getInstanceLevelAssocTypeUri(), "dmx.core.parent", "dmx.core.child", compDef.getChildTypeUri());
    }

    private List<RelatedTopicModelImpl> fetchChildTopics(long objectId, CompDefModel compDef) {
        return this.al.db.fetchRelatedTopics(objectId, compDef.getInstanceLevelAssocTypeUri(), "dmx.core.parent", "dmx.core.child", compDef.getChildTypeUri());
    }
}

