/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.accesscontrol;

import com.sun.jersey.spi.container.ContainerRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.accesscontrol.AnonymousAccessFilter;
import systems.dmx.accesscontrol.AuthorizationMethod;
import systems.dmx.accesscontrol.event.PostLoginUser;
import systems.dmx.accesscontrol.event.PostLogoutUser;
import systems.dmx.config.ConfigCustomizer;
import systems.dmx.config.ConfigDef;
import systems.dmx.config.ConfigModRole;
import systems.dmx.config.ConfigService;
import systems.dmx.config.ConfigTarget;
import systems.dmx.core.Assoc;
import systems.dmx.core.AssocType;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.AssocPlayerModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.ChangeReport;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.EventListener;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.AccessControlException;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.service.accesscontrol.Operation;
import systems.dmx.core.service.accesscontrol.Permissions;
import systems.dmx.core.service.accesscontrol.PrivilegedAccess;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.service.event.CheckAssocReadAccess;
import systems.dmx.core.service.event.CheckAssocWriteAccess;
import systems.dmx.core.service.event.CheckTopicReadAccess;
import systems.dmx.core.service.event.CheckTopicWriteAccess;
import systems.dmx.core.service.event.PostCreateAssoc;
import systems.dmx.core.service.event.PostCreateTopic;
import systems.dmx.core.service.event.PostDeleteTopic;
import systems.dmx.core.service.event.PostUpdateAssoc;
import systems.dmx.core.service.event.PostUpdateTopic;
import systems.dmx.core.service.event.PreCreateAssoc;
import systems.dmx.core.service.event.PreUpdateTopic;
import systems.dmx.core.service.event.ServiceRequestFilter;
import systems.dmx.core.service.event.StaticResourceFilter;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.IdList;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.files.FilesService;
import systems.dmx.files.event.CheckDiskQuota;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/access-control")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AccessControlPlugin
extends PluginActivator
implements AccessControlService,
ConfigCustomizer,
CheckTopicReadAccess,
CheckTopicWriteAccess,
CheckAssocReadAccess,
CheckAssocWriteAccess,
PreCreateAssoc,
PreUpdateTopic,
PostCreateTopic,
PostCreateAssoc,
PostDeleteTopic,
PostUpdateTopic,
PostUpdateAssoc,
ServiceRequestFilter,
StaticResourceFilter,
CheckDiskQuota {
    private static final String ANONYMOUS_READ_ALLOWED = System.getProperty("dmx.security.anonymous_read_allowed", "ALL");
    private static final String ANONYMOUS_WRITE_ALLOWED = System.getProperty("dmx.security.anonymous_write_allowed", "NONE");
    private static final AnonymousAccessFilter accessFilter = new AnonymousAccessFilter(ANONYMOUS_READ_ALLOWED, ANONYMOUS_WRITE_ALLOWED);
    private static final String SUBNET_FILTER = System.getProperty("dmx.security.subnet_filter", "127.0.0.1/32");
    private static final boolean NEW_ACCOUNTS_ARE_ENABLED = Boolean.parseBoolean(System.getProperty("dmx.security.new_accounts_are_enabled", "true"));
    private static final boolean IS_PUBLIC_INSTALLATION = ANONYMOUS_READ_ALLOWED.equals("ALL");
    private static final String AUTHENTICATION_REALM = "DMX";
    private static DMXEvent POST_LOGIN_USER = new DMXEvent(PostLoginUser.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((PostLoginUser)listener).postLoginUser((String)params[0]);
        }
    };
    private static DMXEvent POST_LOGOUT_USER = new DMXEvent(PostLogoutUser.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((PostLogoutUser)listener).postLogoutUser((String)params[0]);
        }
    };
    @Inject
    private WorkspacesService ws;
    @Inject
    private FilesService fs;
    @Inject
    private ConfigService cs;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;
    private Map<String, AuthorizationMethod> authorizationMethods = new HashMap<String, AuthorizationMethod>();
    private static Logger logger = Logger.getLogger(AccessControlPlugin.class.getName());

    @Override
    @POST
    @Path(value="/login")
    public void login() {
    }

    @Override
    @POST
    @Path(value="/logout")
    public void logout() {
        this._logout(this.request);
        if (!IS_PUBLIC_INSTALLATION) {
            this.throw401Unauthorized(true);
        }
    }

    @Override
    @GET
    @Path(value="/user")
    @Produces(value={"text/plain"})
    public String getUsername() {
        return this.dmx.getPrivilegedAccess().getUsername(this.request);
    }

    @Override
    @GET
    @Path(value="/username")
    public Topic getUsernameTopic() {
        return this.dmx.getPrivilegedAccess().getUsernameTopic(this.request);
    }

    @Override
    @GET
    @Path(value="/user/workspace")
    public Topic getPrivateWorkspace() {
        String username = this.getUsername();
        if (username == null) {
            throw new IllegalStateException("No user is logged in");
        }
        return this.dmx.getPrivilegedAccess().getPrivateWorkspace(username);
    }

    @Override
    public void checkAdmin() {
        try {
            this.checkWriteAccess(this.getAdminWorkspaceId());
        }
        catch (Exception e) {
            throw new RuntimeException("User is not an administrator", e);
        }
    }

    @Override
    @POST
    @Path(value="/user-account")
    @Transactional
    public Topic createUserAccount(Credentials cred) {
        try {
            this.checkAdmin();
            return this._createUserAccount(cred);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating user account \"" + cred.username + "\" failed", e);
        }
    }

    @Override
    public Topic _createUserAccount(Credentials cred) throws Exception {
        String username = cred.username;
        PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
        logger.info("Creating user account \"" + username + "\"");
        Topic usernameTopic = this.createUsername(username);
        String salt = JavaUtils.random256();
        Topic userAccount = (Topic)pa.runInWorkspaceContext(-1L, () -> this.dmx.createTopic(this.mf.newTopicModel("dmx.accesscontrol.user_account", this.mf.newChildTopicsModel().setRef("dmx.accesscontrol.username", usernameTopic.getId()).set("dmx.accesscontrol.password", (Object)JavaUtils.encodeSHA256((String)(salt + cred.password))))));
        logger.info("### Salting password of user \"" + cred.username + "\"");
        RelatedTopic passwordTopic = userAccount.getChildTopics().getTopic("dmx.accesscontrol.password");
        passwordTopic.setProperty("dmx.accesscontrol.salt", (Object)salt, false);
        long privateWorkspaceId = pa.getPrivateWorkspace(username).getId();
        pa.assignToWorkspace((DMXObject)userAccount, privateWorkspaceId);
        pa.assignToWorkspace((DMXObject)passwordTopic, privateWorkspaceId);
        pa.assignToWorkspace((DMXObject)passwordTopic.getRelatingAssoc(), privateWorkspaceId);
        return usernameTopic;
    }

    @Override
    public Topic createUsername(String username) {
        try {
            logger.info("Creating username topic \"" + username + "\"");
            PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
            Topic usernameTopic = this.getUsernameTopic(username);
            if (usernameTopic != null) {
                throw new RuntimeException("Username \"" + username + "\" exists already");
            }
            usernameTopic = (Topic)pa.runInWorkspaceContext(-1L, () -> this.dmx.createTopic(this.mf.newTopicModel("dmx.accesscontrol.username", new SimpleValue(username))));
            this.setWorkspaceOwner(this.ws.createWorkspace("Private Workspace", null, SharingMode.PRIVATE), username);
            pa.assignToWorkspace((DMXObject)usernameTopic, pa.getSystemWorkspaceId());
            return usernameTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating username topic \"" + username + "\" failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/username/{username}")
    public Topic getUsernameTopic(@PathParam(value="username") String username) {
        return this.dmx.getPrivilegedAccess().getUsernameTopic(username);
    }

    @Override
    @GET
    @Path(value="/workspace/{workspaceId}/owner")
    @Produces(value={"text/plain"})
    public String getWorkspaceOwner(@PathParam(value="workspaceId") long workspaceId) {
        return this.dmx.hasProperty(workspaceId, "dmx.accesscontrol.owner") ? (String)this.dmx.getProperty(workspaceId, "dmx.accesscontrol.owner") : null;
    }

    @Override
    public void setWorkspaceOwner(Topic workspace, String username) {
        try {
            workspace.setProperty("dmx.accesscontrol.owner", (Object)username, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the workspace owner of " + this.info((DMXObject)workspace) + " failed (username=" + username + ")", e);
        }
    }

    @Override
    public void enrichWithOwnerInfo(Topic workspace) {
        workspace.getChildTopics().getModel().set("dmx.accesscontrol.owner", (Object)this.getWorkspaceOwner(workspace.getId()));
    }

    @Override
    @GET
    @Path(value="/user/{username}/memberships")
    public List<RelatedTopic> getMemberships(@PathParam(value="username") String username) {
        try {
            return this.getUsernameTopic(username).getRelatedTopics("dmx.accesscontrol.membership", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace");
        }
        catch (Exception e) {
            throw new RuntimeException("Getting memberships of user \"" + username + "\" failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/workspace/{workspaceId}/memberships")
    public List<RelatedTopic> getMemberships(@PathParam(value="workspaceId") long workspaceId) {
        try {
            return this.dmx.getTopic(workspaceId).getRelatedTopics("dmx.accesscontrol.membership", "dmx.core.default", "dmx.core.default", "dmx.accesscontrol.username");
        }
        catch (Exception e) {
            throw new RuntimeException("Getting memberships of workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    public boolean isMember(String username, long workspaceId) {
        return this.dmx.getPrivilegedAccess().isMember(username, workspaceId);
    }

    @Override
    public Assoc getMembership(String username, long workspaceId) {
        Topic usernameTopic = this.getUsernameTopic(username);
        if (usernameTopic == null) {
            throw new RuntimeException("Unknown username: \"" + username + "\"");
        }
        return this.dmx.getAssocBetweenTopicAndTopic("dmx.accesscontrol.membership", usernameTopic.getId(), workspaceId, "dmx.core.default", "dmx.core.default");
    }

    @Override
    @POST
    @Path(value="/user/{username}/workspace/{workspaceId}")
    @Transactional
    public void createMembership(@PathParam(value="username") String username, @PathParam(value="workspaceId") long workspaceId) {
        try {
            this.checkWorkspaceArg(workspaceId);
            this.dmx.getPrivilegedAccess().createMembership(username, workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating membership for user \"" + username + "\" and workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/user/{username}")
    @Transactional
    public List<RelatedTopic> bulkUpdateMemberships(@PathParam(value="username") String username, @QueryParam(value="addWorkspaceIds") IdList addWorkspaceIds, @QueryParam(value="removeWorkspaceIds") IdList removeWorkspaceIds) {
        try {
            long workspaceId;
            Iterator iterator;
            ArrayList<Long> workspacesAdded = new ArrayList<Long>();
            ArrayList<Long> workspacesRemoved = new ArrayList<Long>();
            if (removeWorkspaceIds != null) {
                iterator = removeWorkspaceIds.iterator();
                while (iterator.hasNext()) {
                    workspaceId = (Long)iterator.next();
                    if (!this.deleteMembershipIfExists(username, workspaceId)) continue;
                    workspacesRemoved.add(workspaceId);
                }
            }
            if (addWorkspaceIds != null) {
                iterator = addWorkspaceIds.iterator();
                while (iterator.hasNext()) {
                    workspaceId = (Long)iterator.next();
                    if (this.isMember(username, workspaceId)) continue;
                    this.createMembership(username, workspaceId);
                    workspacesAdded.add(workspaceId);
                }
            }
            logger.info("### User \"" + username + "\": workspaces added " + workspacesAdded + ", workspaces removed " + workspacesRemoved);
            return this.getMemberships(username);
        }
        catch (Exception e) {
            throw new RuntimeException("Bulk membership update for user \"" + username + "\" failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/workspace/{workspaceId}")
    @Transactional
    public List<RelatedTopic> bulkUpdateMemberships(@PathParam(value="workspaceId") long workspaceId, @QueryParam(value="addUserIds") IdList addUserIds, @QueryParam(value="removeUserIds") IdList removeUserIds) {
        try {
            String username;
            long userId;
            Iterator iterator;
            ArrayList<String> usersAdded = new ArrayList<String>();
            ArrayList<String> usersRemoved = new ArrayList<String>();
            if (removeUserIds != null) {
                iterator = removeUserIds.iterator();
                while (iterator.hasNext()) {
                    userId = (Long)iterator.next();
                    username = this.getUsername(userId);
                    if (!this.deleteMembershipIfExists(username, workspaceId)) continue;
                    usersRemoved.add(username);
                }
            }
            if (addUserIds != null) {
                iterator = addUserIds.iterator();
                while (iterator.hasNext()) {
                    userId = (Long)iterator.next();
                    username = this.getUsername(userId);
                    if (this.isMember(username, workspaceId)) continue;
                    this.createMembership(username, workspaceId);
                    usersAdded.add(username);
                }
            }
            logger.info("### Workspace " + workspaceId + ": users added " + usersAdded + ", users removed " + usersRemoved);
            return this.getMemberships(workspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Bulk membership update for workspace " + workspaceId + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/workspace/admin/id")
    public long getAdminWorkspaceId() {
        return this.dmx.getPrivilegedAccess().getAdminWorkspaceId();
    }

    @Override
    @GET
    @Path(value="/object/{id}")
    public Permissions getPermissions(@PathParam(value="id") long objectId) {
        return new Permissions().add(Operation.WRITE, this.hasPermission(this.getUsername(), Operation.WRITE, objectId));
    }

    @Override
    @GET
    @Path(value="/object/{id}/creator")
    @Produces(value={"text/plain"})
    public String getCreator(@PathParam(value="id") long objectId) {
        return this.dmx.getPrivilegedAccess().getCreator(objectId);
    }

    @Override
    @GET
    @Path(value="/object/{id}/modifier")
    @Produces(value={"text/plain"})
    public String getModifier(@PathParam(value="id") long objectId) {
        return this.dmx.hasProperty(objectId, "dmx.accesscontrol.modifier") ? (String)this.dmx.getProperty(objectId, "dmx.accesscontrol.modifier") : null;
    }

    @Override
    public void enrichWithUserInfo(DMXObject object) {
        long objectId = object.getId();
        object.getChildTopics().getModel().set("dmx.accesscontrol.creator", (Object)this.getCreator(objectId)).set("dmx.accesscontrol.modifier", (Object)this.getModifier(objectId));
    }

    @Override
    @GET
    @Path(value="/user/{username}/workspaces")
    public Collection<Topic> getWorkspacesByOwner(@PathParam(value="username") String username) {
        try {
            List workspaces = this.dmx.getTopicsByProperty("dmx.accesscontrol.owner", (Object)username);
            for (Topic workspace : workspaces) {
                if (workspace.getTypeUri().equals("dmx.workspaces.workspace")) continue;
                throw new RuntimeException("Consistency check failed: topic " + workspace.getId() + " is not a Workspace, but a \"" + workspace.getTypeUri() + "\"");
            }
            return workspaces;
        }
        catch (Exception e) {
            throw new RuntimeException("Getting workspaces owned by user \"" + username + "\" failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/creator/{username}/topics")
    public Collection<Topic> getTopicsByCreator(@PathParam(value="username") String username) {
        return this.dmx.getTopicsByProperty("dmx.accesscontrol.creator", (Object)username);
    }

    @Override
    @GET
    @Path(value="/creator/{username}/assocs")
    public Collection<Assoc> getAssocsByCreator(@PathParam(value="username") String username) {
        return this.dmx.getAssocsByProperty("dmx.accesscontrol.creator", (Object)username);
    }

    @Override
    @GET
    @Path(value="/methods")
    public Set<String> getAuthorizationMethods() {
        return this.authorizationMethods.keySet();
    }

    @Override
    public void registerAuthorizationMethod(String name, AuthorizationMethod am) {
        if (this.authorizationMethods.containsKey(name)) {
            throw new RuntimeException("Authorization method \"" + name + "\" already registered");
        }
        logger.info("Registering authorization method \"" + name + "\"");
        this.authorizationMethods.put(name, am);
    }

    @Override
    public void unregisterAuthorizationMethod(String name) {
        logger.info("Unregistering authorization method \"" + name + "\"");
        this.authorizationMethods.remove(name);
    }

    public void preInstall() {
        this.cs.registerConfigDef(new ConfigDef(ConfigTarget.TYPE_INSTANCES, "dmx.accesscontrol.username", this.mf.newTopicModel("dmx.accesscontrol.login_enabled", new SimpleValue(NEW_ACCOUNTS_ARE_ENABLED)), ConfigModRole.ADMIN, (ConfigCustomizer)this));
    }

    public void shutdown() {
        if (this.cs != null) {
            this.cs.unregisterConfigDef("dmx.accesscontrol.login_enabled");
        }
    }

    public TopicModel getConfigValue(Topic topic) {
        if (!topic.getTypeUri().equals("dmx.accesscontrol.username")) {
            throw new RuntimeException("Unexpected configurable topic: " + topic);
        }
        if (topic.getSimpleValue().toString().equals("admin")) {
            return this.mf.newTopicModel("dmx.accesscontrol.login_enabled", new SimpleValue(true));
        }
        return null;
    }

    public void checkTopicReadAccess(long topicId) {
        this.checkReadAccess(topicId);
    }

    public void checkTopicWriteAccess(long topicId) {
        this.checkWriteAccess(topicId);
    }

    public void checkAssocReadAccess(long assocId) {
        this.checkReadAccess(assocId);
        List players = this.dmx.getPlayerModels(assocId);
        this.checkReadAccess((PlayerModel)players.get(0));
        this.checkReadAccess((PlayerModel)players.get(1));
    }

    public void checkAssocWriteAccess(long assocId) {
        this.checkWriteAccess(assocId);
    }

    public void postCreateTopic(Topic topic) {
        if (topic.getTypeUri().equals("dmx.workspaces.workspace")) {
            this.setWorkspaceOwner(topic);
        }
        this.setCreatorAndModifier((DMXObject)topic);
    }

    public void preCreateAssoc(AssocModel assoc) {
        PlayerModel[] p = DMXUtils.assocAutoTyping((AssocModel)assoc, (String)"dmx.accesscontrol.username", (String)"dmx.workspaces.workspace", (String)"dmx.accesscontrol.membership", (String)"dmx.core.default", (String)"dmx.core.default", players -> {
            try {
                PlayerModel wp = players[1];
                this.checkWriteAccess(wp.getId());
                return true;
            }
            catch (AccessControlException e) {
                return false;
            }
        });
        if (p != null) {
            long workspaceId = p[1].getId();
            assoc.getChildTopics().setRef("dmx.workspaces.workspace#dmx.workspaces.workspace_assignment", workspaceId);
        }
    }

    public void postCreateAssoc(Assoc assoc) {
        this.setCreatorAndModifier((DMXObject)assoc);
    }

    public void preUpdateTopic(Topic topic, TopicModel updateModel) {
        if (topic.getTypeUri().equals("dmx.accesscontrol.user_account")) {
            String password;
            String username;
            String newUsername;
            RelatedTopicModel newUsernameTopic = updateModel.getChildTopics().getTopicOrNull("dmx.accesscontrol.username");
            if (newUsernameTopic != null && !(newUsername = newUsernameTopic.getSimpleValue().toString()).equals(username = topic.getChildTopics().getTopic("dmx.accesscontrol.username").getSimpleValue().toString())) {
                throw new RuntimeException("A Username can't be changed (tried \"" + username + "\" -> \"" + newUsername + "\")");
            }
            RelatedTopicModel passwordTopic = updateModel.getChildTopics().getTopicOrNull("dmx.accesscontrol.password");
            if (passwordTopic != null && (password = passwordTopic.getSimpleValue().toString()).equals("")) {
                throw new RuntimeException("Password can't be empty");
            }
        }
    }

    public void postUpdateTopic(Topic topic, ChangeReport report, TopicModel updateModel) {
        if (topic.getTypeUri().equals("dmx.accesscontrol.user_account")) {
            ChildTopics ct = topic.getChildTopics();
            RelatedTopic passwordTopic = ct.getTopic("dmx.accesscontrol.password");
            if (report.getChanges("dmx.accesscontrol.password") != null) {
                String username = ct.getTopic("dmx.accesscontrol.username").getSimpleValue().toString();
                String password = passwordTopic.getSimpleValue().toString();
                Credentials cred = new Credentials(username, password);
                this.dmx.getPrivilegedAccess().storeSaltedPassword(cred, (TopicModel)passwordTopic.getModel());
            }
            long workspaceId = this.getPrivateWorkspace().getId();
            this.ws.assignToWorkspace((DMXObject)passwordTopic, workspaceId);
            this.ws.assignToWorkspace((DMXObject)passwordTopic.getRelatingAssoc(), workspaceId);
        }
        this.setModifier((DMXObject)topic);
    }

    public void postUpdateAssoc(Assoc assoc, ChangeReport report, AssocModel updateModel) {
        this.setModifier((DMXObject)assoc);
    }

    public void postDeleteTopic(TopicModel topic) {
        if (topic.getTypeUri().equals("dmx.accesscontrol.username")) {
            String username = topic.getSimpleValue().toString();
            Collection<Topic> workspaces = this.getWorkspacesByOwner(username);
            String currentUser = this.getUsername();
            logger.info("### Transferring ownership of " + workspaces.size() + " workspaces from \"" + username + "\" -> \"" + currentUser + "\"");
            for (Topic workspace : workspaces) {
                this.setWorkspaceOwner(workspace, currentUser);
            }
        }
    }

    public void serviceRequestFilter(ContainerRequest containerRequest) {
        this.requestFilter(this.request, this.response);
    }

    public void staticResourceFilter(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.requestFilter(servletRequest, servletResponse);
    }

    public void checkDiskQuota(String username, long fileSize, long diskQuota) {
        if (diskQuota < 0L) {
            logger.info("### Checking disk quota of " + this.userInfo(username) + " SKIPPED -- disk quota is disabled");
            return;
        }
        long occupiedSpace = this.getOccupiedSpace(username);
        boolean quotaOK = occupiedSpace + fileSize <= diskQuota;
        logger.info("### File size: " + fileSize + " bytes, " + this.userInfo(username) + " occupies " + occupiedSpace + " bytes, disk quota: " + diskQuota + " bytes => QUOTA " + (quotaOK ? "OK" : "EXCEEDED"));
        if (!quotaOK) {
            throw new RuntimeException("Disk quota of " + this.userInfo(username) + " exceeded, diskQuota=" + diskQuota + " bytes, occupiedSpace=" + occupiedSpace + " bytes, fileSize=" + fileSize + " bytes");
        }
    }

    private void checkWorkspaceArg(long workspaceId) {
        Topic workspace = this.dmx.getTopic(workspaceId);
        String typeUri = workspace.getTypeUri();
        if (!typeUri.equals("dmx.workspaces.workspace")) {
            throw new IllegalArgumentException("Topic " + workspaceId + " is not a Workspace (but a \"" + typeUri + "\")");
        }
        workspace.checkWriteAccess();
    }

    private String getUsername(long id) {
        Topic username = this.dmx.getTopic(id);
        String typeUri = username.getTypeUri();
        if (!typeUri.equals("dmx.accesscontrol.username")) {
            throw new IllegalArgumentException("Topic " + id + " is not a Username (but a \"" + typeUri + "\")");
        }
        return username.getSimpleValue().toString();
    }

    private boolean deleteMembershipIfExists(String username, long workspaceId) {
        Assoc membership = this.getMembership(username, workspaceId);
        if (membership != null) {
            membership.delete();
            return true;
        }
        return false;
    }

    private long getOccupiedSpace(String username) {
        long occupiedSpace = 0L;
        for (Topic fileTopic : this.dmx.getTopicsByType("dmx.files.file")) {
            long fileTopicId = fileTopic.getId();
            if (!this.getCreator(fileTopicId).equals(username)) continue;
            try {
                occupiedSpace += this.fs.getFile(fileTopicId).length();
            }
            catch (Exception exception) {}
        }
        return occupiedSpace;
    }

    private void requestFilter(HttpServletRequest request, HttpServletResponse response) {
        logger.fine("##### " + request.getMethod() + " " + request.getRequestURL() + "\n      ##### \"Authorization\"=\"" + request.getHeader("Authorization") + "\"\n      ##### " + this.info(request.getSession(false)));
        this.checkRequestOrigin(request);
        HttpSession session = this.getSession(request, response);
        if (this.username(session) == null) {
            this.checkAuthorization(request);
        }
    }

    private HttpSession getSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            session = request.getSession();
            String cookie = response.getHeader("Set-Cookie");
            response.setHeader("Set-Cookie", cookie + ";SameSite=Strict");
            logger.info("### Creating " + this.info(session) + ", response=" + response);
        }
        return session;
    }

    private void checkRequestOrigin(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        boolean allowed = JavaUtils.isInRange((String)remoteAddr, (String)SUBNET_FILTER);
        logger.fine("Remote address=\"" + remoteAddr + "\", dmx.security.subnet_filter=\"" + SUBNET_FILTER + "\" => " + (allowed ? "ALLOWED" : "FORBIDDEN"));
        if (!allowed) {
            this.throw403Forbidden();
        }
    }

    private void checkAuthorization(HttpServletRequest request) {
        boolean authorized;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            Credentials cred = new Credentials(authHeader);
            AuthorizationMethod am = this.getAuthorizationMethod(cred);
            authorized = this.tryLogin(cred, am, request);
        } else {
            authorized = accessFilter.isAnonymousAccessAllowed(request);
        }
        if (!authorized) {
            this.throw401Unauthorized(!IS_PUBLIC_INSTALLATION);
        }
    }

    private AuthorizationMethod getAuthorizationMethod(Credentials cred) {
        AuthorizationMethod am = null;
        if (!cred.methodName.equals("Basic")) {
            logger.info("authMethodName: \"" + cred.methodName + "\"");
            am = this.getAuthorizationMethod(cred.methodName);
        }
        return am;
    }

    private AuthorizationMethod getAuthorizationMethod(String name) {
        AuthorizationMethod am = this.authorizationMethods.get(name);
        if (am == null) {
            throw new RuntimeException("Authorization method \"" + name + "\" is unknown");
        }
        return am;
    }

    private boolean tryLogin(Credentials cred, AuthorizationMethod am, HttpServletRequest request) {
        String username = cred.username;
        Topic usernameTopic = this.checkCredentials(cred, am);
        if (usernameTopic != null && this.getLoginEnabled(usernameTopic)) {
            logger.info("##### Logging in as \"" + username + "\" => SUCCESSFUL!");
            this._login(username, request);
            return true;
        }
        logger.info("##### Logging in as \"" + username + "\" => FAILED!");
        return false;
    }

    private Topic checkCredentials(Credentials cred, AuthorizationMethod am) {
        if (am == null) {
            return this.dmx.getPrivilegedAccess().checkCredentials(cred);
        }
        return am.checkCredentials(cred);
    }

    private boolean getLoginEnabled(Topic usernameTopic) {
        RelatedTopic loginEnabled = this.dmx.getPrivilegedAccess().getConfigTopic("dmx.accesscontrol.login_enabled", usernameTopic.getId());
        return loginEnabled.getSimpleValue().booleanValue();
    }

    private void _login(String username, HttpServletRequest request) {
        request.getSession(false).setAttribute("username", (Object)username);
        this.dmx.fireEvent(POST_LOGIN_USER, new Object[]{username});
    }

    private void _logout(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        String username = this.username(session);
        logger.info("##### Logging out from " + this.info(session));
        session.removeAttribute("username");
        this.dmx.fireEvent(POST_LOGOUT_USER, new Object[]{username});
    }

    private String username(HttpSession session) {
        return this.dmx.getPrivilegedAccess().username(session);
    }

    private void throw401Unauthorized(boolean showBrowserLoginDialog) {
        String authScheme = showBrowserLoginDialog ? "Basic" : "xBasic";
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)(authScheme + " realm=" + AUTHENTICATION_REALM)).header("Content-Type", (Object)"text/html").entity((Object)"You're not authorized. Sorry.").build());
    }

    private void throw403Forbidden() {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).header("Content-Type", (Object)"text/html").entity((Object)"Access is forbidden. Sorry.").build());
    }

    private void setCreatorAndModifier(DMXObject object) {
        try {
            String username = this.getUsername();
            if (username == null) {
                logger.fine("Setting the creator/modifier of " + this.info(object) + " SKIPPED -- no user is logged in");
                return;
            }
            this.setCreatorAndModifier(object, username);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the creator/modifier of " + this.info(object) + " failed", e);
        }
    }

    private void setCreatorAndModifier(DMXObject object, String username) {
        this.setCreator(object, username);
        this.setModifier(object, username);
    }

    private void setCreator(DMXObject object, String username) {
        try {
            object.setProperty("dmx.accesscontrol.creator", (Object)username, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Setting the creator of " + this.info(object) + " failed (username=" + username + ")", e);
        }
    }

    private void setModifier(DMXObject object) {
        String username = this.getUsername();
        if (username == null) {
            return;
        }
        this.setModifier(object, username);
    }

    private void setModifier(DMXObject object, String username) {
        object.setProperty("dmx.accesscontrol.modifier", (Object)username, false);
    }

    private void setWorkspaceOwner(Topic workspace) {
        String username = this.getUsername();
        if (username == null) {
            return;
        }
        this.setWorkspaceOwner(workspace, username);
    }

    private void checkReadAccess(PlayerModel player) {
        long id = player.getId();
        if (player instanceof AssocPlayerModel) {
            this.checkAssocReadAccess(id);
        } else {
            this.checkReadAccess(id);
        }
    }

    private void checkReadAccess(long objectId) {
        this.checkAccess(Operation.READ, objectId);
    }

    private void checkWriteAccess(long objectId) {
        this.checkAccess(Operation.WRITE, objectId);
    }

    private void checkAccess(Operation operation, long objectId) {
        if (!this.inRequestScope()) {
            logger.fine("### Object " + objectId + " is accessed by \"System\" -- " + operation + " permission is granted");
            return;
        }
        String username = this.getUsername();
        if (!this.hasPermission(username, operation, objectId)) {
            throw new AccessControlException(this.userInfo(username) + " has no " + operation + " permission for object " + objectId);
        }
    }

    private boolean hasPermission(String username, Operation operation, long objectId) {
        return this.dmx.getPrivilegedAccess().hasPermission(username, operation, objectId);
    }

    private boolean inRequestScope() {
        try {
            this.request.getMethod();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private String info(DMXObject object) {
        if (object instanceof TopicType) {
            return "topic type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof AssocType) {
            return "association type \"" + object.getUri() + "\" (id=" + object.getId() + ")";
        }
        if (object instanceof Topic) {
            return "topic " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\", uri=\"" + object.getUri() + "\")";
        }
        if (object instanceof Assoc) {
            return "association " + object.getId() + " (typeUri=\"" + object.getTypeUri() + "\")";
        }
        throw new RuntimeException("Unexpected object: " + object);
    }

    private String userInfo(String username) {
        return "user " + (username != null ? "\"" + username + "\"" : "<anonymous>");
    }

    private String info(HttpSession session) {
        return "session" + (session != null ? " " + session.getId() + " (username=" + this.username(session) + ")" : ": null");
    }

    private String info(HttpServletRequest request) {
        StringBuilder info = new StringBuilder();
        info.append("    " + request.getMethod() + " " + request.getRequestURI() + "\n");
        Enumeration e1 = request.getHeaderNames();
        while (e1.hasMoreElements()) {
            String name = (String)e1.nextElement();
            info.append("\n    " + name + ":");
            Enumeration e2 = request.getHeaders(name);
            while (e2.hasMoreElements()) {
                String header = (String)e2.nextElement();
                info.append(" " + header);
            }
        }
        return info.toString();
    }

    static {
        logger.info("Security config:\n  dmx.security.anonymous_read_allowed = " + accessFilter.dumpReadSetting() + "\n  dmx.security.anonymous_write_allowed = " + accessFilter.dumpWriteSetting() + "\n  dmx.security.subnet_filter = " + SUBNET_FILTER + "\n  dmx.security.new_accounts_are_enabled = " + NEW_ACCOUNTS_ARE_ENABLED);
    }
}

