/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Assoc;
import systems.dmx.core.RelatedAssoc;
import systems.dmx.core.Topic;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.DMXObjectImpl;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.model.DMXObjectModel;

class TopicImpl
extends DMXObjectImpl
implements Topic {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    TopicImpl(TopicModelImpl model, AccessLayer al) {
        super(model, al);
    }

    @Override
    public final <M extends DMXObjectModel> void update(M updateModel) {
        this.al.updateTopic(this.getModel(), (TopicModelImpl)updateModel);
    }

    @Override
    public final void delete() {
        this.al.deleteTopic(this.getModel());
    }

    @Override
    public final Topic findChildTopic(String topicTypeUri) {
        TopicModelImpl topic = this.getModel().findChildTopic(topicTypeUri);
        return topic != null ? topic.instantiate() : null;
    }

    @Override
    public TopicModelImpl getModel() {
        return (TopicModelImpl)this.model;
    }

    @Override
    public final RelatedAssoc getRelatedAssoc(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        RelatedAssocModelImpl assoc = this.al.getTopicRelatedAssoc(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri);
        return assoc != null ? assoc.instantiate() : null;
    }

    @Override
    public final List<RelatedAssoc> getRelatedAssocs(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersAssocTypeUri) {
        return this.al.instantiate(this.al.getTopicRelatedAssocs(this.getId(), assocTypeUri, myRoleTypeUri, othersRoleTypeUri, othersAssocTypeUri));
    }

    @Override
    public final Assoc getAssoc(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, long othersTopicId) {
        AssocModelImpl assoc = this.al.getAssocBetweenTopicAndTopic(assocTypeUri, this.getId(), othersTopicId, myRoleTypeUri, othersRoleTypeUri);
        return assoc != null ? assoc.instantiate() : null;
    }

    @Override
    public final List<Assoc> getAssocs() {
        return this.al.instantiate(this.al.getTopicAssocs(this.getId()));
    }
}

