/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.files;

import javax.servlet.http.HttpServletRequest;
import systems.dmx.config.ConfigService;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.osgi.CoreActivator;
import systems.dmx.core.service.CoreService;
import systems.dmx.files.FilesPlugin;

class DiskQuotaCheck {
    HttpServletRequest request;
    CoreService dmx;

    DiskQuotaCheck(HttpServletRequest request, CoreService dmx) {
        this.request = request;
        this.dmx = dmx;
    }

    void check(long fileSize) {
        String username = this.dmx.getPrivilegedAccess().getUsername(this.request);
        if (username == null) {
            throw new RuntimeException("User <anonymous> has no disk quota");
        }
        this.dmx.fireEvent(FilesPlugin.CHECK_DISK_QUOTA, new Object[]{username, fileSize, this.diskQuota(username)});
    }

    private long diskQuota(String username) {
        Topic usernameTopic = this.dmx.getPrivilegedAccess().getUsernameTopic(username);
        ConfigService cs = (ConfigService)CoreActivator.getService(ConfigService.class);
        RelatedTopic configTopic = cs.getConfigTopic("dmx.files.disk_quota", usernameTopic.getId());
        return 0x100000 * configTopic.getSimpleValue().intValue();
    }
}

