/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.files;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class UploadedFile {
    private String name;
    private long size;
    private InputStream in;

    public UploadedFile(String name, long size, InputStream in) {
        this.name = name;
        this.size = size;
        this.in = in;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public String getString() {
        return this.getString(Charset.defaultCharset().name());
    }

    public String getString(String encoding) {
        try {
            StringWriter out = new StringWriter();
            IOUtils.copy((InputStream)this.in, (Writer)out, (String)encoding);
            this.in.close();
            out.close();
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Getting contents of uploaded file failed (" + this + ")", e);
        }
    }

    public String toString() {
        return "\"" + this.name + "\" (" + this.size + " bytes)";
    }

    void write(File file) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            IOUtils.copy((InputStream)this.in, (OutputStream)out);
            this.in.close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            throw new RuntimeException("Writing uploaded file to disk failed (" + this + ")", e);
        }
    }
}

