/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import systems.dmx.core.Topic;
import systems.dmx.core.ViewConfig;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.ViewConfigModelImpl;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.ViewConfigModel;

class ViewConfigImpl
implements ViewConfig {
    private ViewConfigModelImpl model;
    private PlayerModel configurable;
    private AccessLayer al;
    private ModelFactoryImpl mf;

    ViewConfigImpl(PlayerModel configurable, ViewConfigModelImpl model, AccessLayer al) {
        this.configurable = configurable;
        this.model = model;
        this.al = al;
        this.mf = al.mf;
    }

    @Override
    public Iterable<Topic> getConfigTopics() {
        return this.al.instantiate(this.model.getConfigTopics());
    }

    @Override
    public Topic getConfigTopic(String configTypeUri) {
        TopicModelImpl configTopic = this.model.getConfigTopic(configTypeUri);
        return configTopic != null ? configTopic.instantiate() : null;
    }

    @Override
    public Topic addConfigTopic(TopicModel configTopic) {
        TopicModelImpl _configTopic = (TopicModelImpl)configTopic;
        this._addConfigTopic(_configTopic);
        return _configTopic.instantiate();
    }

    @Override
    public ViewConfig setConfigValue(String configTypeUri, String childTypeUri, Object value) {
        this._setConfigValue(configTypeUri, this.mf.newChildTopicsModel().set(childTypeUri, value));
        return this;
    }

    @Override
    public ViewConfig setConfigValueRef(String configTypeUri, String childTypeUri, Object topicIdOrUri) {
        this._setConfigValue(configTypeUri, this.mf.newChildTopicsModel().set(childTypeUri, this.mf.newTopicReferenceModel(topicIdOrUri)));
        return this;
    }

    @Override
    public ViewConfigModel getModel() {
        return this.model;
    }

    private void _setConfigValue(String configTypeUri, ChildTopicsModel children) {
        TopicModelImpl configTopic = this.model.getConfigTopic(configTypeUri);
        if (configTopic == null) {
            configTopic = this.mf.newTopicModel(configTypeUri, children);
            this._addConfigTopic(configTopic);
        } else {
            configTopic.update(children);
        }
    }

    private void _addConfigTopic(TopicModelImpl configTopic) {
        this.model.addConfigTopic(configTopic);
        this.al.typeStorage.storeViewConfigTopic(this.configurable, configTopic);
    }
}

