/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.accountmanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.accesscontrol.AuthorizationMethod;
import systems.dmx.accesscontrol.DeprecatedUserAccountMethods;
import systems.dmx.accountmanagement.AccountManagementService;
import systems.dmx.accountmanagement.AccountManager;
import systems.dmx.accountmanagement.CheckCredentialsResult;
import systems.dmx.accountmanagement.DmxAccountManager;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.ChangeReport;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.service.accesscontrol.PrivilegedAccess;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.service.event.PostDeleteTopic;
import systems.dmx.core.service.event.PostUpdateTopic;
import systems.dmx.core.service.event.PreDeleteTopic;
import systems.dmx.core.service.event.PreUpdateTopic;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/account-management")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AccountManagementPlugin
extends PluginActivator
implements AccountManagementService,
PreDeleteTopic,
PreUpdateTopic,
PostDeleteTopic,
PostUpdateTopic,
DeprecatedUserAccountMethods {
    static final Logger logger = Logger.getLogger(AccountManagementPlugin.class.getName());
    private static final String ACCOUNT_MANAGER_NAME = System.getProperty("dmx.accountmanagement.manager", "DMX");
    private static final boolean NEW_ACCOUNTS_ARE_ENABLED = Boolean.parseBoolean(System.getProperty("dmx.security.new_accounts_are_enabled", "true"));
    private static final String SITE_SALT = System.getProperty("dmx.security.site_salt", "");
    @Inject
    WorkspacesService ws;
    @Inject
    AccessControlService accessControlService;
    private final Map<String, AccountManager> accountManagers = new HashMap<String, AccountManager>();

    public void serviceArrived(Object service) {
        if (service instanceof AccessControlService) {
            this.registerAccountManager(new DmxAccountManager(this.dmx, this.mf, SITE_SALT));
        }
    }

    public void serviceGone(Object service) {
        if (service instanceof AccessControlService) {
            this.unregisterAccountManager(this.getAccountManager("DMX"));
        }
    }

    @Override
    public void registerAccountManager(AccountManager accountManager) {
        this.accountManagers.put(accountManager.name(), accountManager);
        this.accessControlService.registerAuthorizationMethod(accountManager.name(), this.asAuthorizationMethod(accountManager));
    }

    @Override
    public void unregisterAccountManager(AccountManager accountManager) {
        this.accessControlService.unregisterAuthorizationMethod(accountManager.name());
        this.accountManagers.remove(accountManager.name());
    }

    @Override
    public List<String> getAccountManagerNames() {
        return new ArrayList<String>(this.accountManagers.keySet());
    }

    @Override
    public String getConfiguredAccountManagerName() {
        return ACCOUNT_MANAGER_NAME;
    }

    @Override
    @POST
    @Path(value="/user-account")
    @Transactional
    public Topic createUserAccount(Credentials cred) {
        try {
            this.accessControlService.checkAdmin();
            return this._createUserAccount(cred);
        }
        catch (Exception e) {
            throw new RuntimeException("Creating user account \"" + cred.username + "\" failed", e);
        }
    }

    @Override
    public Topic _createUserAccount(Credentials cred) {
        String username = cred.username;
        String methodName = cred.methodName != null ? cred.methodName : ACCOUNT_MANAGER_NAME;
        logger.info(String.format("Creating user account '%s' with method '%s'", username, methodName));
        Topic usernameTopic = this.createUsernameAndPrivateWorkspace(username, methodName);
        AccountManager method = this.getAccountManager(methodName);
        method.createAccount(cred);
        return usernameTopic;
    }

    @Deprecated
    public Topic createUsername(String username) {
        return this.createUsernameAndPrivateWorkspace(username, "DMX");
    }

    @Override
    public void changePassword(Credentials currentCred, Credentials newCred) {
        Topic usernameTopic = this.dmx.getPrivilegedAccess().getUsernameTopic(newCred.username);
        this.getAccountManageForUsername(usernameTopic).changePassword(currentCred, newCred);
    }

    public void preUpdateTopic(Topic topic, TopicModel updateModel) {
        if (topic.getTypeUri().equals("dmx.accesscontrol.user_account")) {
            String username;
            String newUsername;
            RelatedTopicModel newUsernameTopic = updateModel.getChildTopics().getTopicOrNull("dmx.accesscontrol.username");
            if (newUsernameTopic != null && !(newUsername = newUsernameTopic.getSimpleValue().toString()).equals(username = topic.getChildTopics().getTopic("dmx.accesscontrol.username").getSimpleValue().toString())) {
                throw new RuntimeException("A Username can't be changed (tried \"" + username + "\" -> \"" + newUsername + "\")");
            }
            RelatedTopicModel passwordTopic = updateModel.getChildTopics().getTopicOrNull("dmx.accesscontrol.password");
            if (passwordTopic != null) {
                String password = passwordTopic.getSimpleValue().toString();
                if (password.equals("")) {
                    throw new RuntimeException("Password can't be empty");
                }
                long workspaceId = this.accessControlService.getPrivateWorkspace().getId();
                String compDefUri = "dmx.workspaces.workspace#dmx.workspaces.workspace_assignment";
                passwordTopic.getChildTopics().setRef(compDefUri, workspaceId);
                passwordTopic.getRelatingAssoc().getChildTopics().setRef(compDefUri, workspaceId);
            }
        }
    }

    public void preDeleteTopic(Topic topic) {
        if (topic.getTypeUri().equals("dmx.accesscontrol.username")) {
            String username = topic.getSimpleValue().toString();
            this.getAccountManageForUsername(topic).onUsernameDeleted(username);
        }
    }

    public void postDeleteTopic(TopicModel topic) {
        if (topic.getTypeUri().equals("dmx.accesscontrol.username")) {
            String username = topic.getSimpleValue().toString();
            Collection workspaces = this.accessControlService.getWorkspacesByOwner(username);
            String currentUser = this.accessControlService.getUsername();
            logger.info("### Transferring ownership of " + workspaces.size() + " workspaces from \"" + username + "\" -> \"" + currentUser + "\"");
            for (Topic workspace : workspaces) {
                this.accessControlService.setWorkspaceOwner(workspace, currentUser);
            }
        }
    }

    public void postUpdateTopic(Topic topic, ChangeReport report, TopicModel updateModel) {
        if (topic.getTypeUri().equals("dmx.accesscontrol.user_account")) {
            ChildTopics ct = topic.getChildTopics();
            RelatedTopic passwordTopic = ct.getTopic("dmx.accesscontrol.password");
            if (report.getChanges("dmx.accesscontrol.password") != null) {
                String username = ct.getTopic("dmx.accesscontrol.username").getSimpleValue().toString();
                String password = passwordTopic.getSimpleValue().toString();
                Credentials cred = new Credentials(username, password);
                this.dmx.getPrivilegedAccess().storePasswordHash(cred, (TopicModel)passwordTopic.getModel());
            }
        }
    }

    private AuthorizationMethod asAuthorizationMethod(AccountManager amm) {
        return credentials -> {
            CheckCredentialsResult result = amm.checkCredentials(credentials);
            if (result.success) {
                if (result.usernameTopic != null) {
                    logger.info(String.format("Credentials check successful and username topic present for %s", credentials.username));
                    return result.usernameTopic;
                }
                logger.info(String.format("Credentials check successful but lookup or creation required for %s", credentials.username));
                return this.lookupOrCreateUsernameTopic(credentials.username, amm.name());
            }
            logger.info(String.format("Credentials check failed for %s", credentials.username));
            return null;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Topic lookupOrCreateUsernameTopic(String username, String methodName) {
        Topic usernameTopic = this.accessControlService.getUsernameTopic(username);
        if (usernameTopic != null) {
            return usernameTopic;
        }
        DMXTransaction tx = this.dmx.beginTx();
        try {
            usernameTopic = this.createUsernameAndPrivateWorkspace(username, methodName);
            tx.success();
            Topic topic = usernameTopic;
            return topic;
        }
        finally {
            tx.finish();
        }
    }

    private Topic createUsernameAndPrivateWorkspace(String username, String methodName) {
        try {
            logger.info("Creating username topic \"" + username + "\"");
            PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
            Topic usernameTopic = this.dmx.getPrivilegedAccess().getUsernameTopic(username);
            if (usernameTopic != null) {
                throw new RuntimeException("Username \"" + username + "\" exists already");
            }
            usernameTopic = (Topic)pa.runInWorkspaceContext(-1L, () -> this.dmx.createTopic(this.mf.newTopicModel("dmx.accesscontrol.username", new SimpleValue(username))));
            this.accessControlService.setWorkspaceOwner(this.ws.createWorkspace("Private Workspace", null, SharingMode.PRIVATE), username);
            pa.assignToWorkspace((DMXObject)usernameTopic, pa.getSystemWorkspaceId());
            usernameTopic.setProperty("dmx.accountmanager.name", (Object)methodName, true);
            return usernameTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating username topic \"" + username + "\" failed", e);
        }
    }

    private AccountManager getAccountManager(String methodName) {
        return this.accountManagers.get(this.accountManagers.containsKey(methodName) ? methodName : "DMX");
    }

    private AccountManager getAccountManageForUsername(Topic usernameTopic) {
        String methodName = usernameTopic.hasProperty("dmx.accountmanager.name") ? usernameTopic.getProperty("dmx.accountmanager.name").toString() : "DMX";
        return this.getAccountManager(methodName);
    }

    static {
        logger.info("Security config:\n  dmx.security.new_accounts_are_enabled = " + NEW_ACCOUNTS_ARE_ENABLED);
    }
}

