/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.AssocPlayerModelImpl;
import systems.dmx.core.impl.AssocTypeModelImpl;
import systems.dmx.core.impl.ChildTopicsModelImpl;
import systems.dmx.core.impl.CompDefModelImpl;
import systems.dmx.core.impl.DMXObjectModelImpl;
import systems.dmx.core.impl.FacetValueModelImpl;
import systems.dmx.core.impl.PlayerModelImpl;
import systems.dmx.core.impl.RelatedAssocModelImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.RoleTypeModelImpl;
import systems.dmx.core.impl.TopicDeletionModelImpl;
import systems.dmx.core.impl.TopicModelImpl;
import systems.dmx.core.impl.TopicPlayerModelImpl;
import systems.dmx.core.impl.TopicReferenceModelImpl;
import systems.dmx.core.impl.TopicTypeModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.impl.ViewAssocImpl;
import systems.dmx.core.impl.ViewConfigModelImpl;
import systems.dmx.core.impl.ViewPropsImpl;
import systems.dmx.core.impl.ViewTopicImpl;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicDeletionModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicPlayerModel;
import systems.dmx.core.model.TopicReferenceModel;
import systems.dmx.core.model.ViewConfigModel;
import systems.dmx.core.model.facets.FacetValueModel;
import systems.dmx.core.model.topicmaps.ViewAssoc;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.model.topicmaps.ViewTopic;
import systems.dmx.core.service.ModelFactory;

public class ModelFactoryImpl
implements ModelFactory {
    private static final String REF_ID_PREFIX = "ref_id:";
    private static final String REF_URI_PREFIX = "ref_uri:";
    private static final String DEL_ID_PREFIX = "del_id:";
    private static final String DEL_URI_PREFIX = "del_uri:";
    AccessLayer al;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public TopicModelImpl newTopicModel(long id, String uri, String typeUri, SimpleValue value, ChildTopicsModel childTopics) {
        return new TopicModelImpl(this.newDMXObjectModel(id, uri, typeUri, value, childTopics));
    }

    @Override
    public TopicModelImpl newTopicModel(ChildTopicsModel childTopics) {
        return this.newTopicModel(-1L, null, null, null, childTopics);
    }

    @Override
    public TopicModelImpl newTopicModel(String typeUri) {
        return this.newTopicModel(-1L, null, typeUri, null, null);
    }

    @Override
    public TopicModelImpl newTopicModel(String typeUri, SimpleValue value) {
        return this.newTopicModel(-1L, null, typeUri, value, null);
    }

    @Override
    public TopicModelImpl newTopicModel(String typeUri, ChildTopicsModel childTopics) {
        return this.newTopicModel(-1L, null, typeUri, null, childTopics);
    }

    @Override
    public TopicModelImpl newTopicModel(String uri, String typeUri) {
        return this.newTopicModel(-1L, uri, typeUri, null, null);
    }

    @Override
    public TopicModelImpl newTopicModel(String uri, String typeUri, SimpleValue value) {
        return this.newTopicModel(-1L, uri, typeUri, value, null);
    }

    @Override
    public TopicModelImpl newTopicModel(String uri, String typeUri, ChildTopicsModel childTopics) {
        return this.newTopicModel(-1L, uri, typeUri, null, childTopics);
    }

    @Override
    public TopicModelImpl newTopicModel(long id) {
        return this.newTopicModel(id, null, null, null, null);
    }

    @Override
    public TopicModelImpl newTopicModel(long id, SimpleValue value) {
        return this.newTopicModel(id, null, null, value, null);
    }

    @Override
    public TopicModelImpl newTopicModel(long id, ChildTopicsModel childTopics) {
        return this.newTopicModel(id, null, null, null, childTopics);
    }

    @Override
    public TopicModelImpl newTopicModel(TopicModel topic) {
        return new TopicModelImpl((TopicModelImpl)topic);
    }

    @Override
    public TopicModelImpl newTopicModel(JSONObject topic) {
        try {
            return new TopicModelImpl(this.newDMXObjectModel(topic));
        }
        catch (Exception e) {
            throw this.parsingFailed(topic, e, "TopicModelImpl");
        }
    }

    @Override
    public AssocModelImpl newAssocModel(long id, String uri, String typeUri, PlayerModel player1, PlayerModel player2, SimpleValue value, ChildTopicsModel childTopics) {
        return new AssocModelImpl(this.newDMXObjectModel(id, uri, typeUri, value, childTopics), (PlayerModelImpl)player1, (PlayerModelImpl)player2);
    }

    @Override
    public AssocModelImpl newAssocModel(long id, String uri, String typeUri, PlayerModel player1, PlayerModel player2) {
        return this.newAssocModel(id, uri, typeUri, player1, player2, null, null);
    }

    @Override
    public AssocModelImpl newAssocModel(String typeUri, PlayerModel player1, PlayerModel player2) {
        return this.newAssocModel(-1L, null, typeUri, player1, player2, null, null);
    }

    @Override
    public AssocModelImpl newAssocModel(String typeUri, PlayerModel player1, PlayerModel player2, ChildTopicsModel childTopics) {
        return this.newAssocModel(-1L, null, typeUri, player1, player2, null, childTopics);
    }

    @Override
    public AssocModelImpl newAssocModel() {
        return this.newAssocModel(-1L, null, null, null, null, null, null);
    }

    @Override
    public AssocModel newAssocModel(SimpleValue value) {
        return this.newAssocModel(-1L, null, null, null, null, value, null);
    }

    @Override
    public AssocModelImpl newAssocModel(ChildTopicsModel childTopics) {
        return this.newAssocModel(null, childTopics);
    }

    @Override
    public AssocModelImpl newAssocModel(String typeUri, ChildTopicsModel childTopics) {
        return this.newAssocModel(typeUri, null, null, childTopics);
    }

    @Override
    public AssocModelImpl newAssocModel(AssocModel assoc) {
        return new AssocModelImpl((AssocModelImpl)assoc);
    }

    @Override
    public AssocModelImpl newAssocModel(JSONObject assoc) {
        try {
            return new AssocModelImpl(this.newDMXObjectModel(assoc), this.parsePlayer1(assoc), this.parsePlayer2(assoc));
        }
        catch (Exception e) {
            throw this.parsingFailed(assoc, e, "AssocModelImpl");
        }
    }

    private PlayerModelImpl parsePlayer1(JSONObject assoc) throws JSONException {
        return this.parsePlayer(assoc, "player1");
    }

    private PlayerModelImpl parsePlayer2(JSONObject assoc) throws JSONException {
        return this.parsePlayer(assoc, "player2");
    }

    private PlayerModelImpl parsePlayer(JSONObject assoc, String key) throws JSONException {
        return assoc.has(key) ? this._parsePlayer(assoc.getJSONObject(key)) : null;
    }

    private PlayerModelImpl _parsePlayer(JSONObject playerModel) {
        if (playerModel.has("topicId") || playerModel.has("topicUri")) {
            return this.newTopicPlayerModel(playerModel);
        }
        if (playerModel.has("assocId")) {
            return this.newAssocPlayerModel(playerModel);
        }
        throw new RuntimeException("One of \"topicId\"/\"topicUri\"/\"assocId\" is expected");
    }

    DMXObjectModelImpl newDMXObjectModel(long id, String uri, String typeUri, SimpleValue value, ChildTopicsModel childTopics) {
        return new DMXObjectModelImpl(id, uri, typeUri, value, (ChildTopicsModelImpl)childTopics, this.al());
    }

    DMXObjectModelImpl newDMXObjectModel(JSONObject object) throws JSONException {
        return this.newDMXObjectModel(object.optLong("id", -1L), object.optString("uri", null), object.optString("typeUri", null), object.has("value") ? new SimpleValue(object.get("value")) : null, object.has("children") ? this.newChildTopicsModel(object.getJSONObject("children")) : null);
    }

    @Override
    public ChildTopicsModelImpl newChildTopicsModel() {
        return new ChildTopicsModelImpl(new HashMap<String, Object>(), this);
    }

    @Override
    public ChildTopicsModelImpl newChildTopicsModel(JSONObject values) {
        try {
            HashMap<String, Object> childTopics = new HashMap<String, Object>();
            Iterator i = values.keys();
            while (i.hasNext()) {
                String compDefUri = (String)i.next();
                Object value = values.get(compDefUri);
                if (!(value instanceof JSONArray)) {
                    childTopics.put(compDefUri, this.createChildTopicModel(compDefUri, value));
                    continue;
                }
                JSONArray valueArray = (JSONArray)value;
                ArrayList<RelatedTopicModel> topics = new ArrayList<RelatedTopicModel>();
                childTopics.put(compDefUri, topics);
                for (int j = 0; j < valueArray.length(); ++j) {
                    topics.add(this.createChildTopicModel(compDefUri, valueArray.get(j)));
                }
            }
            return new ChildTopicsModelImpl(childTopics, this);
        }
        catch (Exception e) {
            throw this.parsingFailed(values, e, "ChildTopicsModelImpl");
        }
    }

    @Override
    public String childTypeUri(String compDefUri) {
        return compDefUri.split("#")[0];
    }

    private String assocTypeUri(String compDefUri) {
        String[] s = compDefUri.split("#");
        return s.length == 2 ? s[1] : "dmx.core.composition";
    }

    private RelatedTopicModel createChildTopicModel(String compDefUri, Object value) throws JSONException {
        String childTypeUri = this.childTypeUri(compDefUri);
        if (value instanceof JSONObject) {
            JSONObject val = (JSONObject)value;
            if (val.has("value") || val.has("children")) {
                RelatedTopicModel topicRef;
                AssocModelImpl relatingAssoc = null;
                if (val.has("assoc")) {
                    JSONObject assoc = val.getJSONObject("assoc");
                    this.initTypeUri(assoc, this.assocTypeUri(compDefUri));
                    relatingAssoc = this.newAssocModel(assoc);
                }
                if (val.has("value") && (topicRef = this.createReferenceModel(val.get("value"), relatingAssoc)) != null) {
                    return topicRef;
                }
                this.initTypeUri(val, childTypeUri);
                TopicModelImpl topic = this.newTopicModel(val);
                if (relatingAssoc != null) {
                    return this.newRelatedTopicModel(topic, (AssocModel)relatingAssoc);
                }
                return this.newRelatedTopicModel(topic);
            }
            return this.newRelatedTopicModel(this.newTopicModel(childTypeUri, (ChildTopicsModel)this.newChildTopicsModel(val)));
        }
        RelatedTopicModel topicRef = this.createReferenceModel(value, null);
        if (topicRef != null) {
            return topicRef;
        }
        return this.newRelatedTopicModel(this.newTopicModel(childTypeUri, new SimpleValue(value)));
    }

    private RelatedTopicModel createReferenceModel(Object value, AssocModel relatingAssoc) {
        if (value instanceof String) {
            String val = (String)value;
            if (val.startsWith(REF_ID_PREFIX)) {
                long topicId = this.refTopicId(val);
                if (relatingAssoc != null) {
                    return this.newTopicReferenceModel(topicId, relatingAssoc);
                }
                return this.newTopicReferenceModel(topicId);
            }
            if (val.startsWith(REF_URI_PREFIX)) {
                String topicUri = this.refTopicUri(val);
                if (relatingAssoc != null) {
                    return this.newTopicReferenceModel(topicUri, relatingAssoc);
                }
                return this.newTopicReferenceModel(topicUri);
            }
            if (val.startsWith(DEL_ID_PREFIX)) {
                if (relatingAssoc != null) {
                    return this.newTopicDeletionModel(-1L, relatingAssoc);
                }
                throw new RuntimeException("No assoc given for deleting \"" + val + "\"");
            }
            if (val.startsWith(DEL_URI_PREFIX)) {
                throw new RuntimeException("Deleting by URI not implemented");
            }
        }
        return null;
    }

    private void initTypeUri(JSONObject object, String typeUri) throws JSONException {
        if (!object.has("typeUri")) {
            object.put("typeUri", (Object)typeUri);
            return;
        }
        String _typeUri = object.getString("typeUri");
        if (!_typeUri.equals(typeUri)) {
            throw new IllegalArgumentException("A \"" + typeUri + "\" update model has type \"" + _typeUri + "\"");
        }
    }

    private long refTopicId(String val) {
        return Long.parseLong(val.substring(REF_ID_PREFIX.length()));
    }

    private String refTopicUri(String val) {
        return val.substring(REF_URI_PREFIX.length());
    }

    private String delTopicUri(String val) {
        return val.substring(DEL_URI_PREFIX.length());
    }

    @Override
    public TopicPlayerModelImpl newTopicPlayerModel(long topicId, String roleTypeUri) {
        return new TopicPlayerModelImpl(topicId, roleTypeUri, this.al());
    }

    @Override
    public TopicPlayerModelImpl newTopicPlayerModel(String topicUri, String roleTypeUri) {
        return new TopicPlayerModelImpl(topicUri, roleTypeUri, this.al());
    }

    @Override
    public TopicPlayerModelImpl newTopicPlayerModel(long topicId, String topicUri, String roleTypeUri) {
        return new TopicPlayerModelImpl(topicId, topicUri, roleTypeUri, this.al());
    }

    @Override
    public TopicPlayerModelImpl newTopicPlayerModel(JSONObject topicPlayer) {
        try {
            long topicId = topicPlayer.optLong("topicId", -1L);
            String topicUri = topicPlayer.optString("topicUri", null);
            String roleTypeUri = topicPlayer.getString("roleTypeUri");
            if (topicId == -1L && topicUri == null) {
                throw new IllegalArgumentException("Neiter \"topicId\" nor \"topicUri\" is set");
            }
            return this.newTopicPlayerModel(topicId, topicUri, roleTypeUri);
        }
        catch (Exception e) {
            throw this.parsingFailed(topicPlayer, e, "TopicPlayerModelImpl");
        }
    }

    @Override
    public AssocPlayerModelImpl newAssocPlayerModel(long assocId, String roleTypeUri) {
        return new AssocPlayerModelImpl(assocId, roleTypeUri, this.al());
    }

    @Override
    public AssocPlayerModelImpl newAssocPlayerModel(JSONObject assocPlayer) {
        try {
            long assocId = assocPlayer.getLong("assocId");
            String roleTypeUri = assocPlayer.getString("roleTypeUri");
            return this.newAssocPlayerModel(assocId, roleTypeUri);
        }
        catch (Exception e) {
            throw this.parsingFailed(assocPlayer, e, "AssocPlayerModelImpl");
        }
    }

    @Override
    public RoleTypeModelImpl newRoleTypeModel(TopicModel roleTypeTopic, ViewConfigModel viewConfig) {
        return new RoleTypeModelImpl((TopicModelImpl)roleTypeTopic, (ViewConfigModelImpl)viewConfig);
    }

    @Override
    public RoleTypeModelImpl newRoleTypeModel(JSONObject roleType) {
        try {
            String uri = roleType.optString("uri", null);
            SimpleValue value = new SimpleValue(roleType.getString("value"));
            return this.newRoleTypeModel(this.newTopicModel(uri, "dmx.core.role_type", value), this.newViewConfigModel(roleType.optJSONArray("viewConfigTopics")));
        }
        catch (Exception e) {
            throw this.parsingFailed(roleType, e, "RoleTypeModelImpl");
        }
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(long topicId) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicId), this.newAssocModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(long topicId, AssocModel relatingAssoc) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicId), (AssocModelImpl)relatingAssoc);
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(String topicUri) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicUri, (String)null), this.newAssocModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(String topicUri, AssocModel relatingAssoc) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicUri, (String)null), (AssocModelImpl)relatingAssoc);
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(String topicTypeUri, SimpleValue value) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicTypeUri, value), this.newAssocModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(String topicTypeUri, ChildTopicsModel childTopics) {
        return new RelatedTopicModelImpl(this.newTopicModel(topicTypeUri, childTopics), this.newAssocModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(TopicModel topic) {
        return new RelatedTopicModelImpl((TopicModelImpl)topic, this.newAssocModel());
    }

    @Override
    public RelatedTopicModelImpl newRelatedTopicModel(TopicModel topic, AssocModel relatingAssoc) {
        return new RelatedTopicModelImpl((TopicModelImpl)topic, (AssocModelImpl)relatingAssoc);
    }

    @Override
    public RelatedAssocModelImpl newRelatedAssocModel(AssocModel assoc, AssocModel relatingAssoc) {
        return new RelatedAssocModelImpl((AssocModelImpl)assoc, (AssocModelImpl)relatingAssoc);
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(long topicId) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicId));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(long topicId, AssocModel relatingAssoc) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicId, relatingAssoc));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(String topicUri) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicUri));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(String topicUri, AssocModel relatingAssoc) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicUri, relatingAssoc));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(long topicId, ChildTopicsModel relatingAssocChildTopics) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicId, (AssocModel)this.newAssocModel(relatingAssocChildTopics)));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(String topicUri, ChildTopicsModel relatingAssocChildTopics) {
        return new TopicReferenceModelImpl(this.newRelatedTopicModel(topicUri, (AssocModel)this.newAssocModel(relatingAssocChildTopics)));
    }

    @Override
    public TopicReferenceModel newTopicReferenceModel(Object topicIdOrUri) {
        RelatedTopicModelImpl relTopic;
        if (topicIdOrUri instanceof Long) {
            relTopic = this.newRelatedTopicModel((Long)topicIdOrUri);
        } else if (topicIdOrUri instanceof String) {
            relTopic = this.newRelatedTopicModel((String)topicIdOrUri);
        } else {
            throw new IllegalArgumentException("Tried to build a TopicReferenceModel from a " + topicIdOrUri.getClass().getName() + " (expected are String or Long)");
        }
        return new TopicReferenceModelImpl(relTopic);
    }

    @Override
    public TopicDeletionModel newTopicDeletionModel(long topicId) {
        return new TopicDeletionModelImpl(this.newRelatedTopicModel(topicId));
    }

    @Override
    public TopicDeletionModel newTopicDeletionModel(long topicId, AssocModel relatingAssoc) {
        return new TopicDeletionModelImpl(this.newRelatedTopicModel(topicId, relatingAssoc));
    }

    @Override
    public TopicDeletionModel newTopicDeletionModel(String topicUri) {
        return new TopicDeletionModelImpl(this.newRelatedTopicModel(topicUri));
    }

    @Override
    public TopicDeletionModel newTopicDeletionModel(String topicUri, AssocModel relatingAssoc) {
        return new TopicDeletionModelImpl(this.newRelatedTopicModel(topicUri, relatingAssoc));
    }

    @Override
    public TopicTypeModelImpl newTopicTypeModel(TopicModel typeTopic, String dataTypeUri, List<CompDefModel> compDefs, ViewConfigModel viewConfig) {
        return new TopicTypeModelImpl(this.newTypeModel(typeTopic, dataTypeUri, compDefs, (ViewConfigModelImpl)viewConfig));
    }

    @Override
    public TopicTypeModelImpl newTopicTypeModel(String uri, String value, String dataTypeUri) {
        return new TopicTypeModelImpl(this.newTypeModel(uri, "dmx.core.topic_type", new SimpleValue(value), dataTypeUri));
    }

    @Override
    public TopicTypeModelImpl newTopicTypeModel(JSONObject topicType) {
        try {
            return new TopicTypeModelImpl(this.newTypeModel(topicType.put("typeUri", (Object)"dmx.core.topic_type")));
        }
        catch (Exception e) {
            throw this.parsingFailed(topicType, e, "TopicTypeModelImpl");
        }
    }

    @Override
    public AssocTypeModelImpl newAssocTypeModel(TopicModel typeTopic, String dataTypeUri, List<CompDefModel> compDefs, ViewConfigModel viewConfig) {
        return new AssocTypeModelImpl(this.newTypeModel(typeTopic, dataTypeUri, compDefs, (ViewConfigModelImpl)viewConfig));
    }

    @Override
    public AssocTypeModelImpl newAssocTypeModel(String uri, String value, String dataTypeUri) {
        return new AssocTypeModelImpl(this.newTypeModel(uri, "dmx.core.assoc_type", new SimpleValue(value), dataTypeUri));
    }

    @Override
    public AssocTypeModelImpl newAssocTypeModel(JSONObject assocType) {
        try {
            return new AssocTypeModelImpl(this.newTypeModel(assocType.put("typeUri", (Object)"dmx.core.assoc_type")));
        }
        catch (Exception e) {
            throw this.parsingFailed(assocType, e, "AssocTypeModelImpl");
        }
    }

    TypeModelImpl newTypeModel(TopicModel typeTopic, String dataTypeUri, List<CompDefModel> compDefs, ViewConfigModelImpl viewConfig) {
        return new TypeModelImpl((TopicModelImpl)typeTopic, dataTypeUri, compDefs, viewConfig);
    }

    TypeModelImpl newTypeModel(String uri, String typeUri, SimpleValue value, String dataTypeUri) {
        return new TypeModelImpl(this.newTopicModel(uri, typeUri, value), dataTypeUri, new ArrayList<CompDefModel>(), this.newViewConfigModel());
    }

    TypeModelImpl newTypeModel(JSONObject typeModel) throws JSONException {
        TopicModelImpl typeTopic = this.newTopicModel(typeModel);
        return new TypeModelImpl(typeTopic, typeModel.optString("dataTypeUri", null), this.parseCompDefs(typeModel.optJSONArray("compDefs"), typeTopic.getUri()), this.newViewConfigModel(typeModel.optJSONArray("viewConfigTopics")));
    }

    private List<CompDefModel> parseCompDefs(JSONArray compDefs, String parentTypeUri) throws JSONException {
        ArrayList<CompDefModel> _compDefs = new ArrayList<CompDefModel>();
        if (compDefs != null) {
            for (int i = 0; i < compDefs.length(); ++i) {
                JSONObject compDef = compDefs.getJSONObject(i).put("parentTypeUri", (Object)parentTypeUri);
                _compDefs.add(this.newCompDefModel(compDef));
            }
        }
        return _compDefs;
    }

    @Override
    public CompDefModelImpl newCompDefModel(String parentTypeUri, String childTypeUri, String childCardinalityUri) {
        return this.newCompDefModel(-1L, null, null, false, false, parentTypeUri, childTypeUri, childCardinalityUri, null);
    }

    @Override
    public CompDefModelImpl newCompDefModel(String parentTypeUri, String childTypeUri, String childCardinalityUri, ViewConfigModel viewConfig) {
        return this.newCompDefModel(-1L, null, null, false, false, parentTypeUri, childTypeUri, childCardinalityUri, viewConfig);
    }

    @Override
    public CompDefModelImpl newCompDefModel(String customAssocTypeUri, boolean isIdentityAttr, boolean includeInLabel, String parentTypeUri, String childTypeUri, String childCardinalityUri) {
        return this.newCompDefModel(-1L, null, customAssocTypeUri, isIdentityAttr, includeInLabel, parentTypeUri, childTypeUri, childCardinalityUri, null);
    }

    @Override
    public CompDefModelImpl newCompDefModel(AssocModel assoc, ViewConfigModel viewConfig) {
        return new CompDefModelImpl((AssocModelImpl)assoc, (ViewConfigModelImpl)viewConfig);
    }

    @Override
    public CompDefModelImpl newCompDefModel(JSONObject compDef) {
        try {
            PlayerModelImpl player1 = this.parsePlayer1(compDef);
            PlayerModelImpl player2 = this.parsePlayer2(compDef);
            return new CompDefModelImpl(this.newAssocModel(compDef.optLong("id", -1L), null, "dmx.core.composition_def", player1 != null ? player1 : this.parentPlayer(compDef.getString("parentTypeUri")), player2 != null ? player2 : this.childPlayer(compDef.getString("childTypeUri")), null, this.childTopics(compDef)), this.newViewConfigModel(compDef.optJSONArray("viewConfigTopics")));
        }
        catch (Exception e) {
            throw this.parsingFailed(compDef, e, "CompDefModelImpl");
        }
    }

    CompDefModelImpl newCompDefModel(long id, String uri, String customAssocTypeUri, boolean isIdentityAttr, boolean includeInLabel, String parentTypeUri, String childTypeUri, String childCardinalityUri, ViewConfigModel viewConfig) {
        return new CompDefModelImpl(this.newAssocModel(id, uri, "dmx.core.composition_def", this.parentPlayer(parentTypeUri), this.childPlayer(childTypeUri), null, this.childTopics(childCardinalityUri, customAssocTypeUri, isIdentityAttr, includeInLabel)), (ViewConfigModelImpl)viewConfig);
    }

    CompDefModelImpl newCompDefModel(ChildTopicsModel childTopics) {
        return new CompDefModelImpl(this.newAssocModel("dmx.core.composition_def", childTopics));
    }

    private TopicPlayerModel parentPlayer(String parentTypeUri) {
        return this.newTopicPlayerModel(parentTypeUri, "dmx.core.parent_type");
    }

    private TopicPlayerModel childPlayer(String childTypeUri) {
        return this.newTopicPlayerModel(childTypeUri, "dmx.core.child_type");
    }

    private ChildTopicsModel childTopics(JSONObject compDef) throws JSONException {
        return this.childTopics(compDef.getString("childCardinalityUri"), compDef.isNull("customAssocTypeUri") ? null : compDef.getString("customAssocTypeUri"), compDef.optBoolean("isIdentityAttr"), compDef.optBoolean("includeInLabel"));
    }

    private ChildTopicsModel childTopics(String cardinalityUri, String customAssocTypeUri, boolean isIdentityAttr, boolean includeInLabel) {
        ChildTopicsModel childTopics = this.newChildTopicsModel().setRef("dmx.core.cardinality", cardinalityUri).set("dmx.core.identity_attr", isIdentityAttr).set("dmx.core.include_in_label", includeInLabel);
        if (customAssocTypeUri != null) {
            if (customAssocTypeUri.startsWith(DEL_URI_PREFIX)) {
                childTopics.setDeletionRef("dmx.core.assoc_type#dmx.core.custom_assoc_type", this.delTopicUri(customAssocTypeUri));
            } else {
                childTopics.setRef("dmx.core.assoc_type#dmx.core.custom_assoc_type", customAssocTypeUri);
            }
        }
        return childTopics;
    }

    @Override
    public ViewConfigModelImpl newViewConfigModel() {
        return new ViewConfigModelImpl(new HashMap<String, TopicModelImpl>(), this.al());
    }

    @Override
    public ViewConfigModelImpl newViewConfigModel(Iterable<? extends TopicModel> configTopics) {
        HashMap<String, TopicModelImpl> _configTopics = new HashMap<String, TopicModelImpl>();
        for (TopicModel topicModel : configTopics) {
            _configTopics.put(topicModel.getTypeUri(), (TopicModelImpl)topicModel);
        }
        return new ViewConfigModelImpl(_configTopics, this.al());
    }

    @Override
    public ViewConfigModelImpl newViewConfigModel(JSONArray configTopics) {
        try {
            HashMap<String, TopicModelImpl> _configTopics = new HashMap<String, TopicModelImpl>();
            if (configTopics != null) {
                for (int i = 0; i < configTopics.length(); ++i) {
                    TopicModelImpl configTopic = this.newTopicModel(configTopics.getJSONObject(i));
                    _configTopics.put(configTopic.getTypeUri(), configTopic);
                }
            }
            return new ViewConfigModelImpl(_configTopics, this.al());
        }
        catch (Exception e) {
            throw this.parsingFailed(configTopics, e, "ViewConfigModelImpl");
        }
    }

    @Override
    public ViewTopic newViewTopic(TopicModel topic, ViewProps viewProps) {
        return new ViewTopicImpl((TopicModelImpl)topic, viewProps);
    }

    @Override
    public ViewAssoc newViewAssoc(AssocModel assoc, ViewProps viewProps) {
        return new ViewAssocImpl((AssocModelImpl)assoc, viewProps);
    }

    @Override
    public ViewProps newViewProps() {
        return new ViewPropsImpl();
    }

    @Override
    public ViewProps newViewProps(int x, int y) {
        return new ViewPropsImpl(x, y);
    }

    @Override
    public ViewProps newViewProps(int x, int y, boolean visibility, boolean pinned) {
        return new ViewPropsImpl(x, y, visibility, pinned);
    }

    @Override
    public ViewProps newViewProps(boolean visibility) {
        return new ViewPropsImpl(visibility);
    }

    @Override
    public ViewProps newViewProps(boolean visibility, boolean pinned) {
        return new ViewPropsImpl(visibility, pinned);
    }

    @Override
    public ViewProps newViewProps(JSONObject viewProps) {
        return new ViewPropsImpl(viewProps);
    }

    @Override
    public FacetValueModel newFacetValueModel(String childTypeUri) {
        return new FacetValueModelImpl(childTypeUri, (ModelFactory)this);
    }

    @Override
    public FacetValueModel newFacetValueModel(JSONObject facetValue) {
        try {
            ChildTopicsModelImpl childTopics = this.newChildTopicsModel(facetValue);
            if (childTopics.size() != 1) {
                throw new RuntimeException("There are " + childTopics.size() + " child topic entries (expected is 1)");
            }
            return new FacetValueModelImpl(childTopics);
        }
        catch (Exception e) {
            throw this.parsingFailed(facetValue, e, "FacetValueModelImpl");
        }
    }

    private RuntimeException parsingFailed(JSONObject o, Exception e, String className) {
        try {
            return new RuntimeException("JSON parsing failed, " + className + " " + o.toString(4), e);
        }
        catch (JSONException je) {
            return new RuntimeException("JSON parsing failed, " + className + " " + o, e);
        }
    }

    private RuntimeException parsingFailed(JSONArray a, Exception e, String className) {
        try {
            return new RuntimeException("JSON parsing failed, " + className + " " + a.toString(4), e);
        }
        catch (JSONException je) {
            return new RuntimeException("JSON parsing failed, " + className + " " + a, e);
        }
    }

    private AccessLayer al() {
        if (this.al == null) {
            throw new RuntimeException("Before using the ModelFactory an AccessLayer must be set");
        }
        return this.al;
    }
}

