/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.storage.neo4j;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.tooling.GlobalGraphOperations;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.storage.neo4j.Neo4jStorage;
import systems.dmx.storage.neo4j.NodeType;

abstract class ModelIterable<M extends DMXObjectModel>
implements Iterable<M> {
    protected Neo4jStorage storage;
    private NodeType nodeType;
    private Iterable<Node> nodes;

    ModelIterable(Neo4jStorage storage, NodeType nodeType) {
        this.storage = storage;
        this.nodeType = nodeType;
        this.nodes = GlobalGraphOperations.at((GraphDatabaseService)storage.neo4j).getAllNodes();
    }

    @Override
    public Iterator<M> iterator() {
        return new ModelIterator();
    }

    abstract M buildModel(Node var1);

    private class ModelIterator
    implements Iterator<M> {
        private Iterator<Node> i;
        private Node next;

        private ModelIterator() {
            this.i = ModelIterable.this.nodes.iterator();
        }

        @Override
        public boolean hasNext() {
            this.fetchNext();
            return this.next != null;
        }

        @Override
        public M next() {
            if (this.next == null) {
                throw new NoSuchElementException("next() called when there is no next node");
            }
            return ModelIterable.this.buildModel(this.next);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("removal is not supported");
        }

        private void fetchNext() {
            this.next = null;
            while (this.i.hasNext() && this.next == null) {
                Node node = this.i.next();
                if (!ModelIterable.this.nodeType.isTypeOf(node)) continue;
                this.next = node;
            }
        }
    }
}

