/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.files.migrations;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Topic;
import systems.dmx.core.service.Migration;
import systems.dmx.core.util.JavaUtils;

public class Migration6
extends Migration {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        List<String> office = Arrays.asList("doc", "docx", "xls", "xlsx", "ppt", "pptx", "odt", "ods", "odp");
        int f = 0;
        int o = 0;
        int r = 0;
        int c = 0;
        for (Topic file : this.dmx.getTopicsByType("dmx.files.file")) {
            ++f;
            String fileName = file.getChildTopics().getString("dmx.files.file_name", null);
            if (fileName == null) {
                ++c;
                this.logger.warning(String.format("File %d has no name, path=%s", file.getId(), file.getChildTopics().getString("dmx.files.file_name", null)));
                continue;
            }
            String ext = JavaUtils.getExtension((String)fileName);
            if (!office.contains(ext)) continue;
            ++o;
            String mediaType = file.getChildTopics().getString("dmx.files.media_type", null);
            if (mediaType != null) continue;
            ++r;
            mediaType = JavaUtils.getFileType((String)fileName);
            file.update(this.mf.newChildTopicsModel().set("dmx.files.media_type", (Object)mediaType));
        }
        this.logger.info(String.format("### Office media type migration complete\n  File topics: %d\n  Office files: %d\n  Office files repaired: %d\n  Corrupt files: %d", f, o, r, c));
    }
}

