/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.accountmanagement;

import java.util.logging.Logger;
import systems.dmx.accountmanagement.AccountManager;
import systems.dmx.accountmanagement.CheckCredentialsResult;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.service.accesscontrol.PrivilegedAccess;
import systems.dmx.core.util.JavaUtils;

final class DmxAccountManager
implements AccountManager {
    private static final Logger logger = Logger.getLogger(DmxAccountManager.class.getName());
    static final String NAME = "DMX";
    private final CoreService dmx;
    private final ModelFactory mf;
    private final String siteSalt;

    DmxAccountManager(CoreService dmx, ModelFactory mf, String siteSalt) {
        this.dmx = dmx;
        this.mf = mf;
        this.siteSalt = siteSalt;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public CheckCredentialsResult checkCredentials(Credentials credentials) {
        Topic usernameTopic = this.dmx.getPrivilegedAccess().checkCredentials(credentials);
        return usernameTopic != null ? CheckCredentialsResult.success(usernameTopic) : CheckCredentialsResult.failed();
    }

    @Override
    public void createAccount(Credentials cred) {
        PrivilegedAccess pa = this.dmx.getPrivilegedAccess();
        Topic usernameTopic = this.dmx.getPrivilegedAccess().getUsernameTopic(cred.username);
        String salt = JavaUtils.random256();
        try {
            Topic userAccount = (Topic)pa.runInWorkspaceContext(-1L, () -> this.dmx.createTopic(this.mf.newTopicModel("dmx.accesscontrol.user_account", this.mf.newChildTopicsModel().setRef("dmx.accesscontrol.username", usernameTopic.getId()).set("dmx.accesscontrol.password", (Object)JavaUtils.encodeSHA256((String)(this.siteSalt + salt + cred.password))))));
            logger.info("### Salting password of user \"" + cred.username + "\"");
            RelatedTopic passwordTopic = userAccount.getChildTopics().getTopic("dmx.accesscontrol.password");
            passwordTopic.setProperty("dmx.accesscontrol.salt", (Object)salt, false);
            long privateWorkspaceId = pa.getPrivateWorkspace(cred.username).getId();
            pa.assignToWorkspace((DMXObject)userAccount, privateWorkspaceId);
            pa.assignToWorkspace((DMXObject)passwordTopic, privateWorkspaceId);
            pa.assignToWorkspace((DMXObject)passwordTopic.getRelatingAssoc(), privateWorkspaceId);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("DMX account creation for user %s failed", cred.username), e);
        }
    }

    @Override
    public void changePassword(Credentials currentCred, Credentials newCred) {
        this.dmx.getPrivilegedAccess().changePassword(newCred);
    }

    @Override
    public void onUsernameDeleted(String username) {
    }
}

