/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import systems.dmx.core.impl.WebSocketServiceImpl;

class Messages
implements Iterable<Message> {
    private List<Message> messages = new ArrayList<Message>();
    private static Logger logger = Logger.getLogger("systems.dmx.core.impl.Messages");
    private static final ThreadLocal<Messages> threadLocalDirectives = new ThreadLocal(){

        protected Messages initialValue() {
            logger.fine("### Creating tread-local messages");
            return new Messages();
        }
    };

    Messages() {
    }

    static Messages get() {
        return threadLocalDirectives.get();
    }

    void add(Dest dest, String message, Object ... params) {
        this.messages.add(new Message(dest, message, params));
    }

    static void remove() {
        logger.fine("### Removing tread-local messages");
        threadLocalDirectives.remove();
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }

    class Message {
        public Dest dest;
        public String message;
        public Object[] params;

        private Message(Dest dest, String message, Object[] params) {
            this.dest = dest;
            this.message = message;
            this.params = params;
        }
    }

    static enum Dest {
        ORIGIN{

            @Override
            void send(Message message, WebSocketServiceImpl wss) {
                wss._sendToOrigin(message.message);
            }
        }
        ,
        ALL{

            @Override
            void send(Message message, WebSocketServiceImpl wss) {
                wss._sendToAll(message.message);
            }
        }
        ,
        ALL_BUT_ORIGIN{

            @Override
            void send(Message message, WebSocketServiceImpl wss) {
                wss._sendToAllButOrigin(message.message);
            }
        }
        ,
        READ_ALLOWED{

            @Override
            void send(Message message, WebSocketServiceImpl wss) {
                wss._sendToReadAllowed(message.message, (Long)message.params[0]);
            }
        }
        ,
        SOME{

            @Override
            void send(Message message, WebSocketServiceImpl wss) {
                wss._sendToSome(message.message, (Predicate)message.params[0]);
            }
        };


        abstract void send(Message var1, WebSocketServiceImpl var2);
    }
}

