/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.DMXObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.impl.AccessLayer;
import systems.dmx.core.impl.AssocModelImpl;
import systems.dmx.core.impl.ChangeReportImpl;
import systems.dmx.core.impl.ChildTopicsFetcher;
import systems.dmx.core.impl.ChildTopicsModelImpl;
import systems.dmx.core.impl.EventManager;
import systems.dmx.core.impl.ModelFactoryImpl;
import systems.dmx.core.impl.RelatedTopicModelImpl;
import systems.dmx.core.impl.TypeModelImpl;
import systems.dmx.core.impl.ValueIntegrator;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.CompDefModel;
import systems.dmx.core.model.DMXObjectModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.RelatedObjectModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.Directive;
import systems.dmx.core.service.Directives;
import systems.dmx.core.service.accesscontrol.AccessControlException;

public class DMXObjectModelImpl
implements DMXObjectModel {
    private static final String LABEL_CHILD_SEPARATOR = " ";
    private static final String LABEL_TOPIC_SEPARATOR = ", ";
    long id;
    String uri;
    String typeUri;
    SimpleValue value;
    ChildTopicsModelImpl childTopics;
    AccessLayer al;
    EventManager em;
    ModelFactoryImpl mf;
    Logger logger = Logger.getLogger(this.getClass().getName());

    DMXObjectModelImpl(long id, String uri, String typeUri, SimpleValue value, ChildTopicsModelImpl childTopics, AccessLayer al) {
        this.id = id;
        this.uri = uri;
        this.typeUri = typeUri;
        this.value = value;
        this.childTopics = childTopics != null ? childTopics : al.mf.newChildTopicsModel();
        this.al = al;
        this.em = al.em;
        this.mf = al.mf;
    }

    DMXObjectModelImpl(DMXObjectModelImpl object) {
        this(object.getId(), object.getUri(), object.getTypeUri(), object.getSimpleValue(), object.getChildTopics(), object.al);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public String getTypeUri() {
        return this.typeUri;
    }

    @Override
    public void setTypeUri(String typeUri) {
        this.typeUri = typeUri;
    }

    @Override
    public SimpleValue getSimpleValue() {
        return this.value;
    }

    @Override
    public void setSimpleValue(String value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(int value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(long value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(boolean value) {
        this.setSimpleValue(new SimpleValue(value));
    }

    @Override
    public void setSimpleValue(SimpleValue value) {
        this.value = value;
    }

    @Override
    public ChildTopicsModelImpl getChildTopics() {
        return this.childTopics;
    }

    @Override
    public void setChildTopics(ChildTopicsModel childTopics) {
        this.childTopics = (ChildTopicsModelImpl)childTopics;
    }

    @Override
    public void set(DMXObjectModel object) {
        this.setId(object.getId());
        this.setUri(object.getUri());
        this.setTypeUri(object.getTypeUri());
        this.setSimpleValue(object.getSimpleValue());
        this.setChildTopics(object.getChildTopics());
    }

    @Override
    public PlayerModel createPlayerModel(String roleTypeUri) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public JSONObject toJSON() {
        try {
            return new JSONObject().put("id", this.id).put("uri", (Object)this.uri).put("typeUri", (Object)this.typeUri).put("value", this.value != null ? this.value.value() : null).put("children", (Object)this.childTopics.toJSON());
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failed", e);
        }
    }

    @Override
    public DMXObjectModel clone() {
        try {
            DMXObjectModel object = (DMXObjectModel)super.clone();
            object.setChildTopics(this.childTopics.clone());
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Cloning a DMXObjectModel failed", e);
        }
    }

    public boolean equals(Object o) {
        return ((DMXObjectModel)o).getId() == this.id;
    }

    public int hashCode() {
        return Long.valueOf(this.id).hashCode();
    }

    public String toString() {
        return this.dump();
    }

    boolean isReadable() {
        try {
            this.checkReadAccess();
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    String className() {
        throw new UnsupportedOperationException();
    }

    <O extends DMXObject> O instantiate() {
        throw new UnsupportedOperationException();
    }

    DMXObjectModelImpl createModelWithChildTopics(ChildTopicsModel childTopics) {
        throw new UnsupportedOperationException();
    }

    TypeModelImpl getType() {
        throw new UnsupportedOperationException();
    }

    List<AssocModelImpl> getAssocs() {
        throw new UnsupportedOperationException();
    }

    RelatedTopicModelImpl getRelatedTopic(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        throw new UnsupportedOperationException();
    }

    List<RelatedTopicModelImpl> getRelatedTopics(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        throw new UnsupportedOperationException();
    }

    List<RelatedTopicModelImpl> getRelatedTopics(List assocTypeUris, String myRoleTypeUri, String othersRoleTypeUri, String othersTopicTypeUri) {
        throw new UnsupportedOperationException();
    }

    <M extends RelatedObjectModel> List<M> getRelatedObjects(String assocTypeUri, String myRoleTypeUri, String othersRoleTypeUri, String othersTypeUri) {
        throw new UnsupportedOperationException();
    }

    void storeUri() {
        throw new UnsupportedOperationException();
    }

    void storeTypeUri() {
        throw new UnsupportedOperationException();
    }

    void storeSimpleValue() {
        throw new UnsupportedOperationException();
    }

    Object getProperty(String propUri) {
        return this.al.db.fetchProperty(this.id, propUri);
    }

    boolean hasProperty(String propUri) {
        return this.al.db.hasProperty(this.id, propUri);
    }

    void storeProperty(String propUri, Object propValue, boolean addToIndex) {
        throw new UnsupportedOperationException();
    }

    void removeProperty(String propUri) {
        throw new UnsupportedOperationException();
    }

    void _delete() {
        throw new UnsupportedOperationException();
    }

    <M extends DMXObjectModelImpl> M checkReadAccess() {
        throw new UnsupportedOperationException();
    }

    void checkWriteAccess() {
        throw new UnsupportedOperationException();
    }

    DMXEvent getPreUpdateEvent() {
        throw new UnsupportedOperationException();
    }

    DMXEvent getPostUpdateEvent() {
        throw new UnsupportedOperationException();
    }

    DMXEvent getPreDeleteEvent() {
        throw new UnsupportedOperationException();
    }

    DMXEvent getPostDeleteEvent() {
        throw new UnsupportedOperationException();
    }

    Directive getUpdateDirective() {
        throw new UnsupportedOperationException();
    }

    Directive getDeleteDirective() {
        throw new UnsupportedOperationException();
    }

    void preCreate() {
    }

    void postCreate() {
    }

    void preUpdate(DMXObjectModel updateModel) {
    }

    void postUpdate(DMXObjectModel updateModel, DMXObjectModel oldObject) {
    }

    void preDelete() {
    }

    void postDelete() {
    }

    final void update(ChildTopicsModel childTopics) {
        this.update(this.createModelWithChildTopics(childTopics));
    }

    final <O extends DMXObject> O update(DMXObjectModelImpl updateModel) {
        try {
            this.logger.info("Updating " + this.objectInfo() + " (typeUri=\"" + this.typeUri + "\")");
            DMXObjectModel oldObject = this.clone();
            this.em.fireEvent(this.getPreUpdateEvent(), this.instantiate(), updateModel);
            this.preUpdate(updateModel);
            this._updateUri(updateModel.getUri());
            this._updateTypeUri(updateModel.getTypeUri());
            ChangeReportImpl report = new ValueIntegrator((AccessLayer)this.al).integrate(updateModel, this, null).report;
            this.postUpdate(updateModel, oldObject);
            O object = this.instantiate();
            Directives.get().add(this.getUpdateDirective(), (JSONEnabled)object);
            this.em.fireEvent(this.getPostUpdateEvent(), object, report, updateModel);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Updating " + this.objectInfo() + " failed (typeUri=\"" + this.typeUri + "\")", e);
        }
    }

    final void updateChildTopics(ChildTopicsModel updateModel, CompDefModel compDef) {
        new ValueIntegrator(this.al).integrate(this.createModelWithChildTopics(updateModel), this, compDef);
    }

    final void updateUri(String uri) {
        this.setUri(uri);
        this.storeUri();
    }

    final void updateTypeUri(String typeUri) {
        this.setTypeUri(typeUri);
        this.storeTypeUri();
    }

    final void updateSimpleValue(SimpleValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Tried to set a null SimpleValue (" + this + ")");
        }
        this.setSimpleValue(value);
        this.storeSimpleValue();
    }

    final void delete() {
        try {
            if (this.id == -1L) {
                throw new RuntimeException("ID not initialzed in " + this);
            }
            this.em.fireEvent(this.getPreDeleteEvent(), this.instantiate());
            this.preDelete();
            for (AssocModelImpl assoc : this.getAssocs()) {
                assoc.delete();
            }
            this.logger.info("Deleting " + this.objectInfo() + " (typeUri=\"" + this.typeUri + "\")");
            this._delete();
            this.postDelete();
            Directives.get().add(this.getDeleteDirective(), this);
            this.em.fireEvent(this.getPostDeleteEvent(), this);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().equals("Node[" + this.id + "] has been deleted in this tx")) {
                this.logger.info("### Assoc " + this.id + " has already been deleted in this transaction. This can happen while deleting a topic with associations A1 and A2 while A2 points to A1 (" + this + ")");
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Deleting " + this.objectInfo() + " failed (typeUri=\"" + this.typeUri + "\")", e);
        }
    }

    final DMXObjectModel loadChildTopics(boolean deep) {
        for (CompDefModel compDefModel : this.getType().getCompDefs()) {
            this.loadChildTopics(compDefModel, deep);
        }
        return this;
    }

    final DMXObjectModel loadChildTopics(String compDefUri, boolean deep) {
        try {
            return this.loadChildTopics(this.getCompDef(compDefUri), deep);
        }
        catch (Exception e) {
            throw new RuntimeException("Loading \"" + compDefUri + "\" child topics of " + this.objectInfo() + " failed", e);
        }
    }

    final DMXObjectModel loadChildTopics(CompDefModel compDef, boolean deep) {
        String compDefUri = compDef.getCompDefUri();
        if (!this.childTopics.has(compDefUri)) {
            this.logger.fine("### Loading \"" + compDefUri + "\" child topics of " + this.objectInfo());
            new ChildTopicsFetcher(this.al).fetch(this, compDef, deep);
        }
        return this;
    }

    final boolean uriChange(String newUri, String compareUri) {
        return newUri != null && !newUri.equals(compareUri);
    }

    final boolean isSimple() {
        String dataTypeUri = this.getType().getDataTypeUri();
        return dataTypeUri.equals("dmx.core.text") || dataTypeUri.equals("dmx.core.html") || dataTypeUri.equals("dmx.core.number") || dataTypeUri.equals("dmx.core.boolean");
    }

    final boolean isHtml() {
        return this.getType().getDataTypeUri().equals("dmx.core.html");
    }

    private void _updateUri(String newUri) {
        if (this.uriChange(newUri, this.uri)) {
            this.logger.fine("### Changing URI of " + this.objectInfo() + ": \"" + this.uri + "\" -> \"" + newUri + "\"");
            this.updateUri(newUri);
        }
    }

    private void _updateTypeUri(String newTypeUri) {
        if (newTypeUri != null && !newTypeUri.equals(this.typeUri)) {
            this.logger.fine("### Changing type URI of " + this.objectInfo() + ": \"" + this.typeUri + "\" -> \"" + newTypeUri + "\"");
            this.updateTypeUri(newTypeUri);
        }
    }

    final void _updateSimpleValue(SimpleValue newValue) {
        if (newValue != null && !newValue.equals(this.value)) {
            this.logger.fine("### Changing simple value of " + this.objectInfo() + ": \"" + this.value + "\" -> \"" + newValue + "\"");
            this.updateSimpleValue(newValue);
        }
    }

    private CompDefModel getCompDef(String compDefUri) {
        return this.getType().getCompDef(compDefUri);
    }

    String objectInfo() {
        return this.className() + LABEL_CHILD_SEPARATOR + this.id;
    }
}

