/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.webclient.migrations;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.DMXObject;
import systems.dmx.core.DMXType;
import systems.dmx.core.Topic;
import systems.dmx.core.ViewConfig;
import systems.dmx.core.service.Migration;

public class Migration3
extends Migration {
    private long dmxWorkspaceId;
    private int[][] count = new int[2][2];
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void run() {
        this.initDMXWorkspaceId();
        this.logger.info("##### Repairing types with missing \"View Config\" topic (" + (this.dmxWorkspaceId == -1L ? "clean install" : "update") + " detected)");
        this.repair(this.dmx.getAllTopicTypes(), 0);
        this.repair(this.dmx.getAllAssocTypes(), 1);
        this.logger.info("##### Repairing types with missing \"View Config\" topic complete\n    Topic types repaired: " + this.count[0][1] + "/" + this.count[0][0] + "\n    Assoc types repaired: " + this.count[1][1] + "/" + this.count[1][0]);
    }

    private void repair(List<? extends DMXType> types, int i) {
        for (DMXType dMXType : types) {
            if (dMXType.getUri().equals("dmx.webclient.view_config")) continue;
            this.repair(dMXType, i);
        }
    }

    private void repair(DMXType type, int i) {
        try {
            ViewConfig viewConfig = type.getViewConfig();
            Topic configTopic = viewConfig.getConfigTopic("dmx.webclient.view_config");
            if (configTopic == null) {
                configTopic = viewConfig.addConfigTopic(this.mf.newTopicModel("dmx.webclient.view_config"));
                if (this.dmxWorkspaceId != -1L && this.isDMXStandardType(type)) {
                    this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)configTopic, this.dmxWorkspaceId);
                }
                int[] nArray = this.count[i];
                nArray[1] = nArray[1] + 1;
            }
            int[] nArray = this.count[i];
            nArray[0] = nArray[0] + 1;
        }
        catch (Exception e) {
            throw new RuntimeException("Repairing type \"" + type.getUri() + "\" failed", e);
        }
    }

    private void initDMXWorkspaceId() {
        Topic ws = this.dmx.getTopicByUri("dmx.workspaces.dmx");
        this.dmxWorkspaceId = ws != null ? ws.getId() : -1L;
    }

    private boolean isDMXStandardType(DMXType type) {
        return type.getUri().startsWith("dmx.");
    }
}

