/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.plugins.biblio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.core.Assoc;
import systems.dmx.core.CompDef;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.files.FilesService;
import systems.dmx.files.StoredFile;
import systems.dmx.files.UploadedFile;
import systems.dmx.plugins.biblio.ImportStatus;

@Path(value="literature")
@Produces(value={"application/json"})
public class LiteraturePlugin
extends PluginActivator {
    private static Logger log = Logger.getLogger(LiteraturePlugin.class.getName());
    @Inject
    private FilesService files;

    @POST
    @Path(value="/upload/ris")
    @Consumes(value={"multipart/form-data"})
    @Transactional
    public Topic uploadRIS(UploadedFile file) {
        String operation = "Uploading RIS " + file;
        try {
            log.info(operation);
            StoredFile storedFile = this.files.storeFile(file, "/");
            log.info("RIS File stored SUCCESFULLY");
            return this.dmx.getTopic(storedFile.getFileTopicId());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " FAILED", e);
        }
    }

    @POST
    @Path(value="/import/{fileId}")
    public ImportStatus importRIS(@PathParam(value="fileId") long fileId) {
        try {
            log.info("Requested RIS Import for file topic (" + fileId + ")");
            List<String> lines = this.readTextFile(fileId);
            if (lines.size() < 2) {
                return new ImportStatus(false, "please upload a valid RIS, see README", null);
            }
            int created = 0;
            int deleted = 0;
            int updated = 0;
            Iterator<String> rows = lines.iterator();
            Publication pub = new Publication();
            ArrayList<String> generalAuthors = new ArrayList<String>();
            ArrayList<String> keywords = new ArrayList<String>();
            while (rows.hasNext()) {
                String row = rows.next();
                String[] keyValue = row.split("-");
                String key = "";
                String value = "";
                if (keyValue.length >= 2) {
                    key = keyValue[0].trim();
                    value = keyValue[1].trim();
                    if (key.equals("N1") || keyValue.length > 2) {
                        // empty if block
                    }
                    this.buildPublication(pub, key, value);
                    switch (key) {
                        case "KW": {
                            keywords.add(value);
                            break;
                        }
                        case "AU": {
                            generalAuthors.add(value);
                        }
                    }
                    continue;
                }
                if (keyValue.length != 1 || keyValue[0].trim().isEmpty() || !(key = keyValue[0].trim()).equals("ER")) continue;
                if (pub.title != null && pub.refType.equals("JOUR")) {
                    DMXTransaction tx = this.dmx.beginTx();
                    try {
                        Topic topic = this.createJournalArticle(pub);
                        this.createKeywords(topic, keywords);
                        this.associateWithFileImported(topic.getId(), fileId);
                        ++created;
                        tx.success();
                    }
                    catch (Exception ex) {
                        log.severe("Exception thrown during import:" + ex.getLocalizedMessage());
                        tx.failure();
                    }
                    tx.finish();
                }
                generalAuthors.clear();
                keywords.clear();
                pub = new Publication();
            }
            ArrayList<String> status = new ArrayList<String>();
            status.add("created: " + created);
            status.add("updated: " + updated);
            status.add("deleted: " + deleted);
            log.info("RIS file import complete");
            return new ImportStatus(true, "SUCCESS", status);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void associateWithFileImported(long objectId, long fileId) {
        Assoc exists = this.dmx.getAssocBetweenTopicAndTopic("dmx.core.association", objectId, fileId, "dmx.core.child", "dmx.core.parent");
        if (exists == null) {
            this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(objectId, "dmx.core.child"), (PlayerModel)this.mf.newTopicPlayerModel(fileId, "dmx.core.parent")));
        }
    }

    private boolean isMany(TopicType topicType, String childTypeUri) {
        CompDef model = topicType.getCompDef(childTypeUri);
        return model.getChildCardinalityUri().equals("dmx.core.many");
    }

    private List<String> readTextFile(long fileId) throws IOException {
        File file = this.files.getFile(fileId);
        log.info("Read text file \"" + file.getAbsolutePath() + "\"");
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = br.readLine()) != null) {
            lines.add(line.trim());
        }
        fr.close();
        return lines;
    }

    private Topic createJournalArticle(Publication pub) {
        log.info("Create Journal Article: " + pub.title + ", " + pub.refType + ", " + pub.workType + " (" + pub.pubYear + ") DOI: " + pub.doi);
        ChildTopicsModel cm = this.mf.newChildTopicsModel().set("dmx.biblio.title_article", (Object)pub.title);
        if (pub.pubYear != null) {
            cm.set("dmx.datetime.year", (Object)pub.pubYear);
        }
        if (pub.doi != null) {
            cm.set("dmx.biblio.doi", (Object)pub.doi);
        }
        if (pub.issn != null) {
            cm.set("dmx.biblio.issn", (Object)pub.issn);
        }
        if (pub.journalTitle != null) {
            cm.set("dmx.biblio.title_journal", (Object)pub.journalTitle);
        }
        return this.dmx.createTopic(this.mf.newTopicModel("dmx.biblio.journal_article", cm));
    }

    private void createKeywords(Topic publication, List<String> keywords) {
        if (keywords.isEmpty()) {
            return;
        }
        Iterator<String> iterator = keywords.iterator();
        ChildTopicsModel cm = this.mf.newChildTopicsModel();
        while (iterator.hasNext()) {
            String keywordValue = iterator.next().toString().trim();
            if (keywordValue.contains(",")) {
                String[] keywordValues = keywordValue.split(",");
                for (int k = 0; k < keywordValues.length; ++k) {
                    cm.add("dmx.tags.tag", this.mf.newChildTopicsModel().set("dmx.tags.tag_name", (Object)keywordValues[k].trim()));
                }
                continue;
            }
            cm.add("dmx.tags.tag", this.mf.newChildTopicsModel().set("dmx.tags.tag_name", (Object)keywordValue));
        }
        log.info("=> Adding Keywords: " + cm.toString());
        this.dmx.updateTopic(this.mf.newTopicModel(publication.getId(), cm));
    }

    private void createAuthorships(Topic publication, List<String> generalAuthors) {
        log.info("=> Authors: " + generalAuthors.size());
    }

    private void buildPublication(Publication pub, String key, String value) {
        switch (key) {
            case "TY": {
                pub.refType = value;
                break;
            }
            case "M3": {
                pub.workType = value;
                break;
            }
            case "TI": {
                pub.title = value;
                break;
            }
            case "T1": {
                pub.title = value;
                break;
            }
            case "AB": {
                pub.pubAbstract = value;
                break;
            }
            case "DO": {
                pub.doi = value;
                break;
            }
            case "PY": {
                pub.pubYear = value;
                break;
            }
            case "SN": {
                pub.issn = value;
                break;
            }
            case "SP": {
                pub.startPage = value;
                break;
            }
            case "EP": {
                pub.endPage = value;
                break;
            }
            case "UR": {
                pub.url = value;
                break;
            }
            case "LA": {
                pub.pubLanguage = value;
                break;
            }
            case "JO": {
                pub.journalTitle = value;
                break;
            }
            case "JF": {
                pub.journalTitle = value;
                break;
            }
            case "T2": {
                pub.journalTitle = value;
            }
        }
    }

    class Publication {
        public String title;
        public String refType;
        public String workType;
        public String pubAbstract;
        public String doi;
        public String issn;
        public String pubYear;
        public String startPage;
        public String endPage;
        public String pubLanguage;
        public String url;
        public String journalTitle;

        Publication() {
        }
    }
}

