/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.plugins.biblio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.core.Assoc;
import systems.dmx.core.CompDef;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.files.FilesService;
import systems.dmx.files.StoredFile;
import systems.dmx.files.UploadedFile;
import systems.dmx.plugins.biblio.ImportStatus;

@Path(value="literature")
@Produces(value={"application/json"})
public class LiteraturePlugin
extends PluginActivator {
    private static Logger log = Logger.getLogger(LiteraturePlugin.class.getName());
    @Inject
    private FilesService files;

    @POST
    @Path(value="/upload/ris")
    @Consumes(value={"multipart/form-data"})
    @Transactional
    public Topic uploadRIS(UploadedFile file) {
        String operation = "Uploading RIS " + file;
        try {
            log.info(operation);
            StoredFile storedFile = this.files.storeFile(file, "/");
            log.info("RIS File stored SUCCESFULLY");
            return this.dmx.getTopic(storedFile.getFileTopicId());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " FAILED", e);
        }
    }

    @POST
    @Path(value="/import/{fileId}")
    public ImportStatus importRIS(@PathParam(value="fileId") long fileId) {
        try {
            log.info("Requested RIS Import for file topic (" + fileId + ")");
            List<String> lines = this.readTextFile(fileId);
            if (lines.size() < 2) {
                return new ImportStatus(false, "please upload a valid RIS, see README", null);
            }
            int documentCount = 0;
            int keywordCount = 0;
            int authorCount = 0;
            int organizationCount = 0;
            Iterator<String> rows = lines.iterator();
            Publication pub = new Publication();
            Book book = new Book();
            ArrayList<String> generalAuthors = new ArrayList<String>();
            ArrayList<String> editors = new ArrayList<String>();
            ArrayList<String> keywords = new ArrayList<String>();
            String refType = "";
            while (rows.hasNext()) {
                String row = rows.next();
                String[] keyValue = row.split("-", 2);
                String key = keyValue[0].trim();
                String value = "";
                if (key.equals("ER")) {
                    boolean created = this.createEntry(refType, book, pub, keywords, generalAuthors, editors, fileId);
                    if (created) {
                        ++documentCount;
                    }
                    generalAuthors.clear();
                    editors.clear();
                    keywords.clear();
                    pub = new Publication();
                    book = new Book();
                    refType = "";
                    continue;
                }
                if (keyValue.length <= 1) continue;
                value = keyValue[1].trim();
                this.buildJournalArticle(pub, key, value);
                this.buildBook(book, key, value);
                switch (key) {
                    case "TY": {
                        refType = value;
                        break;
                    }
                    case "KW": {
                        ++keywordCount;
                        keywords.add(value);
                        break;
                    }
                    case "AU": {
                        ++authorCount;
                        generalAuthors.add(value);
                        break;
                    }
                    case "A1": {
                        ++authorCount;
                        generalAuthors.add(value);
                        break;
                    }
                    case "A2": {
                        ++authorCount;
                        generalAuthors.add(value);
                        break;
                    }
                    case "A3": {
                        ++authorCount;
                        generalAuthors.add(value);
                        break;
                    }
                    case "ED": {
                        editors.add(value);
                    }
                }
            }
            ArrayList<String> status = new ArrayList<String>();
            status.add("documents: " + documentCount);
            status.add("keywords: " + keywordCount);
            status.add("authors: " + authorCount);
            status.add("organizations: " + organizationCount);
            ImportStatus report = new ImportStatus(true, "SUCCESS", status);
            log.info("RIS file import complete, reporting " + report.toJSON().toString());
            return report;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createEntry(String refType, Book book, Publication pub, List<String> keywords, List<String> generalAuthors, List<String> editors, long fileId) {
        boolean created = false;
        DMXTransaction tx = this.dmx.beginTx();
        try {
            Topic document = null;
            if (refType.equals("JOUR") && pub.title != null && !pub.title.isEmpty()) {
                document = this.createJournalArticle(pub);
            } else if (refType.equals("BOOK") && book.title != null && !book.title.isEmpty()) {
                document = this.createBook(book);
            }
            if (document != null) {
                created = true;
                this.addKeywords(document, keywords);
                this.createAuthorships(document, generalAuthors);
                this.createEditors(document, editors);
                this.associateWithFileImported(document.getId(), fileId);
            }
            tx.success();
        }
        catch (Exception ex) {
            tx.failure();
            log.severe("Error creating bibliographic entry: " + ex.getCause().getLocalizedMessage());
        }
        finally {
            tx.finish();
        }
        return created;
    }

    private void associateWithFileImported(long objectId, long fileId) {
        Assoc exists = this.dmx.getAssocBetweenTopicAndTopic("dmx.core.association", objectId, fileId, "dmx.core.child", "dmx.core.parent");
        if (exists == null) {
            this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(objectId, "dmx.core.child"), (PlayerModel)this.mf.newTopicPlayerModel(fileId, "dmx.core.parent")));
        }
    }

    private boolean isMany(TopicType topicType, String childTypeUri) {
        CompDef model = topicType.getCompDef(childTypeUri);
        return model.getChildCardinalityUri().equals("dmx.core.many");
    }

    private List<String> readTextFile(long fileId) throws IOException {
        File file = this.files.getFile(fileId);
        log.info("Read text file \"" + file.getAbsolutePath() + "\"");
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = br.readLine()) != null) {
            lines.add(line.trim());
        }
        fr.close();
        return lines;
    }

    private Topic createJournalArticle(Publication pub) {
        log.info("=> Journal Article \"" + pub.title + "\", " + pub.refType + ", " + pub.workType + " (" + pub.pubYear + ") DOI: " + pub.doi);
        ChildTopicsModel cm = this.mf.newChildTopicsModel().set("dmx.biblio.title_article", (Object)pub.title);
        if (pub.pubAbstract != null) {
            cm.set("dmx.biblio.abstract", (Object)pub.pubAbstract);
        }
        if (!pub.notes.isEmpty()) {
            cm.set("dmx.biblio.notes", (Object)pub.notes);
        }
        if (pub.pubYear != null) {
            cm.set("dmx.datetime.year", (Object)pub.pubYear);
        }
        if (pub.doi != null) {
            cm.set("dmx.biblio.doi", (Object)pub.doi);
        }
        if (pub.issn != null) {
            cm.set("dmx.biblio.issn", (Object)pub.issn);
        }
        if (pub.url != null) {
            cm.set("dmx.biblio.webaddress", this.mf.newTopicModel("dmx.biblio.webaddress", this.mf.newChildTopicsModel().set("dmx.base.url", (Object)pub.url)));
        }
        return this.dmx.createTopic(this.mf.newTopicModel("dmx.biblio.journal_article", cm));
    }

    private Topic createBook(Book pub) {
        log.info("=> Book \"" + pub.title + " " + pub.subtitle + "\", " + pub.year + ", (" + pub.publisher + ", " + pub.place + ")");
        ChildTopicsModel cm = this.mf.newChildTopicsModel().set("dmx.biblio.title_book", (Object)pub.title);
        if (pub.publisher != null) {
            cm.set("dmx.biblio.publisher", (Object)pub.publisher);
        }
        if (pub.place != null) {
            cm.set("dmx.biblio.place", (Object)pub.place);
        }
        if (pub.year != null) {
            cm.set("dmx.datetime.year", (Object)pub.year);
        }
        if (pub.issn != null) {
            cm.set("dmx.biblio.issn", (Object)pub.issn);
        }
        if (pub.subtitle != null) {
            cm.set("dmx.biblio.subtitle", (Object)pub.subtitle);
        }
        return this.dmx.createTopic(this.mf.newTopicModel("dmx.biblio.monograph", cm));
    }

    private void addKeywords(Topic publication, List<String> keywords) {
        if (keywords.isEmpty()) {
            return;
        }
        Iterator<String> iterator = keywords.iterator();
        ChildTopicsModel cm = this.mf.newChildTopicsModel();
        while (iterator.hasNext()) {
            String keywordValue = iterator.next().toString().toLowerCase().trim();
            if (keywordValue.contains(",")) {
                String[] keywordValues = keywordValue.split(",");
                for (int k = 0; k < keywordValues.length; ++k) {
                    cm.add("dmx.tags.tag", this.mf.newChildTopicsModel().set("dmx.tags.tag_name", (Object)keywordValues[k].trim()));
                }
                continue;
            }
            cm.add("dmx.tags.tag", this.mf.newChildTopicsModel().set("dmx.tags.tag_name", (Object)keywordValue));
        }
        this.dmx.updateTopic(this.mf.newTopicModel(publication.getId(), cm));
    }

    private void createAuthorships(Topic publication, List<String> generalAuthors) {
        Iterator<String> iterator = generalAuthors.iterator();
        ChildTopicsModel cm = this.mf.newChildTopicsModel();
        String compDefURI = "dmx.contacts.person#dmx.biblio.author";
        while (iterator.hasNext()) {
            String lastName;
            String firstName;
            String[] nameParts;
            String authorName = iterator.next().toString().trim();
            if (authorName.contains(",")) {
                nameParts = authorName.split(",");
                firstName = nameParts[1];
                lastName = nameParts[0];
                cm.add(compDefURI, this.mf.newChildTopicsModel().set("dmx.contacts.person_name", this.mf.newChildTopicsModel().set("dmx.contacts.first_name", (Object)firstName).set("dmx.contacts.last_name", (Object)lastName)));
                continue;
            }
            if (authorName.contains(" ")) {
                nameParts = authorName.split(" ");
                firstName = nameParts[0];
                lastName = nameParts[1];
                cm.add(compDefURI, this.mf.newChildTopicsModel().set("dmx.contacts.person_name", this.mf.newChildTopicsModel().set("dmx.contacts.first_name", (Object)firstName).set("dmx.contacts.last_name", (Object)lastName)));
                continue;
            }
            cm.add(compDefURI, this.mf.newChildTopicsModel().set("dmx.contacts.person_name", this.mf.newChildTopicsModel().set("dmx.contacts.last_name", (Object)authorName)));
        }
        this.dmx.updateTopic(this.mf.newTopicModel(publication.getId(), cm));
    }

    private void createEditors(Topic publication, List<String> editors) {
        Iterator<String> iterator = editors.iterator();
        ChildTopicsModel cm = this.mf.newChildTopicsModel();
        String compDefURI = "dmx.contacts.person#dmx.biblio.editor";
        while (iterator.hasNext()) {
            String lastName;
            String firstName;
            String[] nameParts;
            String authorName = iterator.next().toString().trim();
            if (authorName.contains(",")) {
                nameParts = authorName.split(",");
                firstName = nameParts[1];
                lastName = nameParts[0];
                cm.add(compDefURI, this.mf.newChildTopicsModel().set("dmx.contacts.person_name", this.mf.newChildTopicsModel().set("dmx.contacts.first_name", (Object)firstName).set("dmx.contacts.last_name", (Object)lastName)));
                continue;
            }
            if (authorName.contains(" ")) {
                nameParts = authorName.split(" ");
                firstName = nameParts[0];
                lastName = nameParts[1];
                cm.add(compDefURI, this.mf.newChildTopicsModel().set("dmx.contacts.person_name", this.mf.newChildTopicsModel().set("dmx.contacts.first_name", (Object)firstName).set("dmx.contacts.last_name", (Object)lastName)));
                continue;
            }
            cm.add(compDefURI, this.mf.newChildTopicsModel().set("dmx.contacts.person_name", this.mf.newChildTopicsModel().set("dmx.contacts.last_name", (Object)authorName)));
        }
        this.dmx.updateTopic(this.mf.newTopicModel(publication.getId(), cm));
    }

    private void buildJournalArticle(Publication pub, String key, String value) {
        switch (key) {
            case "M3": {
                pub.workType = value;
                break;
            }
            case "TI": {
                pub.title = value;
                break;
            }
            case "T1": {
                pub.title = value;
                break;
            }
            case "T4": {
                pub.title = pub.title != null ? pub.title + " - " + value : value;
                break;
            }
            case "AB": {
                pub.pubAbstract = value;
                break;
            }
            case "N2": {
                pub.pubAbstract = value;
                break;
            }
            case "DO": {
                pub.doi = value;
                break;
            }
            case "PY": {
                pub.pubYear = value;
                break;
            }
            case "SN": {
                pub.issn = value;
                break;
            }
            case "SP": {
                pub.startPage = value;
                break;
            }
            case "EP": {
                pub.endPage = value;
                break;
            }
            case "UR": {
                pub.url = value;
                break;
            }
            case "L1": {
                pub.url = value;
                break;
            }
            case "L2": {
                pub.url = value;
                break;
            }
            case "LK": {
                pub.url = value;
                break;
            }
            case "LA": {
                pub.pubLanguage = value;
                break;
            }
            case "JO": {
                pub.journalTitle = value;
                break;
            }
            case "JF": {
                pub.journalTitle = value;
                break;
            }
            case "T2": {
                pub.journalTitle = value;
                break;
            }
            case "N1": {
                pub.notes = pub.notes + "<p>" + value + "</p>";
            }
        }
    }

    private void buildBook(Book pub, String key, String value) {
        switch (key) {
            case "TI": {
                pub.title = value;
                break;
            }
            case "T1": {
                pub.title = value;
                break;
            }
            case "T4": {
                pub.title = pub.title != null ? pub.title + " - " + value : value;
                break;
            }
            case "T2": {
                pub.subtitle = value;
                break;
            }
            case "PY": {
                pub.year = value;
                break;
            }
            case "PB": {
                pub.publisher = value;
                break;
            }
            case "PP": {
                pub.place = value;
                break;
            }
            case "CY": {
                pub.place = value;
                break;
            }
            case "SN": {
                pub.issn = value;
            }
        }
    }

    class Book {
        public String refType;
        public String title;
        public String subtitle;
        public String issn;
        public String year;
        public String place;
        public String publisher;

        Book() {
        }
    }

    class Publication {
        public String refType;
        public String title;
        public String pubAbstract;
        public String doi;
        public String issn;
        public String url;
        public String journalTitle;
        public String notes = "";
        public String workType;
        public String pubYear;
        public String startPage;
        public String endPage;
        public String pubLanguage;

        Publication() {
        }
    }
}

