/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.plugins.biblio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.core.Assoc;
import systems.dmx.core.CompDef;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.files.FilesService;
import systems.dmx.files.StoredFile;
import systems.dmx.files.UploadedFile;
import systems.dmx.plugins.biblio.ImportStatus;

@Path(value="literature")
@Produces(value={"application/json"})
public class LiteraturePlugin
extends PluginActivator {
    private static Logger log = Logger.getLogger(LiteraturePlugin.class.getName());
    private static final String HTTP = "http";
    @Inject
    private FilesService files;

    @POST
    @Path(value="/upload/ris")
    @Consumes(value={"multipart/form-data"})
    @Transactional
    public Topic uploadRIS(UploadedFile file) {
        String operation = "Uploading RIS " + file;
        try {
            log.info(operation);
            StoredFile storedFile = this.files.storeFile(file, "/");
            log.info("RIS File stored SUCCESFULLY");
            return this.dmx.getTopic(storedFile.getFileTopicId());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " FAILED", e);
        }
    }

    @POST
    @Path(value="/import/{fileId}")
    public ImportStatus importRIS(@PathParam(value="fileId") long fileId) {
        try {
            log.info("Requested RIS Import for file topic (" + fileId + ")");
            List<String> lines = this.readTextFile(fileId);
            if (lines.size() < 2) {
                return new ImportStatus(false, "please upload a valid RIS, see README", null);
            }
            int documentCount = 0;
            int keywordCount = 0;
            int authorCount = 0;
            int organizationCount = 0;
            Iterator<String> rows = lines.iterator();
            JournalArticle pub = new JournalArticle();
            Book book = new Book();
            CPaper cpaper = new CPaper();
            BookChapter chapter = new BookChapter();
            ArrayList<String> generalAuthors = new ArrayList<String>();
            ArrayList<String> editors = new ArrayList<String>();
            ArrayList<String> keywords = new ArrayList<String>();
            String refType = "";
            while (rows.hasNext()) {
                String row = rows.next();
                String[] keyValue = row.split("-", 2);
                String key = keyValue[0].trim();
                String value = "";
                if (key.equals("ER")) {
                    boolean created = this.createEntry(refType, book, pub, cpaper, chapter, keywords, generalAuthors, editors, fileId);
                    if (created) {
                        ++documentCount;
                    }
                    generalAuthors.clear();
                    editors.clear();
                    keywords.clear();
                    pub = new JournalArticle();
                    book = new Book();
                    refType = "";
                    continue;
                }
                if (keyValue.length <= 1) continue;
                value = keyValue[1].trim();
                this.buildJournalArticle(pub, key, value);
                this.buildBook(book, key, value);
                this.buildConferencePaper(cpaper, key, value);
                this.buildBookChapter(chapter, key, value);
                switch (key) {
                    case "TY": {
                        refType = value;
                        break;
                    }
                    case "KW": {
                        ++keywordCount;
                        keywords.add(value);
                        break;
                    }
                    case "AU": {
                        ++authorCount;
                        generalAuthors.add(value);
                        break;
                    }
                    case "A1": {
                        ++authorCount;
                        generalAuthors.add(value);
                        break;
                    }
                    case "A2": {
                        ++authorCount;
                        generalAuthors.add(value);
                        break;
                    }
                    case "A3": {
                        ++authorCount;
                        generalAuthors.add(value);
                        break;
                    }
                    case "ED": {
                        editors.add(value);
                    }
                }
            }
            ArrayList<String> status = new ArrayList<String>();
            status.add("documents: " + documentCount);
            status.add("keywords: " + keywordCount);
            status.add("authors: " + authorCount);
            status.add("organizations: " + organizationCount);
            ImportStatus report = new ImportStatus(true, "SUCCESS", status);
            log.info("RIS file import complete, reporting " + report.toJSON().toString());
            return report;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createEntry(String refType, Book book, JournalArticle pub, CPaper cpaper, BookChapter chapter, List<String> keywords, List<String> generalAuthors, List<String> editors, long fileId) {
        boolean created = false;
        DMXTransaction tx = this.dmx.beginTx();
        Topic document = null;
        try {
            if (refType.equals("JOUR") && pub.title != null && !pub.title.isEmpty()) {
                document = this.createJournalArticle(pub);
            } else if (refType.equals("BOOK") && book.title != null && !book.title.isEmpty()) {
                document = this.createBook(book);
            } else if (refType.equals("CPAPER") && pub.title != null && !pub.title.isEmpty()) {
                document = this.createConferencePaper(cpaper);
            } else if (refType.equals("CHAP") && pub.title != null && !pub.title.isEmpty()) {
                document = this.createBookChapter(chapter);
            } else {
                log.warning("Unsupported .RIS reference type \"" + refType + "\"! Skipping import of reference entry.");
            }
            if (document != null) {
                created = true;
                this.addKeywords(document, keywords);
                this.addAuthors(document, generalAuthors);
                this.addEditors(document, editors);
                this.associateWithFileImported(document.getId(), fileId);
                if (pub.notes != null) {
                    this.createRelatedNote(document, pub.notes);
                }
                if (pub.url != null && !pub.url.toLowerCase().startsWith(HTTP)) {
                    try {
                        this.createRelatedFileTopic(document, pub.url);
                    }
                    catch (Exception fex) {
                        log.severe("File topic could not be created! Caused by \"" + fex.getCause().getLocalizedMessage() + "\"");
                    }
                }
            }
            tx.success();
        }
        catch (Exception ex) {
            tx.failure();
            log.log(Level.SEVERE, "Could not import/update complete reference entry!", ex.getCause());
        }
        finally {
            tx.finish();
        }
        return created;
    }

    private void associateWithFileImported(long objectId, long fileId) {
        Assoc exists = this.dmx.getAssocBetweenTopicAndTopic("dmx.core.association", objectId, fileId, "dmx.core.child", "dmx.core.parent");
        if (exists == null) {
            this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(objectId, "dmx.core.child"), (PlayerModel)this.mf.newTopicPlayerModel(fileId, "dmx.core.parent")));
        }
    }

    private boolean isMany(TopicType topicType, String childTypeUri) {
        CompDef model = topicType.getCompDef(childTypeUri);
        return model.getChildCardinalityUri().equals("dmx.core.many");
    }

    private List<String> readTextFile(long fileId) throws IOException {
        File file = this.files.getFile(fileId);
        log.info("Read text file \"" + file.getAbsolutePath() + "\"");
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = br.readLine()) != null) {
            lines.add(line.trim());
        }
        fr.close();
        return lines;
    }

    private Topic createJournalArticle(JournalArticle pub) {
        log.info("=> Journal Article \"" + pub.title + "\", " + pub.refType + ", " + pub.workType + " (" + pub.pubYear + ") DOI: " + pub.doi);
        ChildTopicsModel cm = this.mf.newChildTopicsModel().set("dmx.biblio.title_article", (Object)pub.title);
        if (pub.pubAbstract != null) {
            cm.set("dmx.biblio.abstract", (Object)pub.pubAbstract);
        }
        if (pub.pubYear != null) {
            cm.set("dmx.datetime.year", (Object)pub.pubYear);
        }
        if (pub.doi != null) {
            cm.set("dmx.biblio.doi", (Object)pub.doi);
        }
        if (pub.db != null) {
            cm.set("dmx.biblio.database_provider", (Object)pub.db);
        }
        if (pub.issn != null) {
            cm.set("dmx.biblio.issn", (Object)pub.issn);
        }
        if (pub.url != null && pub.url.toLowerCase().startsWith(HTTP)) {
            cm.set("dmx.biblio.webaddress", this.mf.newTopicModel("dmx.biblio.webaddress", this.mf.newChildTopicsModel().set("dmx.base.url", (Object)pub.url)));
        }
        return this.dmx.createTopic(this.mf.newTopicModel("dmx.biblio.journal_article", cm));
    }

    private Topic createConferencePaper(CPaper pub) {
        log.info("=> Conference Paper/Proceeding \"" + pub.title + " " + pub.confName + ", (" + pub.confLocation + ", " + pub.confYear + ")");
        ChildTopicsModel cm = this.mf.newChildTopicsModel().set("dmx.biblio.title_conference_paper", (Object)pub.title);
        if (pub.abstractText != null) {
            cm.set("dmx.biblio.abstract", (Object)pub.abstractText);
        }
        if (pub.confYear != null) {
            cm.set("dmx.datetime.year", (Object)pub.confYear);
        }
        if (pub.confLocation != null) {
            cm.set("dmx.biblio.conference_location", (Object)pub.confLocation);
        }
        if (pub.confName != null) {
            cm.set("dmx.biblio.conference_name", (Object)pub.confName);
        }
        if (pub.publisher != null) {
            cm.set("dmx.biblio.publisher", (Object)pub.publisher);
        }
        if (pub.db != null) {
            cm.set("dmx.biblio.database_provider", (Object)pub.db);
        }
        if (pub.doi != null) {
            cm.set("dmx.biblio.doi", (Object)pub.doi);
        }
        if (pub.url != null && pub.url.toLowerCase().startsWith(HTTP)) {
            cm.add("dmx.biblio.webaddress", this.mf.newTopicModel("dmx.biblio.webaddress", this.mf.newChildTopicsModel().set("dmx.base.url", (Object)pub.url)));
        }
        return this.dmx.createTopic(this.mf.newTopicModel("dmx.biblio.conference_paper", cm));
    }

    private Topic createBook(Book pub) {
        log.info("=> Book \"" + pub.title + " " + pub.subtitle + "\", " + pub.year + ", (" + pub.publisher + ", " + pub.place + ")");
        ChildTopicsModel cm = this.mf.newChildTopicsModel().set("dmx.biblio.title_book", (Object)pub.title);
        if (pub.publisher != null) {
            cm.set("dmx.biblio.publisher", (Object)pub.publisher);
        }
        if (pub.place != null) {
            cm.set("dmx.biblio.place", (Object)pub.place);
        }
        if (pub.year != null) {
            cm.set("dmx.datetime.year", (Object)pub.year);
        }
        if (pub.db != null) {
            cm.set("dmx.biblio.database_provider", (Object)pub.db);
        }
        if (pub.issn != null) {
            cm.set("dmx.biblio.issn", (Object)pub.issn);
        }
        if (pub.subtitle != null) {
            cm.set("dmx.biblio.subtitle", (Object)pub.subtitle);
        }
        if (pub.url != null && pub.url.toLowerCase().startsWith(HTTP)) {
            cm.set("dmx.biblio.webaddress", this.mf.newTopicModel("dmx.biblio.webaddress", this.mf.newChildTopicsModel().set("dmx.base.url", (Object)pub.url)));
        }
        return this.dmx.createTopic(this.mf.newTopicModel("dmx.biblio.monograph", cm));
    }

    private Topic createBookChapter(BookChapter pub) {
        log.info("=> Book Chapter \"" + pub.title + " " + pub.bookTitle + "\", " + pub.year + ", (" + pub.publisher + ", " + pub.place + ")");
        ChildTopicsModel cm = this.mf.newChildTopicsModel().set("dmx.biblio.title_chapter", (Object)pub.title);
        if (pub.db != null) {
            cm.set("dmx.biblio.database_provider", (Object)pub.db);
        }
        if (pub.bookTitle != null) {
            cm.set("dmx.biblio.title_book", (Object)pub.bookTitle);
        }
        if (pub.doi != null) {
            cm.set("dmx.biblio.doi", (Object)pub.doi);
        }
        if (pub.publisher != null) {
            cm.set("dmx.biblio.publisher", (Object)pub.publisher);
        }
        if (pub.place != null) {
            cm.set("dmx.biblio.place", (Object)pub.place);
        }
        if (pub.year != null) {
            cm.set("dmx.datetime.year", (Object)pub.year);
        }
        if (pub.url != null && pub.url.toLowerCase().startsWith(HTTP)) {
            cm.add("dmx.biblio.webaddress", this.mf.newTopicModel("dmx.biblio.webaddress", this.mf.newChildTopicsModel().set("dmx.base.url", (Object)pub.url)));
        }
        return this.dmx.createTopic(this.mf.newTopicModel("dmx.biblio.book_chapter", cm));
    }

    private void createRelatedNote(Topic publication, String noteContent) {
        if (noteContent.isEmpty()) {
            return;
        }
        ChildTopicsModel cm = this.mf.newChildTopicsModel().set("dmx.notes.title", (Object)("Note on \"" + publication.getSimpleValue() + "\""));
        cm.set("dmx.notes.text", (Object)noteContent);
        Topic note = this.dmx.createTopic(this.mf.newTopicModel("dmx.notes.note", cm));
        this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(publication.getId(), "dmx.core.parent"), (PlayerModel)this.mf.newTopicPlayerModel(note.getId(), "dmx.core.child")));
    }

    private void createRelatedFileTopic(Topic publication, String filePath) throws Exception {
        if (filePath.isEmpty()) {
            return;
        }
        log.info("Checking for RIS referenced file topic at path=\"" + filePath + "\" in the dmx filerepo... (pathPrefix=" + this.files.pathPrefix());
        String transformedPath = this.files.pathPrefix() + "/" + filePath;
        Topic file = this.files.getFileTopic(transformedPath);
        log.info("Created file topic with \"" + transformedPath + "\" associating with biblio entry");
        this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(publication.getId(), "dmx.core.parent"), (PlayerModel)this.mf.newTopicPlayerModel(file.getId(), "dmx.core.child")));
    }

    private void addKeywords(Topic publication, List<String> keywords) {
        if (keywords.isEmpty()) {
            return;
        }
        Iterator<String> iterator = keywords.iterator();
        ArrayList<String> uniqueKeywords = new ArrayList<String>();
        while (iterator.hasNext()) {
            String keywordValue = iterator.next().toString().toLowerCase().trim();
            if (keywordValue.contains(",")) {
                String[] keywordValues = keywordValue.split(",");
                for (int k = 0; k < keywordValues.length; ++k) {
                    String value = keywordValues[k].trim();
                    if (uniqueKeywords.contains(value)) continue;
                    uniqueKeywords.add(value);
                }
                continue;
            }
            if (uniqueKeywords.contains(keywordValue)) continue;
            uniqueKeywords.add(keywordValue);
        }
        Iterator uniqueTags = uniqueKeywords.iterator();
        ChildTopicsModel cm = this.mf.newChildTopicsModel();
        while (uniqueTags.hasNext()) {
            String keywordValue = uniqueTags.next().toString();
            cm.add("dmx.tags.tag", this.mf.newChildTopicsModel().set("dmx.tags.tag_name", (Object)keywordValue));
        }
        this.dmx.updateTopic(this.mf.newTopicModel(publication.getId(), cm));
    }

    private void addAuthors(Topic publication, List<String> generalAuthors) {
        Iterator<String> iterator = generalAuthors.iterator();
        ChildTopicsModel cm = this.mf.newChildTopicsModel();
        String compDefURI = "dmx.contacts.person#dmx.biblio.author";
        while (iterator.hasNext()) {
            String lastName;
            String firstName;
            String[] nameParts;
            String authorName = iterator.next().toString().trim();
            if (authorName.contains(",")) {
                nameParts = authorName.split(",");
                firstName = nameParts[1];
                lastName = nameParts[0];
                cm.add(compDefURI, this.mf.newChildTopicsModel().set("dmx.contacts.person_name", this.mf.newChildTopicsModel().set("dmx.contacts.first_name", (Object)firstName).set("dmx.contacts.last_name", (Object)lastName)));
                continue;
            }
            if (authorName.contains(" ")) {
                nameParts = authorName.split(" ");
                firstName = nameParts[0];
                lastName = nameParts[1];
                cm.add(compDefURI, this.mf.newChildTopicsModel().set("dmx.contacts.person_name", this.mf.newChildTopicsModel().set("dmx.contacts.first_name", (Object)firstName).set("dmx.contacts.last_name", (Object)lastName)));
                continue;
            }
            cm.add(compDefURI, this.mf.newChildTopicsModel().set("dmx.contacts.person_name", this.mf.newChildTopicsModel().set("dmx.contacts.last_name", (Object)authorName)));
        }
        this.dmx.updateTopic(this.mf.newTopicModel(publication.getId(), cm));
    }

    private void addEditors(Topic publication, List<String> editors) {
        Iterator<String> iterator = editors.iterator();
        ChildTopicsModel cm = this.mf.newChildTopicsModel();
        String compDefURI = "dmx.contacts.person#dmx.biblio.editor";
        while (iterator.hasNext()) {
            String lastName;
            String firstName;
            String[] nameParts;
            String authorName = iterator.next().toString().trim();
            if (authorName.contains(",")) {
                nameParts = authorName.split(",");
                firstName = nameParts[1];
                lastName = nameParts[0];
                cm.add(compDefURI, this.mf.newChildTopicsModel().set("dmx.contacts.person_name", this.mf.newChildTopicsModel().set("dmx.contacts.first_name", (Object)firstName).set("dmx.contacts.last_name", (Object)lastName)));
                continue;
            }
            if (authorName.contains(" ")) {
                nameParts = authorName.split(" ");
                firstName = nameParts[0];
                lastName = nameParts[1];
                cm.add(compDefURI, this.mf.newChildTopicsModel().set("dmx.contacts.person_name", this.mf.newChildTopicsModel().set("dmx.contacts.first_name", (Object)firstName).set("dmx.contacts.last_name", (Object)lastName)));
                continue;
            }
            cm.add(compDefURI, this.mf.newChildTopicsModel().set("dmx.contacts.person_name", this.mf.newChildTopicsModel().set("dmx.contacts.last_name", (Object)authorName)));
        }
        this.dmx.updateTopic(this.mf.newTopicModel(publication.getId(), cm));
    }

    private void buildJournalArticle(JournalArticle article, String key, String value) {
        switch (key) {
            case "M3": {
                article.workType = value;
                break;
            }
            case "TI": {
                article.title = value;
                break;
            }
            case "T1": {
                article.title = value;
                break;
            }
            case "T4": {
                article.title = article.title != null ? article.title + " - " + value : value;
                break;
            }
            case "AB": {
                article.pubAbstract = value;
                break;
            }
            case "N2": {
                article.pubAbstract = value;
                break;
            }
            case "DO": {
                article.doi = value;
                break;
            }
            case "PY": {
                article.pubYear = value;
                break;
            }
            case "SN": {
                article.issn = value;
                break;
            }
            case "SP": {
                article.startPage = value;
                break;
            }
            case "EP": {
                article.endPage = value;
                break;
            }
            case "UR": {
                article.url = value;
                break;
            }
            case "L1": {
                article.url = value;
                break;
            }
            case "L2": {
                article.url = value;
                break;
            }
            case "LK": {
                article.url = value;
                break;
            }
            case "LA": {
                article.pubLanguage = value;
                break;
            }
            case "JO": {
                article.journalTitle = value;
                break;
            }
            case "JF": {
                article.journalTitle = value;
                break;
            }
            case "T2": {
                article.journalTitle = value;
                break;
            }
            case "N1": {
                article.notes = article.notes + "<p>" + value + "</p>";
                break;
            }
            case "DB": {
                article.db = value;
                break;
            }
            case "DP": {
                article.db = value;
            }
        }
    }

    private void buildBook(Book book, String key, String value) {
        switch (key) {
            case "TI": {
                book.title = value;
                break;
            }
            case "T1": {
                book.title = value;
                break;
            }
            case "T4": {
                book.title = book.title != null ? book.title + " - " + value : value;
                break;
            }
            case "T2": {
                book.subtitle = value;
                break;
            }
            case "PY": {
                book.year = value;
                break;
            }
            case "PB": {
                book.publisher = value;
                break;
            }
            case "PP": {
                book.place = value;
                break;
            }
            case "CY": {
                book.place = value;
                break;
            }
            case "SN": {
                book.issn = value;
                break;
            }
            case "L1": {
                book.url = value;
                break;
            }
            case "L2": {
                book.url = value;
                break;
            }
            case "N1": {
                book.notes = book.notes + "<p>" + value + "</p>";
                break;
            }
            case "UR": {
                book.url = value;
                break;
            }
            case "LK": {
                book.url = value;
                break;
            }
            case "DB": {
                book.db = value;
                break;
            }
            case "DP": {
                book.db = value;
            }
        }
    }

    private void buildBookChapter(BookChapter chapter, String key, String value) {
        switch (key) {
            case "TI": {
                chapter.title = value;
                break;
            }
            case "T1": {
                chapter.title = value;
                break;
            }
            case "T4": {
                chapter.title = chapter.title != null ? chapter.title + " - " + value : value;
                break;
            }
            case "T2": {
                chapter.bookTitle = value;
                break;
            }
            case "PY": {
                chapter.year = value;
                break;
            }
            case "PB": {
                chapter.publisher = value;
                break;
            }
            case "PP": {
                chapter.place = value;
                break;
            }
            case "CY": {
                chapter.place = value;
                break;
            }
            case "L1": {
                chapter.url = value;
                break;
            }
            case "L2": {
                chapter.url = value;
                break;
            }
            case "LK": {
                chapter.url = value;
                break;
            }
            case "DB": {
                chapter.db = value;
                break;
            }
            case "DP": {
                chapter.db = value;
                break;
            }
            case "N1": {
                chapter.notes = chapter.notes + "<p>" + value + "</p>";
            }
        }
    }

    private void buildConferencePaper(CPaper cpaper, String key, String value) {
        switch (key) {
            case "TI": {
                cpaper.title = value;
                break;
            }
            case "T1": {
                cpaper.title = value;
                break;
            }
            case "T4": {
                cpaper.confName = value;
                break;
            }
            case "AB": {
                cpaper.abstractText = value;
                break;
            }
            case "N2": {
                cpaper.abstractText = value;
                break;
            }
            case "JF": {
                cpaper.confName = value;
                break;
            }
            case "T2": {
                cpaper.confName = value;
                break;
            }
            case "PY": {
                cpaper.confYear = value;
                break;
            }
            case "PB": {
                cpaper.publisher = value;
                break;
            }
            case "PP": {
                cpaper.confLocation = value;
                break;
            }
            case "CY": {
                cpaper.confLocation = value;
                break;
            }
            case "DO": {
                cpaper.doi = value;
                break;
            }
            case "L1": {
                cpaper.url = value;
                break;
            }
            case "L2": {
                cpaper.url = value;
                break;
            }
            case "UR": {
                cpaper.url = value;
                break;
            }
            case "LK": {
                cpaper.url = value;
                break;
            }
            case "DB": {
                cpaper.db = value;
                break;
            }
            case "DP": {
                cpaper.db = value;
                break;
            }
            case "N1": {
                cpaper.notes = cpaper.notes + "<p>" + value + "</p>";
            }
        }
    }

    class CPaper {
        public String refType;
        public String title;
        public String abstractText;
        public String confYear;
        public String confName;
        public String confLocation;
        public String publisher;
        public String doi;
        public String url;
        public String db;
        public String notes = "";

        CPaper() {
        }
    }

    class BookChapter {
        public String refType;
        public String title;
        public String bookTitle;
        public String startPage;
        public String endPage;
        public String year;
        public String place;
        public String publisher;
        public String url;
        public String doi;
        public String db;
        public String notes = "";

        BookChapter() {
        }
    }

    class Book {
        public String refType;
        public String title;
        public String subtitle;
        public String issn;
        public String year;
        public String place;
        public String publisher;
        public String url;
        public String db;
        public String notes = "";

        Book() {
        }
    }

    class JournalArticle {
        public String refType;
        public String title;
        public String pubAbstract;
        public String doi;
        public String issn;
        public String url;
        public String journalTitle;
        public String notes = "";
        public String workType;
        public String pubYear;
        public String startPage;
        public String endPage;
        public String pubLanguage;
        public String db;

        JournalArticle() {
        }
    }
}

