/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.deepl;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.deepl.DeepLService;
import systems.dmx.deepl.Translation;

@Path(value="/deepl")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DeepLPlugin
extends PluginActivator
implements DeepLService {
    private static final String DEEPL_URL = "https://api-free.deepl.com/v2/";
    private static final String DEEPL_AUTH_KEY = System.getProperty("dmx.deepl.auth_key");
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public List<Translation> translate(@QueryParam(value="text") String text, @QueryParam(value="target_lang") String targetLang) {
        try {
            this.logger.info("Translating text=\"" + text + "\", targetLang=\"" + targetLang + "\"");
            URLConnection con = new URL("https://api-free.deepl.com/v2/translate").openConnection();
            con.setRequestProperty("Authorization", "DeepL-Auth-Key " + DEEPL_AUTH_KEY);
            con.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(con.getOutputStream());
            out.write("text=" + text + "&target_lang=" + targetLang + "&tag_handling=xml");
            out.flush();
            String responseData = JavaUtils.readText((InputStream)con.getInputStream());
            this.logger.info("responseData=" + responseData);
            JSONArray translations = new JSONObject(responseData).getJSONArray("translations");
            ArrayList<Translation> result = new ArrayList<Translation>();
            for (int i = 0; i < translations.length(); ++i) {
                JSONObject translation = translations.getJSONObject(i);
                result.add(new Translation(translation.getString("text"), translation.getString("detected_source_language")));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Translation failed, text=\"" + text + "\", targetLang=\"" + targetLang + "\"", e);
        }
    }

    @Override
    @GET
    @Path(value="/usage")
    public InputStream usageStats() {
        try {
            URLConnection con = new URL("https://api-free.deepl.com/v2/usage").openConnection();
            con.addRequestProperty("Authorization", "DeepL-Auth-Key " + DEEPL_AUTH_KEY);
            con.connect();
            return con.getInputStream();
        }
        catch (Exception e) {
            throw new RuntimeException("Getting usage stats failed", e);
        }
    }
}

