/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.dita;

import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.event.PreCreateAssoc;
import systems.dmx.core.service.event.PreCreateTopic;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.dita.DITAProcess;
import systems.dmx.topicmaps.TopicmapsService;

@Path(value="/dita")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DITAPlugin
extends PluginActivator
implements PreCreateTopic,
PreCreateAssoc {
    @Inject
    private TopicmapsService tmService;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    @PUT
    @Path(value="/process/{id}/topicmap/{topicmapId}")
    public void process(@PathParam(value="id") long processorId, @PathParam(value="topicmapId") long topicmapId) {
        try {
            new DITAProcess(processorId, topicmapId, this.tmService, this.dmx).run();
        }
        catch (Exception e) {
            throw new RuntimeException("DITA processing failed, processorId=" + processorId + ", topicmapId=" + topicmapId, e);
        }
    }

    public void init() {
        DMXTransaction tx = this.dmx.beginTx();
        try {
            DITAProcess.getTranstypes().forEach(transtype -> this.dmx.createTopic(this.mf.newTopicModel("dmx.dita.output_format", new SimpleValue(transtype))));
            tx.success();
        }
        catch (Exception e) {
            this.logger.warning("ROLLBACK! (" + (Object)((Object)this) + ")");
            throw new RuntimeException("Creating \"Output Format\" topics failed", e);
        }
        finally {
            tx.finish();
        }
    }

    public void preCreateTopic(TopicModel topic) {
        ChildTopicsModel ctm;
        if (topic.getTypeUri().equals("dmx.dita.processor") && (ctm = topic.getChildTopics()).getString("dmx.dita.output_format", "").equals("")) {
            ctm.set("dmx.dita.output_format", (Object)"html5");
        }
    }

    public void preCreateAssoc(AssocModel assoc) {
        DMXUtils.assocAutoTyping((AssocModel)assoc, (String)"dmx.dita.topic", (String)"dmx.dita.topic", (String)"dmx.core.sequence", (String)"dmx.core.predecessor", (String)"dmx.core.successor");
    }
}

