/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.fileupload.provider;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import systems.dmx.config.ConfigService;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.osgi.CoreActivator;
import systems.dmx.core.service.CoreService;
import systems.dmx.files.DiskQuotaCheck;
import systems.dmx.files.FilesPlugin;
import systems.dmx.files.UploadedFile;

@Provider
public class UploadedFileProvider
implements MessageBodyReader<UploadedFile>,
DiskQuotaCheck {
    @Context
    private HttpServletRequest request;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == UploadedFile.class && mediaType.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE);
    }

    public UploadedFile readFrom(Class<UploadedFile> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return this.parseMultiPart();
        }
        catch (Exception e) {
            throw new RuntimeException("Deserializing an UploadedFile object failed", e);
        }
    }

    public void check(long fileSize) {
        CoreService dmx = CoreActivator.getCoreService();
        String username = dmx.getPrivilegedAccess().getUsername(this.request);
        if (username == null) {
            throw new RuntimeException("User <anonymous> has no disk quota");
        }
        dmx.fireEvent(FilesPlugin.CHECK_DISK_QUOTA, new Object[]{username, fileSize, this.diskQuota(username)});
    }

    private UploadedFile parseMultiPart() {
        try {
            UploadedFile file = null;
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest(this.request);
            this.logger.info("### Parsing multipart/form-data request (" + items.size() + " parts)");
            for (FileItem item : items) {
                String fieldName = item.getFieldName();
                if (item.isFormField()) {
                    this.logger.info("### field \"" + fieldName + "\" => \"" + item.getString() + "\"");
                    continue;
                }
                if (file != null) {
                    throw new RuntimeException("Only single file uploads are supported");
                }
                file = new UploadedFile(item, (DiskQuotaCheck)this);
                this.logger.info("### field \"" + fieldName + "\" => " + file);
            }
            if (file == null) {
                throw new RuntimeException("Request does not contain a file part");
            }
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing multipart/form-data request failed", e);
        }
    }

    private long diskQuota(String username) {
        Topic usernameTopic = CoreActivator.getCoreService().getPrivilegedAccess().getUsernameTopic(username);
        ConfigService cs = (ConfigService)CoreActivator.getService(ConfigService.class);
        RelatedTopic configTopic = cs.getConfigTopic("dmx.files.disk_quota", usernameTopic.getId());
        return 0x100000 * configTopic.getSimpleValue().intValue();
    }
}

