/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.fileupload;

import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import systems.dmx.config.ConfigDefinition;
import systems.dmx.config.ConfigModificationRole;
import systems.dmx.config.ConfigService;
import systems.dmx.config.ConfigTarget;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.files.FilesService;
import systems.dmx.files.StoredFile;
import systems.dmx.files.UploadedFile;

@Path(value="/upload")
@Produces(value={"application/json"})
public class FileUploadPlugin
extends PluginActivator {
    private static final int DISK_QUOTA_MB = Integer.getInteger("dmx.filerepo.disk_quota", -1);
    @Inject
    private FilesService fs;
    @Inject
    private ConfigService cs;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    @POST
    @Path(value="/{path}")
    @Consumes(value={"multipart/form-data"})
    @Transactional
    public StoredFile storeFile(UploadedFile file, @PathParam(value="path") String repoPath) {
        return this.fs.storeFile(file, repoPath);
    }

    @POST
    @Path(value="/{path}/folder/{folder_name}")
    public void createFolder(@PathParam(value="folder_name") String folderName, @PathParam(value="path") String repoPath) {
        this.fs.createFolder(folderName, repoPath);
    }

    public void preInstall() {
        this.cs.registerConfigDefinition(new ConfigDefinition(ConfigTarget.TYPE_INSTANCES, "dmx.accesscontrol.username", this.mf.newTopicModel("dmx.files.disk_quota", new SimpleValue(DISK_QUOTA_MB)), ConfigModificationRole.ADMIN));
    }

    public void shutdown() {
        if (this.cs != null) {
            this.cs.unregisterConfigDefinition("dmx.files.disk_quota");
        }
    }
}

