/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.geomaps;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Cookies;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.event.PostCreateTopic;
import systems.dmx.core.service.event.PostUpdateTopic;
import systems.dmx.core.service.event.PreSendTopic;
import systems.dmx.core.util.ContextTracker;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.facets.FacetsService;
import systems.dmx.geomaps.GeoCoordinate;
import systems.dmx.geomaps.Geomap;
import systems.dmx.geomaps.GeomapType;
import systems.dmx.geomaps.GeomapsConstants;
import systems.dmx.geomaps.GeomapsService;
import systems.dmx.topicmaps.TopicmapType;
import systems.dmx.topicmaps.TopicmapsService;

@Path(value="/geomaps")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GeomapsPlugin
extends PluginActivator
implements GeomapsService,
GeomapsConstants,
PostCreateTopic,
PostUpdateTopic,
PreSendTopic {
    private static final String GEOCODER_URL = "https://nominatim.openstreetmap.org/search?street=%s&postalcode=%s&city=%s&country=%s&format=json&limit=1";
    private static final String COOKIE_NO_GEOCODING = "dmx_no_geocoding";
    private static final double EARTH_RADIUS_KM = 6371.009;
    @Inject
    private TopicmapsService topicmapsService;
    @Inject
    private FacetsService facetsService;
    private ContextTracker contextTracker = new ContextTracker();
    private Messenger me = new Messenger("systems.dmx.webclient");
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    @Path(value="/{id}")
    public Geomap getGeomap(@PathParam(value="id") long geomapId) {
        try {
            this.logger.info("Fetching geomap " + geomapId);
            Topic geomapTopic = (Topic)this.dmx.getTopic(geomapId).loadChildTopics();
            return new Geomap(geomapTopic.getModel(), this.fetchGeomapViewProps(geomapTopic), this.fetchGeoCoordinates(geomapTopic));
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching geomap " + geomapId + " failed", e);
        }
    }

    @Override
    @GET
    @Path(value="/coord/{geo_coord_id}")
    public List<Topic> getDomainTopics(@PathParam(value="geo_coord_id") long geoCoordId) {
        try {
            return DMXUtils.getParentTopics((Topic)this.dmx.getTopic(geoCoordId));
        }
        catch (Exception e) {
            throw new RuntimeException("Finding domain topics failed (geoCoordId=" + geoCoordId + ")", e);
        }
    }

    @Override
    public GeoCoordinate getGeoCoordinate(Topic geoTopic) {
        try {
            Topic geoCoordTopic = this.getGeoCoordinateTopic(geoTopic);
            if (geoCoordTopic != null) {
                return this.geoCoordinate(geoCoordTopic);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Getting the geo coordinate failed (geoTopic=" + geoTopic + ")", e);
        }
    }

    @Override
    public GeoCoordinate geoCoordinate(Topic geoCoordTopic) {
        ChildTopics childTopics = geoCoordTopic.getChildTopics();
        return new GeoCoordinate(childTopics.getDouble("dmx.geomaps.longitude"), childTopics.getDouble("dmx.geomaps.latitude"));
    }

    @Override
    @PUT
    @Path(value="/{id}/coord/{geo_coord_id}")
    @Transactional
    public void addCoordinateToGeomap(@PathParam(value="id") long geomapId, @PathParam(value="geo_coord_id") long geoCoordId) {
        this.logger.info("### Adding geo coordinate topic " + geoCoordId + " to geomap " + geomapId);
        this.dmx.createAssoc(this.mf.newAssocModel("dmx.geomaps.geomap_context", (PlayerModel)this.mf.newTopicPlayerModel(geomapId, "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(geoCoordId, "dmx.core.default")));
    }

    @Override
    @PUT
    @Path(value="/{id}/center/{lon}/{lat}/zoom/{zoom}")
    @Transactional
    public void setGeomapState(@PathParam(value="id") long geomapId, @PathParam(value="lon") double lon, @PathParam(value="lat") double lat, @PathParam(value="zoom") double zoom) {
        try {
            this.mf.newViewProps().set("dmx.geomaps.longitude", (Object)lon).set("dmx.geomaps.latitude", (Object)lat).set("dmx.geomaps.zoom", (Object)zoom).store((DMXObject)this.dmx.getTopic(geomapId));
        }
        catch (Exception e) {
            throw new RuntimeException("Setting state of geomap " + geomapId + " failed (lon=" + lon + ", lat=" + lat + ", zoom=" + zoom + ")", e);
        }
    }

    @Override
    @GET
    @Path(value="/distance")
    public double getDistance(@QueryParam(value="coord1") GeoCoordinate coord1, @QueryParam(value="coord2") GeoCoordinate coord2) {
        double lonDiff = Math.toRadians(coord2.lon - coord1.lon);
        double latDiff = Math.toRadians(coord2.lat - coord1.lat);
        double latMean = Math.toRadians((coord1.lat + coord2.lat) / 2.0);
        return 6371.009 * Math.sqrt(Math.pow(latDiff, 2.0) + Math.pow(Math.cos(latMean) * lonDiff, 2.0));
    }

    @Override
    public <V> V runWithoutGeocoding(Callable<V> callable) throws Exception {
        return (V)this.contextTracker.run(callable);
    }

    public void init() {
        this.topicmapsService.registerTopicmapType((TopicmapType)new GeomapType());
    }

    public void postCreateTopic(Topic topic) {
        if (topic.getTypeUri().equals("dmx.contacts.address")) {
            if (!this.abortGeocoding(topic)) {
                this.facetsService.addFacetTypeToTopic(topic.getId(), "dmx.geomaps.geo_coordinate_facet");
                Address address = new Address(topic);
                if (!address.isEmpty()) {
                    this.logger.info("### New " + address);
                    this.geocodeAndStoreFacet(address, topic);
                } else {
                    this.logger.info("New empty address");
                }
            }
        } else if (topic.getTypeUri().equals("dmx.geomaps.geo_coordinate")) {
            this.me.newGeoCoord((Topic)topic.loadChildTopics());
        }
    }

    public void postUpdateTopic(Topic topic, TopicModel updateModel, TopicModel oldTopic) {
        if (topic.getTypeUri().equals("dmx.contacts.address")) {
            throw new RuntimeException("postUpdateTopic() invoked for an Address topic: " + topic);
        }
    }

    public void preSendTopic(Topic topic) {
        Topic address = topic.findChildTopic("dmx.contacts.address");
        if (address != null) {
            String operation = "Enriching address " + address.getId() + " with its geo coordinate";
            Topic geoCoordTopic = this.getGeoCoordinateTopic(address);
            if (geoCoordTopic != null) {
                this.logger.info(operation);
                address.getChildTopics().getModel().set("dmx.geomaps.geo_coordinate", geoCoordTopic.getModel());
            } else {
                this.logger.info(operation + " SKIPPED -- no geo coordinate in DB");
            }
        }
    }

    private ViewProps fetchGeomapViewProps(Topic geomapTopic) {
        return this.mf.newViewProps().set("dmx.geomaps.longitude", geomapTopic.getProperty("dmx.geomaps.longitude")).set("dmx.geomaps.latitude", geomapTopic.getProperty("dmx.geomaps.latitude")).set("dmx.geomaps.zoom", geomapTopic.getProperty("dmx.geomaps.zoom"));
    }

    private Map<Long, TopicModel> fetchGeoCoordinates(Topic geomapTopic) {
        HashMap<Long, TopicModel> geoCoords = new HashMap<Long, TopicModel>();
        for (Topic topic : this._fetchGeoCoordinates(geomapTopic)) {
            geoCoords.put(topic.getId(), topic.getModel());
        }
        return geoCoords;
    }

    private List<? extends Topic> _fetchGeoCoordinates(Topic geomapTopic) {
        return DMXUtils.loadChildTopics((List)this.dmx.getTopicsByType("dmx.geomaps.geo_coordinate"));
    }

    private Topic getGeoCoordinateTopic(Topic geoTopic) {
        RelatedTopic geoCoordTopic = this.facetsService.getFacet((DMXObject)geoTopic, "dmx.geomaps.geo_coordinate_facet");
        return geoCoordTopic != null ? (Topic)geoCoordTopic.loadChildTopics() : null;
    }

    private void geocodeAndStoreFacet(Address address, Topic topic) {
        try {
            GeoCoordinate geoCoord = address.geocode();
            this.storeGeoCoordinate(topic, geoCoord);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Adding geo coordinate to " + address + " failed", e);
        }
    }

    private void storeGeoCoordinate(Topic address, GeoCoordinate geoCoord) {
        try {
            this.logger.info("Storing geo coordinate (" + geoCoord + ") of address topic " + address.getId());
            this.facetsService.updateFacet((DMXObject)address, "dmx.geomaps.geo_coordinate_facet", this.mf.newFacetValueModel("dmx.geomaps.geo_coordinate").set(this.mf.newChildTopicsModel().set("dmx.geomaps.longitude", (Object)geoCoord.lon).set("dmx.geomaps.latitude", (Object)geoCoord.lat)));
        }
        catch (Exception e) {
            throw new RuntimeException("Storing geo coordinate of address " + address.getId() + " failed", e);
        }
    }

    private boolean abortGeocoding(Topic address) {
        return this.abortGeocodingByCookie(address) || this.abortGeocodingByExcecutionContext(address);
    }

    private boolean abortGeocodingByCookie(Topic address) {
        boolean abort = false;
        Cookies cookies = Cookies.get();
        if (cookies.has(COOKIE_NO_GEOCODING)) {
            String value = cookies.get(COOKIE_NO_GEOCODING);
            if (!value.equals("false") && !value.equals("true")) {
                throw new RuntimeException("\"" + value + "\" is an unexpected value for the \"" + COOKIE_NO_GEOCODING + "\" cookie (expected are \"false\" or \"true\")");
            }
            abort = value.equals("true");
            if (abort) {
                this.logger.info("Geocoding for Address topic " + address.getId() + " SUPPRESSED -- \"" + COOKIE_NO_GEOCODING + "\" cookie detected");
            }
        }
        return abort;
    }

    private boolean abortGeocodingByExcecutionContext(Topic address) {
        boolean abort = this.contextTracker.runsInTrackedContext();
        if (abort) {
            this.logger.info("Geocoding for Address topic " + address.getId() + " SUPPRESSED -- runWithoutGeocoding() context detected");
        }
        return abort;
    }

    private class Messenger {
        private String pluginUri;

        private Messenger(String pluginUri) {
            this.pluginUri = pluginUri;
        }

        private void newGeoCoord(Topic geoCoordTopic) {
            try {
                this.messageToAll(new JSONObject().put("type", (Object)"newGeoCoord").put("args", (Object)new JSONObject().put("geoCoordTopic", (Object)geoCoordTopic.toJSON())));
            }
            catch (Exception e) {
                GeomapsPlugin.this.logger.log(Level.WARNING, "Error while sending a \"newGeoCoord\" message:", e);
            }
        }

        private void messageToAll(JSONObject message) {
            GeomapsPlugin.this.dmx.getWebSocketsService().messageToAll(this.pluginUri, message.toString());
        }
    }

    private class Address {
        String street;
        String postalCode;
        String city;
        String country;

        Address(Topic address) {
            ChildTopics children = address.getChildTopics();
            this.street = children.getString("dmx.contacts.street", "");
            this.postalCode = children.getString("dmx.contacts.postal_code", "");
            this.city = children.getString("dmx.contacts.city", "");
            this.country = children.getString("dmx.contacts.country", "");
        }

        GeoCoordinate geocode() {
            URL url = null;
            try {
                url = new URL(String.format(GeomapsPlugin.GEOCODER_URL, JavaUtils.encodeURIComponent((String)this.street), JavaUtils.encodeURIComponent((String)this.postalCode), JavaUtils.encodeURIComponent((String)this.city), JavaUtils.encodeURIComponent((String)this.country)));
                GeomapsPlugin.this.logger.info("Geocoding url=\"" + url + "\"");
                JSONArray results = new JSONArray(JavaUtils.readTextURL((URL)url));
                if (results.length() == 0) {
                    throw new RuntimeException("Address not found");
                }
                JSONObject result = results.getJSONObject(0);
                GeoCoordinate geoCoord = new GeoCoordinate(result.getDouble("lon"), result.getDouble("lat"));
                GeomapsPlugin.this.logger.info("=> " + geoCoord);
                return geoCoord;
            }
            catch (Exception e) {
                throw new RuntimeException("Geocoding failed, url=\"" + url + "\"", e);
            }
        }

        boolean isEmpty() {
            return this.street.equals("") && this.postalCode.equals("") && this.city.equals("") && this.country.equals("");
        }

        String changeReport(Address oldAddr) {
            StringBuilder report = new StringBuilder();
            if (!this.street.equals(oldAddr.street)) {
                report.append("\n    Street: \"" + oldAddr.street + "\" -> \"" + this.street + "\"");
            }
            if (!this.postalCode.equals(oldAddr.postalCode)) {
                report.append("\n    Postal Code: \"" + oldAddr.postalCode + "\" -> \"" + this.postalCode + "\"");
            }
            if (!this.city.equals(oldAddr.city)) {
                report.append("\n    City: \"" + oldAddr.city + "\" -> \"" + this.city + "\"");
            }
            if (!this.country.equals(oldAddr.country)) {
                report.append("\n    Country: \"" + oldAddr.country + "\" -> \"" + this.country + "\"");
            }
            return report.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof Address) {
                Address addr = (Address)o;
                return this.street.equals(addr.street) && this.postalCode.equals(addr.postalCode) && this.city.equals(addr.city) && this.country.equals(addr.country);
            }
            return false;
        }

        public int hashCode() {
            return (this.street + this.postalCode + this.city + this.country).hashCode();
        }

        public String toString() {
            return "address (street=\"" + this.street + "\", postalCode=\"" + this.postalCode + "\", city=\"" + this.city + "\", country=\"" + this.country + "\")";
        }
    }
}

