/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.importexport;

import com.sun.jersey.core.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import systems.dmx.core.Assoc;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.topicmaps.ViewAssoc;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.model.topicmaps.ViewTopic;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.files.FilesService;
import systems.dmx.files.UploadedFile;
import systems.dmx.importexport.SVGRenderer;
import systems.dmx.topicmaps.Topicmap;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/import-export")
@Produces(value={"application/json"})
public class ImportExportPlugin
extends PluginActivator {
    @Inject
    private TopicmapsService topicmaps;
    @Inject
    private FilesService file;
    @Inject
    private WorkspacesService workspaces;
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static final String DM4_TIME_CREATED = "dmx.time.created";
    private static final String DM4_TIME_MODIFIED = "dmx.time.modified";
    private static final String ZOTERO_ENTRY_TYPE_COLUMN_KEY = "Typ";
    private static final String ZOTERO_ENTRY_URL_COLUMN_KEY = "URL";
    private static final String ZOTERO_MODIFIED_AT_COLUMN_KEY = "Ge\u00e4ndert am";
    private static final String ZOTERO_ADDED_AT_COLUMN_KEY = "Hinzugef\u00fcgt am";

    @GET
    @Transactional
    @Path(value="/configured/content")
    public Topic exportConfiguredTopicTypes() {
        String jsonFileName = "dmx-import-export-configured-" + new Date().toString() + ".txt";
        ByteArrayInputStream in = null;
        try {
            this.log.info("######## Start exporting topics of all configured topic and assoc types to JSON ######### ");
            JSONObject json = new JSONObject();
            this.addWorkspaceTopicsToExport(json);
            List<RelatedTopic> configuredTypes = this.getConfiguredTopicTypesForExport();
            List<RelatedTopic> configuredAssocTypes = this.getConfiguredAssocTypesForExport();
            json.put("topics", (Object)new JSONArray());
            for (RelatedTopic type : configuredTypes) {
                this.exportTopicsAndAssocsToJSON(type.getUri(), configuredAssocTypes, json);
            }
            List topicmaps = this.dmx.getTopicsByType("dmx.topicmaps.topicmap");
            json.put("topicmaps", (Object)new JSONArray());
            for (Topic topicmap : topicmaps) {
                this.log.info("### Exporting topicmap \"" + topicmap.getSimpleValue() + "\" ...");
                this.exportTopicmapToJSON(topicmap, json);
            }
            in = new ByteArrayInputStream(json.toString().getBytes("UTF-8"));
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.file.createFile(in, this.file.pathPrefix() + "/" + jsonFileName);
    }

    private void addWorkspaceTopicsToExport(JSONObject json) {
        try {
            json.put("workspaces", (Object)new JSONArray());
            List allWorksapces = this.dmx.getTopicsByType("dmx.workspaces.workspace");
            Iterator workspaces = allWorksapces.iterator();
            this.log.info("### Exporting workspace topics ...");
            while (workspaces.hasNext()) {
                try {
                    JSONArray jsonTopics = json.getJSONArray("workspaces");
                    jsonTopics.put((Object)((Topic)workspaces.next()).toJSON());
                }
                catch (AccessControlException ex) {
                    this.log.warning("### Workspace read permission denied => " + ex.getLocalizedMessage().toString());
                }
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private List<RelatedTopic> getConfiguredTopicTypesForExport() {
        Topic plugin = this.dmx.getTopicByUri("systems.dmx.import-export");
        this.log.info("Loaded " + plugin.getSimpleValue() + " plugin topic for inspecting export type configuration");
        List configuredTypes = plugin.getRelatedTopics("dmx.core.association", "dmx.core.default", "dmx.core.default", "dmx.core.topic_type");
        return configuredTypes;
    }

    private List<RelatedTopic> getConfiguredAssocTypesForExport() {
        Topic plugin = this.dmx.getTopicByUri("systems.dmx.import-export");
        List configuredAssocTypes = plugin.getRelatedTopics("dmx.core.association", "dmx.core.default", "dmx.core.default", "dmx.core.assoc_type");
        return configuredAssocTypes;
    }

    private void exportTopicmapToJSON(Topic topicmapTopic, JSONObject json) {
        try {
            JSONArray jsonTopics = json.getJSONArray("topicmaps");
            Topicmap topicmap = this.topicmaps.getTopicmap(topicmapTopic.getId(), true);
            Topic ws = this.workspaces.getAssignedWorkspace(topicmapTopic.getId());
            ws.loadChildTopics();
            JSONObject tm = topicmap.toJSON();
            tm.put("workspace", (Object)ws.toJSON());
            jsonTopics.put((Object)tm);
        }
        catch (AccessControlException ex) {
            this.log.warning("Topicmap read permission denied => " + ex.getLocalizedMessage().toString());
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @GET
    @Transactional
    @Path(value="/content/json/{typeUri}")
    public Topic exportTopicsAndAssocsToJSON(@PathParam(value="typeUri") String typeUri, List<RelatedTopic> assocTypes, JSONObject givenJson) {
        try {
            this.log.info("### Exporting topics of type \"" + typeUri + "\" with associations ...");
            JSONObject json = givenJson != null ? givenJson : new JSONObject();
            List allTopics = this.dmx.getTopicsByType(typeUri);
            Iterator topics = allTopics.iterator();
            while (topics.hasNext()) {
                try {
                    JSONArray jsonTopics = json.getJSONArray("topics");
                    JSONObject topic = this.createTopicWithAssociationsJSON((Topic)topics.next(), assocTypes);
                    if (topic == null) continue;
                    jsonTopics.put((Object)topic);
                }
                catch (AccessControlException ex) {
                    this.log.warning("### Topic read permission denied => " + ex.getLocalizedMessage().toString());
                }
            }
            if (givenJson == null) {
                ByteArrayInputStream in = new ByteArrayInputStream(json.toString().getBytes("UTF-8"));
                String jsonFileName = "dmx-" + typeUri + "-topics-" + new Date().toString() + ".txt";
                return this.file.createFile((InputStream)in, this.file.pathPrefix() + "/" + jsonFileName);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating Topics and Associations JSON Export failed", e);
        }
    }

    private JSONObject createTopicWithAssociationsJSON(Topic topic, List<RelatedTopic> assocTypes) throws JSONException {
        topic.loadChildTopics();
        ArrayList<Assoc> assocs = new ArrayList<Assoc>();
        for (RelatedTopic assocType : assocTypes) {
            List relatedTopics = topic.getRelatedTopics(assocType.getUri(), null, null, null);
            for (RelatedTopic relatedTopic : relatedTopics) {
                assocs.add(relatedTopic.getRelatingAssoc().loadChildTopics());
            }
        }
        return new JSONObject().put("topic", (Object)topic.toJSON()).put("associations", (Object)DMXUtils.toJSONArray(assocs));
    }

    @POST
    @Transactional
    @Path(value="/topicmap/export/json")
    public Topic exportTopicmapToJSON(@CookieParam(value="dmx_topicmap_id") long topicmapId) {
        try {
            this.log.info("Exporting Topicmap JSON ######### " + topicmapId);
            Topicmap topicmap = this.topicmaps.getTopicmap(topicmapId, true);
            String json = topicmap.toJSON().toString();
            ByteArrayInputStream in = new ByteArrayInputStream(json.getBytes("UTF-8"));
            String jsonFileName = "topicmap-" + topicmapId + ".txt";
            return this.file.createFile((InputStream)in, this.file.pathPrefix() + "/" + jsonFileName);
        }
        catch (Exception e) {
            throw new RuntimeException("Export failed", e);
        }
    }

    @POST
    @Path(value="/topicmap/export/svg")
    @Transactional
    public Topic exportTopicmapToSVG(@CookieParam(value="dmx_topicmap_id") long topicmapId) throws XMLStreamException {
        int BOX_HEIGHT = 20;
        int MARGIN_LEFT = 5;
        int MARGIN_TOP = 14;
        int ICON_WIDTH = 16;
        int ICON_HEIGHT = 16;
        try {
            this.log.info("Exporting Topicmap SVG ######### " + topicmapId);
            Topicmap topicmap = this.topicmaps.getTopicmap(topicmapId, true);
            Iterable topics = topicmap.getTopics();
            Iterable associations = topicmap.getAssocs();
            String svgFileName = "Exported_Topicmap_" + topicmapId + ".svg";
            String documentPath = this.file.getFile("/") + "/" + svgFileName;
            SVGRenderer svg = new SVGRenderer(documentPath);
            svg.startGroupElement(topicmapId);
            for (ViewAssoc association : associations) {
                String valueAssoc = association.getSimpleValue().toString();
                long topic1Id = association.getPlayer1().getId();
                long topic2Id = association.getPlayer2().getId();
                ViewTopic topic1 = topicmap.getTopic(topic1Id);
                int x1 = topic1.getX();
                int y1 = topic1.getY();
                ViewTopic topic2 = topicmap.getTopic(topic2Id);
                int x2 = topic2.getX();
                int y2 = topic2.getY();
                int dx = x2 - x1;
                int dy = y2 - y1;
                int label_x = dx / 2;
                int label_y = dy / 2;
                double assocLine = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                double alpha = Math.asin((double)dy / assocLine) * 180.0 / Math.PI;
                if (dx < 0) {
                    alpha = -alpha;
                }
                svg.startGroupElement(association.getId());
                svg.line(x1, x2, y1, y2);
                svg.text(label_x, label_y, x1 + 10, y1 + 10, valueAssoc, "grey", alpha);
                svg.endElement();
            }
            for (ViewTopic topic : topics) {
                String value = topic.getSimpleValue().toString();
                int x = topic.getX();
                int y = topic.getY();
                boolean visibility = topic.getVisibility();
                int boxWidth = value.length() * 9;
                if (!visibility) continue;
                svg.startGroupElement(topic.getId());
                svg.rectangle(x - boxWidth / 2, y - 10, boxWidth, 20, this.color(topic.getTypeUri()));
                svg.text(x - boxWidth / 2 + 5, y - 10 + 14, value, "black");
                svg.endElement();
            }
            svg.endElement();
            svg.closeDocument();
            return this.file.getFileTopic(this.file.pathPrefix() + "/" + svgFileName);
        }
        catch (Exception e) {
            throw new RuntimeException("Export Topicmap to SVG failed", e);
        }
    }

    @POST
    @Path(value="/import")
    @Transactional
    @Consumes(value={"multipart/form-data"})
    public Topic importTopicmap(UploadedFile file) {
        try {
            String json = file.getString();
            JSONObject topicmap = new JSONObject(json);
            JSONObject info = topicmap.getJSONObject("info");
            JSONArray assocsArray = topicmap.getJSONArray("assocs");
            JSONArray topicsArray = topicmap.getJSONArray("topics");
            String origTopicmapName = info.getString("value");
            Topic importedTopicmap = this.topicmaps.createTopicmap("Imported Topicmap: " + origTopicmapName, "dmx.webclient.default_topicmap_renderer", null);
            long topicmapId = importedTopicmap.getId();
            this.log.info("###### importedTopicmapId " + topicmapId);
            HashMap<Long, Long> mapTopicIds = new HashMap<Long, Long>();
            this.importTopics(topicsArray, mapTopicIds, topicmapId);
            this.importAssociations(assocsArray, mapTopicIds, topicmapId);
            return importedTopicmap;
        }
        catch (Exception e) {
            throw new RuntimeException("Importing Topicmap FAILED", e);
        }
    }

    @POST
    @Path(value="/import/bookmarks/firefox")
    @Transactional
    @Consumes(value={"multipart/form-data"})
    public String importFirefoxBookmarks(UploadedFile file) {
        try {
            String json = file.getString("UTF-8");
            JSONObject fileContent = new JSONObject(json);
            JSONArray firstChildren = fileContent.getJSONArray("children");
            this.log.info("###### Starting to map Firefox Bookmark Backup Entries to DeepaMehta 4 Web Resources ######");
            Topic importedNote = this.createNoteImportTopic(file.getName());
            int webResourcesCreatedCount = 0;
            for (int i = 0; i < firstChildren.length(); ++i) {
                JSONObject entry = firstChildren.getJSONObject(i);
                if (!entry.has("children")) continue;
                JSONArray entryChilds = entry.getJSONArray("children");
                for (int k = 0; k < entryChilds.length(); ++k) {
                    JSONObject childEntry = entryChilds.getJSONObject(k);
                    Topic webResource = this.transformMozillaBookmarkEntry(childEntry, importedNote, null, 0);
                    if (webResource == null) continue;
                    ++webResourcesCreatedCount;
                }
            }
            this.log.info("#### Mapping Firefox Bookmarks Backup COMPLETE: Created " + webResourcesCreatedCount + " new web resources ####");
            return "{\"message\": \"All valid bookmarks contained in the Firefox backup file were successfully mapped to <em>Web Resources</em>.\", \"topic_id\": " + importedNote.getId() + "}";
        }
        catch (Exception e) {
            throw new RuntimeException("Importing Web Resources from Firefox Bookmarks Backup FAILED", e);
        }
    }

    @POST
    @Path(value="/import/bookmarks/chromium")
    @Transactional
    @Consumes(value={"multipart/form-data"})
    public String importChromiumBookmarks(UploadedFile file) {
        try {
            String htmlString = file.getString("UTF-8");
            Document doc = Jsoup.parse((String)htmlString);
            Elements folderNames = doc.getElementsByTag("dt");
            this.log.info("###### Starting to map Chromium Bookmark HTML Export to DeepaMehta 4 Web Resources ######");
            Topic importedNote = this.createNoteImportTopic(file.getName());
            this.log.info("### Iterating " + folderNames.size() + " chromium bookmark entries (flattened).");
            if (folderNames.size() > 0) {
                Element dummyEntry = (Element)folderNames.get(0);
                Elements nodes = dummyEntry.children();
                for (Element element : nodes) {
                    this.transformChromiumResourceEntry(importedNote, element, null);
                }
            }
            this.log.info("#### Mapping Chromium Bookmarks Backup to Web Resources COMPLETED ####");
            return "{\"message\": \"All valid chromium bookmark entries contained in the backup file were successfully mapped to <em>Web Resources</em>.\", \"topic_id\": " + importedNote.getId() + "}";
        }
        catch (Exception e) {
            throw new RuntimeException("Importing Web Resources from Chromium Bookmarks file FAILED", e);
        }
    }

    @POST
    @Path(value="/import/bookmarks/zotero-report")
    @Transactional
    @Consumes(value={"multipart/form-data"})
    public String importZoteroReportBookmarks(UploadedFile file) {
        try {
            String htmlString = file.getString("UTF-8");
            Document doc = Jsoup.parse((String)htmlString);
            Elements webpages = doc.getElementsByClass("webpage");
            this.log.info("###### Starting to map Zotero Report Bookmarks to DeepaMehta 4 Web Resources ######");
            Topic importedNote = this.createNoteImportTopic(file.getName());
            this.log.info("### Iterating " + webpages.size() + " webpages in zotero report.");
            for (Element webpage : webpages) {
                this.transformZoteroWebpageEntry(importedNote, webpage);
            }
            this.log.info("#### Mapping Zotero Report Bookmarks to Web Resources COMPLETED ####");
            return "{\"message\": \"All valid webpages in the zotero report file were successfully mapped to <em>Web Resources</em>.\", \"topic_id\": " + importedNote.getId() + "}";
        }
        catch (Exception e) {
            throw new RuntimeException("Importing Web Resources from Zotero Report Bookmarks file FAILED", e);
        }
    }

    private Topic transformMozillaBookmarkEntry(JSONObject childEntry, Topic importedNote, Topic folderNameTag, int levelCount) {
        Topic webResource = null;
        int recursionCount = levelCount;
        try {
            String entryType = childEntry.getString("type");
            if (entryType.equals("text/x-moz-place")) {
                if (childEntry.has("title") && childEntry.has("uri")) {
                    webResource = this.transformFirefoxResourceEntry(childEntry);
                    if (webResource != null) {
                        this.createBookmarkRelations(importedNote, webResource, folderNameTag);
                    } else {
                        this.log.warning("Web Resource Entry could not be created with JSONObject: " + childEntry.toString());
                    }
                } else {
                    this.log.warning("Skipping Bookmark entry due to missing Title or URL, " + childEntry.toString());
                }
            } else if (entryType.equals("text/x-moz-place-container")) {
                this.log.warning("Bookmarking Container Detected - Mapping Bookmarker Folders to Tags...");
                String folderName = childEntry.getString("title");
                Topic folderTopic = this.createTagTopic(folderName);
                if (folderNameTag != null) {
                    this.getOrCreateSimpleAssoc(folderNameTag, folderTopic);
                }
                JSONArray entryChildsChilds = childEntry.getJSONArray("children");
                this.log.info("  " + recursionCount + "ndLevel Bookmark Folder " + folderName + " - TODO: Transform \"" + folderName + "\" into TAG");
                for (int m = 0; m < entryChildsChilds.length(); ++m) {
                    JSONObject childChildEntry = entryChildsChilds.getJSONObject(m);
                    this.transformMozillaBookmarkEntry(childChildEntry, importedNote, folderTopic, ++recursionCount);
                }
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        return webResource;
    }

    private Topic createTagTopic(String tagName) {
        return this.dmx.createTopic(this.mf.newTopicModel("dmx.tags.tag", this.mf.newChildTopicsModel().put("dmx.tags.tag_name", (Object)tagName)));
    }

    private Topic transformFirefoxResourceEntry(JSONObject childEntry) {
        try {
            String bookmarkDescription = childEntry.getString("title");
            String bookmarkUrl = childEntry.getString("uri");
            long dateAdded = 0L;
            if (bookmarkUrl.startsWith("place:") || bookmarkUrl.startsWith("chrome:") || bookmarkUrl.startsWith("about:")) {
                return null;
            }
            if (childEntry.has("dateAdded")) {
                dateAdded = childEntry.getLong("dateAdded");
                dateAdded = new Date(dateAdded / 1000L).getTime();
            } else {
                this.log.warning("Could not detect " + bookmarkDescription + " dateAdded timestamp, setting it NOW, DEBUG: " + childEntry.toString());
            }
            long lastModified = 0L;
            if (childEntry.has("lastModified")) {
                childEntry.getLong("lastModified");
                lastModified = new Date(lastModified / 1000L).getTime();
            } else {
                this.log.warning("Could not detect " + bookmarkDescription + " lastModified timestamp, setting it NOW, DEBUG: " + childEntry.toString());
            }
            return this.getOrCreateWebResource(bookmarkUrl, bookmarkDescription, dateAdded, lastModified);
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private Topic getTagTopic(String name) {
        Topic tagName = this.dmx.getTopicByValue("dmx.tags.tag_name", new SimpleValue(name));
        return this.getTagTopic(tagName);
    }

    private Topic getTagTopic(Topic name) {
        return name.getRelatedTopic(null, "dmx.core.child", "dmx.core.parent", "dmx.tags.tag");
    }

    private void transformChromiumResourceEntry(Topic importedNote, Element element, Topic toBeRelated) {
        if (element.nodeName().equals("a")) {
            String linkHref = element.attr("href");
            String linkName = element.text();
            String linkAddedValue = element.attr("add_date");
            String linkModifiedValue = element.attr("last_modified");
            long linkAdded = new Date().getTime();
            long linkModified = new Date().getTime();
            if (!linkAddedValue.isEmpty()) {
                linkAdded = Long.parseLong(linkAddedValue) * 1000L;
            }
            if (!linkModifiedValue.isEmpty()) {
                linkModified = Long.parseLong(linkModifiedValue) * 1000L;
            }
            Topic webResource = this.getOrCreateWebResource(linkHref, linkName, linkAdded * 1000L, linkModified);
            this.createBookmarkRelations(importedNote, webResource, toBeRelated);
        } else if (element.nodeName().equals("h3")) {
            String text = element.ownText().trim();
            long folderAdded = Long.parseLong(element.attr("add_date"));
            String linkModifiedValue = element.attr("last_modified");
            long folderModified = new Date().getTime();
            if (!linkModifiedValue.isEmpty()) {
                folderModified = Long.parseLong(linkModifiedValue);
            }
            this.log.info("### Processing chromium bookmark folder element named \"" + text + "\"");
            Topic tag = this.getTagTopic(text);
            if (tag == null) {
                tag = this.createTagTopic(text);
                tag.setProperty(DM4_TIME_CREATED, (Object)folderAdded, true);
                if (folderModified != 0L) {
                    tag.setProperty(DM4_TIME_MODIFIED, (Object)folderModified, true);
                }
                this.log.info("NEW tag \"" + text + "\" created during import");
            }
            if (toBeRelated != null) {
                this.getOrCreateSimpleAssoc(toBeRelated, tag);
            }
            if (importedNote != null && tag != null) {
                this.getOrCreateSimpleAssoc(importedNote, tag);
            }
            this.transformChromiumResourceEntry(importedNote, element.nextElementSibling(), tag);
        } else if (element.nodeName().equals("dt") || element.nodeName().equals("dl")) {
            Elements childNodes = element.children();
            this.log.info("### Processing chromium list element with name " + element.nodeName() + " and " + childNodes.size() + " childs");
            for (Element childNode : childNodes) {
                this.transformChromiumResourceEntry(importedNote, childNode, toBeRelated);
            }
        }
    }

    private Topic transformZoteroWebpageEntry(Topic importedNote, Element listItem) {
        Object webpageTitle = null;
        String webpageUrl = null;
        String entryType = null;
        long bookmarkCreated = new Date().getTime();
        long bookmarkModified = new Date().getTime();
        Topic webpage = null;
        Elements childs = listItem.children();
        for (Element element : childs) {
            Object text;
            if (!element.nodeName().equals("h2")) continue;
            webpageTitle = text = element.ownText().trim();
            this.log.info("### Processed zotero report webpage title \"" + (String)text + "\"");
        }
        ArrayList<String> bookmarkTags = new ArrayList<String>();
        Elements tagElements = listItem.getElementsByClass("tags");
        for (Element tagElement : tagElements) {
            if (!tagElement.nodeName().equals("ul")) continue;
            Elements tagEntries = tagElement.getElementsByTag("li");
            for (Element tagEntry : tagEntries) {
                bookmarkTags.add(tagEntry.ownText().trim());
            }
        }
        Elements attributes = listItem.getElementsByTag("tr");
        for (Element attribute : attributes) {
            String entryModified;
            Element keyCell = attribute.child(0);
            Element valueCell = attribute.child(1);
            String keyOne = keyCell.ownText().trim();
            if (keyOne.equals(ZOTERO_ENTRY_URL_COLUMN_KEY)) {
                Elements ahrefs = valueCell.getElementsByTag("a");
                if (ahrefs.size() <= 0) continue;
                webpageUrl = ((Element)ahrefs.get(0)).attr("href");
                this.log.fine("### Parsed zotero report webpage URL: " + webpageUrl);
                continue;
            }
            if (keyOne.equals(ZOTERO_ENTRY_TYPE_COLUMN_KEY)) {
                entryType = valueCell.ownText();
                continue;
            }
            if (keyOne.equals(ZOTERO_ADDED_AT_COLUMN_KEY)) {
                String entryAdded = valueCell.ownText();
                if (entryAdded.isEmpty()) continue;
                try {
                    new Date();
                    bookmarkCreated = Date.parse(entryAdded);
                }
                catch (IllegalArgumentException iex) {
                    this.log.warning("Could not parse date of bookmark created \"" + entryAdded + "\", cause " + iex.getMessage());
                }
                continue;
            }
            if (!keyOne.equals(ZOTERO_MODIFIED_AT_COLUMN_KEY) || (entryModified = valueCell.ownText()).isEmpty()) continue;
            try {
                new Date();
                bookmarkModified = Date.parse(entryModified);
            }
            catch (IllegalArgumentException iex) {
                this.log.warning("Could not parse date of bookmark last modified \"" + entryModified + "\", cause " + iex.getMessage());
            }
        }
        if (webpageUrl != null) {
            webpage = this.getOrCreateWebResource(webpageUrl, (String)webpageTitle + "<br/>" + entryType, bookmarkCreated, bookmarkModified);
            if (bookmarkTags.size() > 0) {
                this.log.fine("### Importing " + bookmarkTags + " as tags for this webpage from zotero report");
            }
            for (String tagValue : bookmarkTags) {
                Topic tag = this.getTagTopic(tagValue);
                if (tag == null) {
                    tag = this.createTagTopic(tagValue);
                    this.log.info("NEW tag \"" + tagValue + "\" created during import");
                }
                if (tag == null) continue;
                this.createBookmarkRelations(importedNote, webpage, tag);
            }
        }
        return webpage;
    }

    private Topic createNoteImportTopic(String fileName) {
        ChildTopicsModel childValues = this.mf.newChildTopicsModel();
        childValues.put("dmx.notes.title", (Object)("Browser Bookmarks Import, " + fileName));
        childValues.put("dmx.notes.text", (Object)("This note relates web resources created through an import process, namely the Firefox Bookmark Backup File (" + fileName + "). Please do not delete this note as it might become helpful if you need to identify which web resources you imported when and from which backup file they originated from."));
        Topic importerNote = this.dmx.createTopic(this.mf.newTopicModel("dmx.notes.note", childValues));
        this.log.info("### Importer Note Topic for \"" + fileName + "\" CREATED");
        return importerNote;
    }

    private Assoc createBookmarkRelations(Topic importerNote, Topic webResource, Topic folderNameTag) {
        Assoc importedAssoc = null;
        if (importerNote != null && (importedAssoc = this.dmx.getAssoc("dmx.core.association", importerNote.getId(), webResource.getId(), "dmx.core.default", "dmx.core.default")) == null) {
            importedAssoc = this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(importerNote.getId(), "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(webResource.getId(), "dmx.core.default")));
        }
        if (folderNameTag != null) {
            this.getOrCreateSimpleAssoc(folderNameTag, webResource);
        }
        return importedAssoc;
    }

    private Assoc getOrCreateSimpleAssoc(Topic defaultPlayer1, Topic defaultPlayer2) {
        Assoc folderTagAssoc = this.dmx.getAssoc("dmx.core.association", defaultPlayer1.getId(), defaultPlayer2.getId(), "dmx.core.parent", "dmx.core.child");
        if (folderTagAssoc == null) {
            folderTagAssoc = this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(defaultPlayer1.getId(), "dmx.core.parent"), (PlayerModel)this.mf.newTopicPlayerModel(defaultPlayer2.getId(), "dmx.core.child")));
            this.log.info("NEW relation from \"" + defaultPlayer1.getTypeUri() + "\" created to \"" + defaultPlayer2.getTypeUri() + "\"");
        }
        return folderTagAssoc;
    }

    private Topic getOrCreateWebResource(String url, String description, long created, long modified) {
        Topic webResource;
        try {
            webResource = this.dmx.getTopicByValue("dmx.webbrowser.url", new SimpleValue(url.trim()));
            if (webResource != null) {
                this.log.info("### Web Resource \"" + url + "\" EXISTS - NOT UPDATED");
                RelatedTopic webRsrcParent = webResource.getRelatedTopic("dmx.core.composition", "dmx.core.child", "dmx.core.parent", "dmx.webbrowser.web_resource");
                return webRsrcParent != null ? webRsrcParent : webResource;
            }
        }
        catch (RuntimeException re) {
            this.log.warning("Web Resource could not be created, either due to an access control issue or a messed up lucene KEY index (allowing web resources to exists just once in a DB), caused by: " + re.getLocalizedMessage());
        }
        ChildTopicsModel childValues = this.mf.newChildTopicsModel();
        childValues.put("dmx.webbrowser.url", (Object)url.trim());
        childValues.put("dmx.webbrowser.web_resource_description", (Object)description);
        webResource = this.dmx.createTopic(this.mf.newTopicModel("dmx.webbrowser.web_resource", childValues));
        if (created != 0L) {
            webResource.setProperty(DM4_TIME_CREATED, (Object)created, true);
        }
        if (modified != 0L) {
            webResource.setProperty(DM4_TIME_MODIFIED, (Object)modified, true);
        }
        this.log.info("### Web Resource \"" + url + "\" CREATED");
        return webResource;
    }

    private void importTopics(JSONArray topicsArray, Map<Long, Long> mapTopicIds, long topicmapId) {
        int size = topicsArray.length();
        for (int i = 0; i < size; ++i) {
            try {
                JSONObject topic = topicsArray.getJSONObject(i);
                this.createTopic(topic, mapTopicIds, topicmapId);
                continue;
            }
            catch (Exception e) {
                this.log.warning("Topic NOT imported!!" + e);
            }
        }
    }

    private void importAssociations(JSONArray assocsArray, Map<Long, Long> mapTopicIds, long topicmapId) {
        int size = assocsArray.length();
        for (int i = 0; i < size; ++i) {
            try {
                JSONObject association = assocsArray.getJSONObject(i);
                this.createAssociation(association, mapTopicIds, topicmapId);
                continue;
            }
            catch (Exception e) {
                this.log.warning("Assoc NOT imported");
            }
        }
    }

    private String color(String typeUri) {
        if (typeUri.equals("dmx.contacts.institution")) {
            return "lightblue";
        }
        if (typeUri.equals("dmx.contacts.person")) {
            return "lightblue";
        }
        if (typeUri.equals("dmx.notes.note")) {
            return "lightblue";
        }
        return "lightblue";
    }

    private String typeIconDataUri(String typeUri) throws IOException {
        TopicType topicType = this.dmx.getTopicType(typeUri);
        String iconPath = (String)topicType.getViewConfigValue("dmx.webclient.view_config", "dmx.webclient.icon");
        InputStream iconIS = null;
        try {
            int sep = iconPath.indexOf("/", 2);
            String imagePath = "web" + iconPath.substring(sep);
            iconIS = this.getStaticResource(imagePath);
            this.log.fine("##### IconIS " + iconIS);
        }
        catch (Exception e) {
            this.log.info("### FALLBACK to standard grey icon as typeIcon for \"" + typeUri + "\" icon could not be determined during SVG Export");
            iconIS = this.dmx.getPlugin("systems.dmx.webclient").getStaticResource("web/images/ball-gray.png");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int count = 0;
        while ((count = iconIS.read(buffer)) != -1) {
            baos.write(buffer, 0, count);
        }
        byte[] fileContent = baos.toByteArray();
        byte[] encoded = Base64.encode((byte[])fileContent);
        String imgBase64Str = new String(encoded);
        this.log.fine("##### IMG BASE64 " + imgBase64Str);
        return "data:image/png;base64," + imgBase64Str;
    }

    private void createTopic(JSONObject topic, Map<Long, Long> mapTopicIds, long topicmapId) throws JSONException {
        TopicModel model = this.mf.newTopicModel(topic);
        ViewProps viewProps = this.mf.newViewProps(topic.getJSONObject("view_props"));
        long origTopicId = model.getId();
        Topic newTopic = this.dmx.createTopic(model);
        long topicId = newTopic.getId();
        mapTopicIds.put(origTopicId, topicId);
        this.topicmaps.addTopicToTopicmap(topicmapId, topicId, viewProps);
    }

    private void createAssociation(JSONObject association, Map<Long, Long> mapTopicIds, long topicmapId) {
        AssocModel assocModel = this.mf.newAssocModel(association);
        PlayerModel player1 = assocModel.getPlayer1();
        PlayerModel player2 = assocModel.getPlayer2();
        Assoc newAssociation = this.dmx.createAssoc(assocModel);
        long assocId = newAssociation.getId();
        this.topicmaps.addAssocToTopicmap(topicmapId, assocId, this.mf.newViewProps(true));
    }
}

