/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.importexport;

import java.io.FileWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class SVGRenderer {
    private XMLStreamWriter svgWriter;

    public SVGRenderer(String filename) {
        try {
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            this.svgWriter = xof.createXMLStreamWriter(new FileWriter(filename));
            this.svgWriter.writeStartDocument();
            this.svgWriter.writeDTD("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20000802//EN\" \"http://www.w3.org/TR/2000/CR-SVG-20000802/DTD/svg-20000802.dtd\">");
            this.svgWriter.writeStartElement("svg");
            this.svgWriter.writeAttribute("width", "1200");
            this.svgWriter.writeAttribute("height", "1200");
            this.svgWriter.writeAttribute("xmlns", "http://www.w3.org/2000/svg");
            this.svgWriter.writeAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        }
        catch (Exception e) {
            throw new RuntimeException("Construction SVGRenderer failed", e);
        }
    }

    public void closeDocument() throws XMLStreamException {
        this.svgWriter.writeEndDocument();
        this.svgWriter.flush();
        this.svgWriter.close();
    }

    public void line(int x1, int x2, int y1, int y2) throws XMLStreamException {
        this.svgWriter.writeEmptyElement("line");
        this.svgWriter.writeAttribute("x1", Integer.toString(x1));
        this.svgWriter.writeAttribute("x2", Integer.toString(x2));
        this.svgWriter.writeAttribute("y1", Integer.toString(y1));
        this.svgWriter.writeAttribute("y2", Integer.toString(y2));
        this.svgWriter.writeAttribute("stroke", "lightgray");
        this.svgWriter.writeAttribute("stroke-width", "3");
    }

    public void rectangle(int x, int y, int width, int height, String color) throws XMLStreamException {
        this.svgWriter.writeEmptyElement("rect");
        this.svgWriter.writeAttribute("x", Integer.toString(x));
        this.svgWriter.writeAttribute("y", Integer.toString(y));
        this.svgWriter.writeAttribute("width", Integer.toString(width));
        this.svgWriter.writeAttribute("height", Integer.toString(height));
        this.svgWriter.writeAttribute("fill", color);
    }

    public void text(int x, int y, String value, String color) throws XMLStreamException {
        this.text(x, y, 0, 0, value, color, 0.0);
    }

    public void text(int x, int y, int x1, int y1, String value, String color, double alpha) throws XMLStreamException {
        this.svgWriter.writeStartElement("text");
        this.svgWriter.writeAttribute("x", Integer.toString(x));
        this.svgWriter.writeAttribute("y", Integer.toString(y));
        this.svgWriter.writeAttribute("font-size", "0.8em");
        this.svgWriter.writeAttribute("fill", color);
        this.svgWriter.writeAttribute("transform", "translate(" + x1 + "," + y1 + ") rotate(" + Double.toString(alpha) + "," + x + "," + y + ")");
        this.svgWriter.writeCharacters(value);
        this.svgWriter.writeEndElement();
    }

    public void image(int x, int y, int imgWidth, int imgHeight, String imgUri) throws XMLStreamException {
        this.svgWriter.writeEmptyElement("image");
        this.svgWriter.writeAttribute("x", Integer.toString(x));
        this.svgWriter.writeAttribute("y", Integer.toString(y));
        this.svgWriter.writeAttribute("width", Integer.toString(imgWidth));
        this.svgWriter.writeAttribute("height", Integer.toString(imgHeight));
        this.svgWriter.writeAttribute("xlink:href", imgUri);
    }

    public void startGroupElement(long elementId) throws XMLStreamException {
        this.svgWriter.writeStartElement("g");
        this.svgWriter.writeAttribute("id", "" + elementId + "");
    }

    public void endElement() throws XMLStreamException {
        this.svgWriter.writeEndElement();
    }
}

