/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.importexport;

import com.sun.jersey.core.util.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.model.TopicPlayerModel;
import systems.dmx.core.model.topicmaps.ViewAssoc;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.model.topicmaps.ViewTopic;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.SharingMode;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.files.FilesService;
import systems.dmx.files.StoredFile;
import systems.dmx.files.UploadedFile;
import systems.dmx.importexport.SVGRenderer;
import systems.dmx.topicmaps.Topicmap;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/import-export")
@Produces(value={"application/json"})
public class ImportExportPlugin
extends PluginActivator {
    @Inject
    private TopicmapsService topicmaps;
    @Inject
    private AccessControlService acl;
    @Inject
    private FilesService files;
    @Inject
    private WorkspacesService workspaces;
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private Hashtable<Long, Long> topicIds = new Hashtable();
    private Hashtable<Long, Long> assocIds = new Hashtable();
    private static final String DMX_TIME_CREATED = "dmx.timestamps.created";
    private static final String DMX_TIME_MODIFIED = "dmx.timestamps.modified";
    private static final String ZOTERO_ENTRY_TYPE_COLUMN_KEY = "Typ";
    private static final String ZOTERO_ENTRY_URL_COLUMN_KEY = "URL";
    private static final String ZOTERO_MODIFIED_AT_COLUMN_KEY = "Ge\u00e4ndert am";
    private static final String ZOTERO_ADDED_AT_COLUMN_KEY = "Hinzugef\u00fcgt am";

    @GET
    @Transactional
    @Path(value="/configured/content")
    public Topic exportConfiguredTopicTypes() {
        String jsonFileName = "dmx-import-export-configured-" + new Date().toString() + ".txt";
        ByteArrayInputStream in = null;
        try {
            this.log.info("######## Start exporting topics of all configured topic and assoc types to JSON ######### ");
            JSONObject json = new JSONObject();
            this.addWorkspaceTopicsToExport(json);
            List<RelatedTopic> configuredTypes = this.getConfiguredTopicTypesForExport();
            List<RelatedTopic> configuredAssocTypes = this.getConfiguredAssocTypesForExport();
            json.put("topics", (Object)new JSONArray());
            for (RelatedTopic type : configuredTypes) {
                this.exportTopicsAndAssocsToJSON(type.getUri(), configuredAssocTypes, json);
            }
            List topicmaps = this.dmx.getTopicsByType("dmx.topicmaps.topicmap");
            json.put("topicmaps", (Object)new JSONArray());
            for (Topic topicmap : topicmaps) {
                this.log.info("### Exporting topicmap \"" + topicmap.getSimpleValue() + "\" ...");
                this.exportTopicmapToJSON(topicmap, json);
            }
            in = new ByteArrayInputStream(json.toString().getBytes("UTF-8"));
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.files.createFile(in, this.files.pathPrefix() + "/" + jsonFileName);
    }

    private void addWorkspaceTopicsToExport(JSONObject json) {
        try {
            json.put("workspaces", (Object)new JSONArray());
            List allWorksapces = this.dmx.getTopicsByType("dmx.workspaces.workspace");
            Iterator workspaces = allWorksapces.iterator();
            this.log.info("### Exporting workspace topics ...");
            while (workspaces.hasNext()) {
                try {
                    JSONArray jsonTopics = json.getJSONArray("workspaces");
                    jsonTopics.put((Object)((Topic)workspaces.next()).toJSON());
                }
                catch (AccessControlException ex) {
                    this.log.warning("### Workspace read permission denied => " + ex.getLocalizedMessage().toString());
                }
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private List<RelatedTopic> getConfiguredTopicTypesForExport() {
        Topic plugin = this.dmx.getTopicByUri("systems.dmx.import-export");
        this.log.info("Loaded " + plugin.getSimpleValue() + " plugin topic for inspecting export type configuration");
        List configuredTypes = plugin.getRelatedTopics("dmx.core.association", "dmx.core.default", "dmx.core.default", "dmx.core.topic_type");
        return configuredTypes;
    }

    private List<RelatedTopic> getConfiguredAssocTypesForExport() {
        Topic plugin = this.dmx.getTopicByUri("systems.dmx.import-export");
        List configuredAssocTypes = plugin.getRelatedTopics("dmx.core.association", "dmx.core.default", "dmx.core.default", "dmx.core.assoc_type");
        return configuredAssocTypes;
    }

    private void exportTopicmapToJSON(Topic topicmapTopic, JSONObject json) {
        try {
            JSONArray jsonTopics = json.getJSONArray("topicmaps");
            Topicmap topicmap = this.topicmaps.getTopicmap(topicmapTopic.getId(), true);
            Topic ws = this.workspaces.getAssignedWorkspace(topicmapTopic.getId());
            ws.loadChildTopics();
            JSONObject tm = topicmap.toJSON();
            tm.put("workspace", (Object)ws.toJSON());
            jsonTopics.put((Object)tm);
        }
        catch (AccessControlException ex) {
            this.log.warning("Topicmap read permission denied => " + ex.getLocalizedMessage().toString());
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @GET
    @Transactional
    @Path(value="/content/json/{typeUri}")
    public Topic exportTopicsAndAssocsToJSON(@PathParam(value="typeUri") String typeUri, List<RelatedTopic> assocTypes, JSONObject givenJson) {
        try {
            this.log.info("### Exporting topics of type \"" + typeUri + "\" with associations ...");
            JSONObject json = givenJson != null ? givenJson : new JSONObject();
            List allTopics = this.dmx.getTopicsByType(typeUri);
            Iterator topics = allTopics.iterator();
            while (topics.hasNext()) {
                try {
                    JSONArray jsonTopics = json.getJSONArray("topics");
                    JSONObject topic = this.createTopicWithAssociationsJSON((Topic)topics.next(), assocTypes);
                    if (topic == null) continue;
                    jsonTopics.put((Object)topic);
                }
                catch (AccessControlException ex) {
                    this.log.warning("### Topic read permission denied => " + ex.getLocalizedMessage().toString());
                }
            }
            if (givenJson == null) {
                ByteArrayInputStream in = new ByteArrayInputStream(json.toString().getBytes("UTF-8"));
                String jsonFileName = "dmx-" + typeUri + "-topics-" + new Date().toString() + ".txt";
                return this.files.createFile((InputStream)in, this.files.pathPrefix() + "/" + jsonFileName);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating Topics and Associations JSON Export failed", e);
        }
    }

    private JSONObject createTopicWithAssociationsJSON(Topic topic, List<RelatedTopic> assocTypes) throws JSONException {
        topic.loadChildTopics();
        ArrayList<DMXObject> assocs = new ArrayList<DMXObject>();
        for (RelatedTopic assocType : assocTypes) {
            List relatedTopics = topic.getRelatedTopics(assocType.getUri(), null, null, null);
            for (RelatedTopic relatedTopic : relatedTopics) {
                assocs.add(relatedTopic.getRelatingAssoc().loadChildTopics());
            }
        }
        return new JSONObject().put("topic", (Object)topic.toJSON()).put("associations", (Object)DMXUtils.toJSONArray(assocs));
    }

    @POST
    @Path(value="/import/{htmlOrJson}")
    @Consumes(value={"multipart/form-data"})
    @Transactional
    public Topic uploadFile(UploadedFile file, @PathParam(value="htmlOrJson") String htmlOrJson) {
        String operation = "Uploaded File " + file + " for importing " + htmlOrJson.toUpperCase();
        try {
            this.log.info(operation);
            StoredFile storedFile = this.files.storeFile(file, "/");
            return this.dmx.getTopic(storedFile.getFileTopicId());
        }
        catch (Exception e) {
            throw new RuntimeException(operation + " failed", e);
        }
    }

    @GET
    @Path(value="/import/file/{fileTopidId}")
    @Transactional
    public Response importContentsBackupJson(@PathParam(value="fileTopidId") long fileTopicId) {
        try {
            this.log.info("FileTopicID to be imported: " + fileTopicId);
            String content = this.getFileContentsAsString(fileTopicId);
            JSONObject dump = new JSONObject(content);
            this.log.info("File Topic " + fileTopicId + " contents read in and parsed as JSON");
            JSONArray objects = dump.getJSONArray("topics");
            this.createTopicsFromDM4JSON(objects);
            this.createAssociationsFromDM4JSON(objects);
            this.log.info("#### Part 1/2 of import operation - Topics an Associations - finished #### ");
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Response.ok((Object)fileTopicId).build();
    }

    @GET
    @Path(value="/import/file/{fileTopidId}/topicmaps")
    @Transactional
    public Response importTopicmapsBackupJson(@PathParam(value="fileTopidId") long fileTopicId) {
        try {
            this.log.info("FileTopicID to be imported: " + fileTopicId);
            String content = this.getFileContentsAsString(fileTopicId);
            JSONObject dump = new JSONObject(content);
            this.log.info("File Topic " + fileTopicId + " contents read in and parsed as JSON");
            JSONArray maps = dump.getJSONArray("topicmaps");
            for (int k = 0; k < maps.length(); ++k) {
                try {
                    JSONObject topicmap = maps.getJSONObject(k);
                    Topic map = this.createTopicmapFromJSON(topicmap);
                    JSONArray assocs = topicmap.getJSONArray("assocs");
                    JSONArray topics = topicmap.getJSONArray("topics");
                    JSONObject workspace = topicmap.getJSONObject("workspace");
                    Topic ws = this.getOrCreateWorkspace(workspace);
                    this.log.info("Topicmap is imported into workspace => " + ws.getSimpleValue());
                    this.workspaces.assignToWorkspace((DMXObject)map, ws.getId());
                    this.log.info("Topicmap contains " + topics.length() + " topics & " + assocs.length() + " associations");
                    this.log.info("Adding topics into topicmap ...");
                    this.addTopicsToTopicmapFromJSON(topics, map);
                    this.log.info("Adding assocs into topicmap ...");
                    this.addAssocsToTopicmapFromJSON(assocs, map);
                    continue;
                }
                catch (JSONException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.log.info("#### Part 2/2 of import operation - Topicmaps - finished ####");
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        return Response.ok((Object)fileTopicId).build();
    }

    private Topic getOrCreateWorkspace(JSONObject workspace) {
        Topic ws;
        block11: {
            ws = null;
            try {
                String wsName = workspace.getString("value");
                ws = this.dmx.getTopicByValue("dmx.workspaces.name", new SimpleValue(wsName));
                if (ws == null) {
                    List existingWs = this.dmx.getTopicsByType("dmx.workspaces.workspace");
                    for (Topic topic : existingWs) {
                        if (!topic.getSimpleValue().toString().equals(wsName)) continue;
                        return topic;
                    }
                    JSONObject childs = workspace.getJSONObject("childs");
                    JSONObject sharingMode = childs.getJSONObject("dm4.workspaces.sharing_mode");
                    String wsSharing = sharingMode.getString("value");
                    if (wsSharing.equals("Public")) {
                        ws = this.workspaces.createWorkspace(wsName, null, SharingMode.PUBLIC);
                    } else if (wsSharing.equals("Collaborative")) {
                        ws = this.workspaces.createWorkspace(wsName, null, SharingMode.COLLABORATIVE);
                    } else if (wsSharing.equals("Confidential")) {
                        ws = this.workspaces.createWorkspace(wsName, null, SharingMode.CONFIDENTIAL);
                    } else if (wsSharing.equals("Common")) {
                        ws = this.workspaces.createWorkspace(wsName, null, SharingMode.COMMON);
                    }
                    break block11;
                }
                RelatedTopic realWs = ws.getRelatedTopic(null, "dmx.core.child", "dmx.core.parent", "dmx.workspaces.workspace");
                this.log.info("Workspace exists already - " + realWs.toJSON());
                return realWs;
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
        return ws;
    }

    private String getFileContentsAsString(long fileTopicId) {
        File export = this.files.getFile(fileTopicId);
        StringBuilder content = new StringBuilder();
        try {
            FileReader fileReader = new FileReader(export.getAbsolutePath());
            BufferedReader reader = new BufferedReader(fileReader);
            String line = null;
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        return content.toString();
    }

    private void createTopicsFromDM4JSON(JSONArray topics) {
        try {
            for (int i = 0; i < topics.length(); ++i) {
                JSONObject object = topics.getJSONObject(i);
                JSONObject topic = object.getJSONObject("topic");
                long formerId = topic.getLong("id");
                String topicJSON = this.buildDMXJSONTopicModel(topic);
                try {
                    Topic newTopic = this.dmx.createTopic(this.mf.newTopicModel(new JSONObject(topicJSON)));
                    this.log.info("### Imported \"" + newTopic.getType().getUri() + "\" topic \"" + newTopic.getSimpleValue() + "\" (" + newTopic.getId() + ")");
                    this.topicIds.put(formerId, newTopic.getId());
                    continue;
                }
                catch (RuntimeException re) {
                    Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, "Topic " + formerId + " (" + object.getJSONObject("topic") + ") could not be created from DM4 JSON", re);
                }
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void createAssociationsFromDM4JSON(JSONArray topics) {
        for (int k = 0; k < topics.length(); ++k) {
            try {
                JSONObject topic = topics.getJSONObject(k);
                JSONArray associations = topic.getJSONArray("associations");
                for (int m = 0; m < associations.length(); ++m) {
                    JSONObject assoc = associations.getJSONObject(m);
                    String assocTypeUri = this.buildDMXJSONAssocTypeUri(assoc.getString("type_uri"));
                    long formerId = assoc.getLong("id");
                    JSONObject assocChilds = assoc.getJSONObject("childs");
                    String assocChildsJSON = this.buildDMXJSONTopicModel(assocChilds);
                    long formerPlayer1 = 0L;
                    long formerPlayer2 = 0L;
                    try {
                        JSONObject role1 = assoc.getJSONObject("role_1");
                        JSONObject role2 = assoc.getJSONObject("role_2");
                        formerPlayer1 = role1.getLong("topic_id");
                        formerPlayer2 = role2.getLong("topic_id");
                        long newPlayer1Id = this.topicIds.get(formerPlayer1);
                        long newPlayer2Id = this.topicIds.get(formerPlayer2);
                        String newRoleType1 = role1.getString("role_type_uri").replace("dm4", "dmx");
                        String newRoleType2 = role2.getString("role_type_uri").replace("dm4", "dmx");
                        try {
                            Assoc exists = this.dmx.getAssocBetweenTopicAndTopic(assocTypeUri, newPlayer1Id, newPlayer2Id, newRoleType1, newRoleType2);
                            Assoc newAssoc = null;
                            if (exists == null) {
                                TopicPlayerModel player1 = this.mf.newTopicPlayerModel(newPlayer1Id, newRoleType1);
                                TopicPlayerModel player2 = this.mf.newTopicPlayerModel(newPlayer2Id, newRoleType2);
                                ChildTopicsModel assocModel = this.mf.newChildTopicsModel(new JSONObject(assocChildsJSON));
                                try {
                                    newAssoc = this.dmx.createAssoc(this.mf.newAssocModel(assocTypeUri, (PlayerModel)player1, (PlayerModel)player2, assocModel));
                                    this.assocIds.put(formerId, newAssoc.getId());
                                    this.log.info("### Imported " + newAssoc.getType().getUri() + " Association with label " + newAssoc.getSimpleValue());
                                }
                                catch (RuntimeException re) {
                                    this.log.warning("> Association " + newAssoc + " could not be imported caused by \"" + re.getCause().getMessage() + "\"");
                                }
                                continue;
                            }
                            this.log.info("> Association of type \"" + assocTypeUri + "\" was not created since it already exists");
                        }
                        catch (RuntimeException rea) {
                            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, "Assoc existence check could not fetch assoc", rea);
                        }
                        continue;
                    }
                    catch (NullPointerException npe) {
                        this.log.warning("> Player information is not contained in export file " + npe);
                        this.log.warning(">> Association could not be imported, formerTopic1 " + formerPlayer1 + ", formerTopic2 " + formerPlayer2);
                    }
                }
                continue;
            }
            catch (JSONException ex) {
                Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private Topic createTopicmapFromJSON(JSONObject topicmap) {
        try {
            JSONObject state = topicmap.getJSONObject("topic");
            JSONObject stateChilds = state.getJSONObject("children");
            JSONObject translation = stateChilds.getJSONObject("dmx.topicmaps.state");
            String translationValuePair = translation.getString("value");
            String[] pos = translationValuePair.split(" ");
            Topic map = this.topicmaps.createTopicmap(state.getString("value"), "dmx.topicmaps.topicmap", this.mf.newViewProps(Integer.parseInt(pos[0]), Integer.parseInt(pos[1])));
            this.log.info("### Imported Topicmap " + state.getString("value") + "... new Topicmap ID => " + map.getId());
            this.log.info("Topicmap Translation Set: " + translationValuePair.toString() + " Position X: " + Integer.parseInt(pos[0]) + " Position Y: " + Integer.parseInt(pos[1]));
            return map;
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void addTopicsToTopicmapFromJSON(JSONArray topics, Topic map) {
        for (int t = 0; t < topics.length(); ++t) {
            JSONObject topic = null;
            try {
                topic = topics.getJSONObject(t);
                long formerTopicId = topic.getLong("id");
                String typeUri = topic.getString("type_uri");
                JSONObject viewProps = topic.getJSONObject("view_props");
                int posX = viewProps.getInt("dm4.topicmaps.x");
                int posY = viewProps.getInt("dm4.topicmaps.y");
                boolean visibility = viewProps.getBoolean("dm4.topicmaps.visibility");
                try {
                    long newTopicId = this.topicIds.get(formerTopicId);
                    this.topicmaps.addTopicToTopicmap(map.getId(), newTopicId, this.mf.newViewProps(posX, posY, visibility, false));
                    this.log.fine("Added topic " + topic.getString("value") + " to topicmap " + map.getSimpleValue());
                }
                catch (Exception e) {
                    this.log.warning("> Error adding " + formerTopicId + " (\"" + typeUri + "\") was not contained in export file " + e + " - Skipping...");
                }
                continue;
            }
            catch (JSONException ex) {
                this.log.severe("> Problem inspecting topic " + topic + " to add to topicmap " + map + " caused by " + ex.getCause().getMessage());
            }
        }
    }

    private void addAssocsToTopicmapFromJSON(JSONArray assocs, Topic map) {
        for (int t = 0; t < assocs.length(); ++t) {
            try {
                JSONObject assoc = assocs.getJSONObject(t);
                try {
                    long formerAssocId = assoc.getLong("id");
                    this.topicmaps.addAssocToTopicmap(map.getId(), this.assocIds.get(formerAssocId).longValue(), this.mf.newViewProps(true, false));
                }
                catch (NullPointerException npe) {
                    this.log.warning("> Assoc of type ##### was not contained in export file " + npe + " - Skipped adding to Topicmap");
                }
                continue;
            }
            catch (JSONException ex) {
                Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private String buildDMXJSONTopicModel(JSONObject topic) {
        String topicJSON = topic.toString();
        topicJSON = topicJSON.replaceAll("dm4", "dmx");
        topicJSON = topicJSON.replaceAll("childs", "children");
        topicJSON = topicJSON.replaceAll("type_uri", "typeUri");
        topicJSON = topicJSON.replaceAll("\"id\":[0-9]{1,10},", "\"id\":-1,");
        topicJSON = topicJSON.replaceAll("\"topic_id\":[0-9]{1,10},", "\"topic_id\":-1,");
        topicJSON = topicJSON.replaceAll("dmx.core.aggregation", "dmx.core.composition");
        topicJSON = topicJSON.replaceAll("dmx.contacts.institution", "dmx.contacts.organization");
        topicJSON = topicJSON.replaceAll("dmx.webbrowser.web_resource", "dmx.bookmarks.bookmark");
        topicJSON = topicJSON.replaceAll("dmx.webbrowser.url", "dmx.base.url");
        topicJSON = topicJSON.replaceAll("dmx.webbrowser.web_resource_description", "dmx.bookmarks.description");
        topicJSON = topicJSON.replaceAll("dmx.events.to", "dmx.datetime.to");
        topicJSON = topicJSON.replaceAll("dmx.events.from", "dmx.datetime.from");
        topicJSON = topicJSON.replaceAll("dmx.events.title", "dmx.events.event_name");
        topicJSON = topicJSON.replaceAll("dmx.events.notes", "dmx.events.event_description");
        return topicJSON;
    }

    private String buildDMXJSONAssocTypeUri(String assoc) {
        String assocJSON = assoc.toString();
        assocJSON = assocJSON.replaceAll("dm4", "dmx");
        assocJSON = assocJSON.replaceAll("dmx.events.participant", "dmx.events.event_involvement");
        assocJSON = assocJSON.replaceAll("dmx.contacts.organization_association", "dmx.contacts.organization_involvement");
        return assocJSON;
    }

    @POST
    @Transactional
    @Path(value="/topicmap/export/json")
    public Topic exportTopicmapToJSON(@CookieParam(value="dmx_topicmap_id") long topicmapId) {
        try {
            this.log.info("Exporting Topicmap JSON ######### " + topicmapId);
            Topicmap topicmap = this.topicmaps.getTopicmap(topicmapId, true);
            String json = topicmap.toJSON().toString();
            ByteArrayInputStream in = new ByteArrayInputStream(json.getBytes("UTF-8"));
            String jsonFileName = "topicmap-" + topicmapId + ".json";
            return this.files.createFile((InputStream)in, this.files.pathPrefix() + "/" + jsonFileName);
        }
        catch (Exception e) {
            throw new RuntimeException("Export failed", e);
        }
    }

    @POST
    @Path(value="/topicmap/export/svg")
    @Transactional
    public Topic exportTopicmapToSVG(@CookieParam(value="dmx_topicmap_id") long topicmapId) throws XMLStreamException {
        int BOX_HEIGHT = 20;
        int MARGIN_LEFT = 5;
        int MARGIN_TOP = 14;
        int ICON_WIDTH = 16;
        int ICON_HEIGHT = 16;
        try {
            this.log.info("Exporting Topicmap SVG ######### " + topicmapId);
            Topicmap topicmap = this.topicmaps.getTopicmap(topicmapId, true);
            Iterable topics = topicmap.getTopics();
            Iterable associations = topicmap.getAssocs();
            String svgFileName = "Exported_Topicmap_" + topicmapId + ".svg";
            String documentPath = this.files.getFile("/") + "/" + svgFileName;
            SVGRenderer svg = new SVGRenderer(documentPath);
            svg.startGroupElement(topicmapId);
            for (ViewAssoc association : associations) {
                String valueAssoc = association.getSimpleValue().toString();
                long topic1Id = association.getPlayer1().getId();
                long topic2Id = association.getPlayer2().getId();
                ViewTopic topic1 = topicmap.getTopic(topic1Id);
                int x1 = topic1.getX();
                int y1 = topic1.getY();
                ViewTopic topic2 = topicmap.getTopic(topic2Id);
                int x2 = topic2.getX();
                int y2 = topic2.getY();
                int dx = x2 - x1;
                int dy = y2 - y1;
                int label_x = dx / 2;
                int label_y = dy / 2;
                double assocLine = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                double alpha = Math.asin((double)dy / assocLine) * 180.0 / Math.PI;
                if (dx < 0) {
                    alpha = -alpha;
                }
                svg.startGroupElement(association.getId());
                svg.line(x1, x2, y1, y2);
                svg.text(label_x, label_y, x1 + 10, y1 + 10, valueAssoc, "grey", alpha);
                svg.endElement();
            }
            for (ViewTopic topic : topics) {
                String value = topic.getSimpleValue().toString();
                int x = topic.getX();
                int y = topic.getY();
                boolean visibility = topic.getVisibility();
                int boxWidth = value.length() * 9;
                if (!visibility) continue;
                svg.startGroupElement(topic.getId());
                svg.rectangle(x - boxWidth / 2, y - 10, boxWidth, 20, this.color(topic.getTypeUri()));
                svg.text(x - boxWidth / 2 + 5, y - 10 + 14, value, "black");
                svg.endElement();
            }
            svg.endElement();
            svg.closeDocument();
            return this.files.getFileTopic(this.files.pathPrefix() + "/" + svgFileName);
        }
        catch (Exception e) {
            throw new RuntimeException("Export Topicmap to SVG failed", e);
        }
    }

    @POST
    @Path(value="/import/topicmap")
    @Transactional
    @Consumes(value={"multipart/form-data"})
    public String importTopicmap(UploadedFile file) {
        try {
            String json = file.getString();
            JSONObject topicmap = new JSONObject(json);
            JSONObject info = topicmap.getJSONObject("topic");
            JSONArray assocsArray = topicmap.getJSONArray("assocs");
            JSONArray topicsArray = topicmap.getJSONArray("topics");
            String origTopicmapName = info.getString("value");
            Topic importedTopicmap = this.topicmaps.createTopicmap("Imported: " + origTopicmapName, "dmx.topicmaps.topicmap", null);
            long topicmapId = importedTopicmap.getId();
            this.log.info("###### importedTopicmapId " + topicmapId);
            HashMap<Long, Long> mapTopicIds = new HashMap<Long, Long>();
            this.importTopics(topicsArray, mapTopicIds, topicmapId);
            this.importAssociations(assocsArray, mapTopicIds, topicmapId);
            return "{\"message\": \"Topicmap successfully restored. \", \"topic_id\": " + importedTopicmap.getId() + "}";
        }
        catch (Exception e) {
            throw new RuntimeException("Importing Topicmap FAILED", e);
        }
    }

    @POST
    @Path(value="/import/bookmarks/firefox")
    @Transactional
    @Consumes(value={"multipart/form-data"})
    public String importFirefoxBookmarks(UploadedFile file) {
        try {
            String json = file.getString("UTF-8");
            JSONObject fileContent = new JSONObject(json);
            JSONArray firstChildren = fileContent.getJSONArray("children");
            this.log.info("###### Starting to map Firefox Bookmark Backup Entries to DMX Bookmarks ######");
            Topic importedNote = this.createNoteImportTopic(file.getName());
            int webResourcesCreatedCount = 0;
            for (int i = 0; i < firstChildren.length(); ++i) {
                JSONObject entry = firstChildren.getJSONObject(i);
                if (!entry.has("children")) continue;
                JSONArray entryChilds = entry.getJSONArray("children");
                for (int k = 0; k < entryChilds.length(); ++k) {
                    JSONObject childEntry = entryChilds.getJSONObject(k);
                    Topic webResource = this.transformMozillaBookmarkEntry(childEntry, importedNote, null, 0);
                    if (webResource == null) continue;
                    ++webResourcesCreatedCount;
                }
            }
            this.log.info("#### Mapping Firefox Bookmarks Backup COMPLETE: Created " + webResourcesCreatedCount + " new web resources ####");
            return "{\"message\": \"All valid entries contained in the Firefox backup file were imported as Bookmarks.\", \"topic_id\": " + importedNote.getId() + "}";
        }
        catch (Exception e) {
            throw new RuntimeException("Importing Bookmarks from Firefox Bookmarks Backup FAILED", e);
        }
    }

    @POST
    @Path(value="/import/bookmarks/chromium")
    @Transactional
    @Consumes(value={"multipart/form-data"})
    public String importChromiumBookmarks(UploadedFile file) {
        try {
            String htmlString = file.getString("UTF-8");
            Document doc = Jsoup.parse((String)htmlString);
            Elements folderNames = doc.getElementsByTag("dt");
            this.log.info("###### Starting to map Chromium Bookmark HTML Export to DMX Bookmarks ######");
            Topic importedNote = this.createNoteImportTopic(file.getName());
            this.log.info("### Iterating " + folderNames.size() + " chromium bookmark entries (flattened).");
            if (folderNames.size() > 0) {
                Element dummyEntry = (Element)folderNames.get(0);
                Elements nodes = dummyEntry.children();
                for (Element element : nodes) {
                    this.transformChromiumResourceEntry(importedNote, element, null);
                }
            }
            this.log.info("#### Mapping Chromium Bookmarks Backup to Bookmarks COMPLETED ####");
            return "{\"message\": \"All valid entries contained in the Chromium backup file were turned imported as Bookmarks.\", \"topic_id\": " + importedNote.getId() + "}";
        }
        catch (Exception e) {
            throw new RuntimeException("Importing Bookmarks from Chromium Bookmarks file FAILED", e);
        }
    }

    @POST
    @Path(value="/import/bookmarks/zotero-report")
    @Transactional
    @Consumes(value={"multipart/form-data"})
    public String importZoteroReportBookmarks(UploadedFile file) {
        try {
            String htmlString = file.getString("UTF-8");
            Document doc = Jsoup.parse((String)htmlString);
            Elements webpages = doc.getElementsByClass("webpage");
            this.log.info("###### Starting to map Zotero Report Bookmarks to DMX Bookmarks ######");
            Topic importedNote = this.createNoteImportTopic(file.getName());
            this.log.info("### Iterating " + webpages.size() + " webpages in zotero report.");
            for (Element webpage : webpages) {
                this.transformZoteroWebpageEntry(importedNote, webpage);
            }
            this.log.info("#### Mapping Zotero Report Bookmarks to Bookmarks COMPLETED ####");
            return "{\"message\": \"All valid webpage entries in the zotero report file were imported as Bookmarks.\", \"topic_id\": " + importedNote.getId() + "}";
        }
        catch (Exception e) {
            throw new RuntimeException("Importing Bookmarks from Zotero Report Bookmarks file FAILED", e);
        }
    }

    private Topic transformMozillaBookmarkEntry(JSONObject childEntry, Topic importedNote, Topic folderNameTag, int levelCount) {
        Topic webResource = null;
        int recursionCount = levelCount;
        try {
            String entryType = childEntry.getString("type");
            if (entryType.equals("text/x-moz-place")) {
                if (childEntry.has("title") && childEntry.has("uri")) {
                    webResource = this.transformFirefoxResourceEntry(childEntry);
                    if (webResource != null) {
                        this.createBookmarkRelations(importedNote, webResource, folderNameTag);
                    } else {
                        this.log.warning("Bookmark Entry could not be created with JSONObject: " + childEntry.toString());
                    }
                } else {
                    this.log.warning("Skipping Bookmark entry due to missing Title or URL, " + childEntry.toString());
                }
            } else if (entryType.equals("text/x-moz-place-container")) {
                this.log.warning("Bookmarking Container Detected - Mapping Bookmarker Folders to Tags...");
                String folderName = childEntry.getString("title");
                Topic folderTopic = this.createTagTopic(folderName);
                if (folderNameTag != null) {
                    this.getOrCreateSimpleAssoc(folderNameTag, folderTopic);
                }
                if (childEntry.has("children")) {
                    JSONArray entryChildsChilds = childEntry.getJSONArray("children");
                    this.log.info("  " + recursionCount + "ndLevel Bookmark Folder " + folderName + " - TODO: Transform \"" + folderName + "\" into TAG");
                    for (int m = 0; m < entryChildsChilds.length(); ++m) {
                        JSONObject childChildEntry = entryChildsChilds.getJSONObject(m);
                        this.transformMozillaBookmarkEntry(childChildEntry, importedNote, folderTopic, ++recursionCount);
                    }
                }
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        return webResource;
    }

    private Topic createTagTopic(String tagName) {
        return this.dmx.createTopic(this.mf.newTopicModel("dmx.tags.tag", this.mf.newChildTopicsModel().set("dmx.tags.tag_name", (Object)tagName)));
    }

    private Topic transformFirefoxResourceEntry(JSONObject childEntry) {
        try {
            String bookmarkDescription = childEntry.getString("title");
            String bookmarkUrl = childEntry.getString("uri");
            long dateAdded = 0L;
            if (bookmarkUrl.startsWith("place:") || bookmarkUrl.startsWith("chrome:") || bookmarkUrl.startsWith("about:")) {
                return null;
            }
            if (childEntry.has("dateAdded")) {
                dateAdded = childEntry.getLong("dateAdded");
                dateAdded = new Date(dateAdded / 1000L).getTime();
            } else {
                this.log.warning("Could not detect " + bookmarkDescription + " dateAdded timestamp, setting it NOW, DEBUG: " + childEntry.toString());
            }
            long lastModified = 0L;
            if (childEntry.has("lastModified")) {
                childEntry.getLong("lastModified");
                lastModified = new Date(lastModified / 1000L).getTime();
            } else {
                this.log.warning("Could not detect " + bookmarkDescription + " lastModified timestamp, setting it NOW, DEBUG: " + childEntry.toString());
            }
            this.log.info("### Processing firefox link entry  \"" + bookmarkUrl + "\", Added: " + new Date(dateAdded).toLocaleString() + ", Modified: " + new Date(lastModified).toLocaleString());
            return this.getOrCreateWebResource(bookmarkUrl, bookmarkDescription, dateAdded, lastModified);
        }
        catch (JSONException ex) {
            Logger.getLogger(ImportExportPlugin.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private Topic getTagTopic(String name) {
        Topic tagName = this.dmx.getTopicByValue("dmx.tags.tag_name", new SimpleValue(name));
        return this.getTagTopic(tagName);
    }

    private Topic getTagTopic(Topic name) {
        return name != null ? name.getRelatedTopic(null, "dmx.core.child", "dmx.core.parent", "dmx.tags.tag") : null;
    }

    private void transformChromiumResourceEntry(Topic importedNote, Element element, Topic toBeRelated) {
        if (element.nodeName().equals("a")) {
            String linkHref = element.attr("href");
            String linkName = element.text();
            String linkAddedValue = element.attr("add_date");
            String linkModifiedValue = element.attr("last_modified");
            long linkAdded = 0L;
            long linkModified = 0L;
            Date customDateAdded = new Date();
            Date customDateModified = new Date();
            if (!linkAddedValue.isEmpty()) {
                linkAdded = Long.parseLong(linkAddedValue) * 1000L;
                customDateAdded = new Date(linkAdded);
            }
            if (!linkModifiedValue.isEmpty()) {
                this.log.info("Chromium linkedModified => " + linkModifiedValue);
                linkModified = Long.parseLong(linkModifiedValue) * 1000L;
                customDateModified = new Date(linkModifiedValue);
            }
            this.log.info("### Processing chromium link entry  \"" + linkName + "\" (" + linkHref + "), Added: " + customDateAdded.toLocaleString() + " (value=" + linkAddedValue + "), Modified: " + customDateModified.toLocaleString() + "(value=" + linkModifiedValue + ")");
            Topic webResource = this.getOrCreateWebResource(linkHref, linkName, customDateAdded.getTime(), customDateModified.getTime());
            this.createBookmarkRelations(importedNote, webResource, toBeRelated);
        } else if (element.nodeName().equals("h3")) {
            String text = element.ownText().trim();
            long folderAdded = Long.parseLong(element.attr("add_date"));
            String linkModifiedValue = element.attr("last_modified");
            long folderModified = new Date().getTime();
            if (!linkModifiedValue.isEmpty()) {
                folderModified = Long.parseLong(linkModifiedValue);
            }
            this.log.info("### Processing chromium bookmark folder element named \"" + text + "\"");
            Topic tag = this.getTagTopic(text);
            if (tag == null) {
                tag = this.createTagTopic(text);
                tag.setProperty(DMX_TIME_CREATED, (Object)folderAdded, true);
                if (folderModified != 0L) {
                    tag.setProperty(DMX_TIME_MODIFIED, (Object)folderModified, true);
                }
                this.log.info("NEW tag \"" + text + "\" created during import");
            }
            if (toBeRelated != null) {
                this.getOrCreateSimpleAssoc(toBeRelated, tag);
            }
            if (importedNote != null && tag != null) {
                this.getOrCreateSimpleAssoc(importedNote, tag);
            }
            this.transformChromiumResourceEntry(importedNote, element.nextElementSibling(), tag);
        } else if (element.nodeName().equals("dt") || element.nodeName().equals("dl")) {
            Elements childNodes = element.children();
            this.log.info("### Processing chromium list element with name " + element.nodeName() + " and " + childNodes.size() + " childs");
            for (Element childNode : childNodes) {
                this.transformChromiumResourceEntry(importedNote, childNode, toBeRelated);
            }
        }
    }

    private Topic transformZoteroWebpageEntry(Topic importedNote, Element listItem) {
        Object webpageTitle = null;
        String webpageUrl = null;
        String entryType = null;
        long bookmarkCreated = new Date().getTime();
        long bookmarkModified = new Date().getTime();
        Topic webpage = null;
        Elements childs = listItem.children();
        for (Element element : childs) {
            Object text;
            if (!element.nodeName().equals("h2")) continue;
            webpageTitle = text = element.ownText().trim();
            this.log.info("### Processed zotero report webpage title \"" + (String)text + "\"");
        }
        ArrayList<String> bookmarkTags = new ArrayList<String>();
        Elements tagElements = listItem.getElementsByClass("tags");
        for (Element tagElement : tagElements) {
            if (!tagElement.nodeName().equals("ul")) continue;
            Elements tagEntries = tagElement.getElementsByTag("li");
            for (Element tagEntry : tagEntries) {
                bookmarkTags.add(tagEntry.ownText().trim());
            }
        }
        Elements attributes = listItem.getElementsByTag("tr");
        for (Element attribute : attributes) {
            String entryModified;
            Element keyCell = attribute.child(0);
            Element valueCell = attribute.child(1);
            String keyOne = keyCell.ownText().trim();
            if (keyOne.equals(ZOTERO_ENTRY_URL_COLUMN_KEY)) {
                Elements ahrefs = valueCell.getElementsByTag("a");
                if (ahrefs.size() <= 0) continue;
                webpageUrl = ((Element)ahrefs.get(0)).attr("href");
                this.log.fine("### Parsed zotero report webpage URL: " + webpageUrl);
                continue;
            }
            if (keyOne.equals(ZOTERO_ENTRY_TYPE_COLUMN_KEY)) {
                entryType = valueCell.ownText();
                continue;
            }
            if (keyOne.equals(ZOTERO_ADDED_AT_COLUMN_KEY)) {
                String entryAdded = valueCell.ownText();
                if (entryAdded.isEmpty()) continue;
                try {
                    new Date();
                    bookmarkCreated = Date.parse(entryAdded);
                }
                catch (IllegalArgumentException iex) {
                    this.log.warning("Could not parse date of bookmark created \"" + entryAdded + "\", cause " + iex.getMessage());
                }
                continue;
            }
            if (!keyOne.equals(ZOTERO_MODIFIED_AT_COLUMN_KEY) || (entryModified = valueCell.ownText()).isEmpty()) continue;
            try {
                new Date();
                bookmarkModified = Date.parse(entryModified);
            }
            catch (IllegalArgumentException iex) {
                this.log.warning("Could not parse date of bookmark last modified \"" + entryModified + "\", cause " + iex.getMessage());
            }
        }
        if (webpageUrl != null) {
            webpage = this.getOrCreateWebResource(webpageUrl, (String)webpageTitle + "<br/>" + entryType, bookmarkCreated, bookmarkModified);
            if (bookmarkTags.size() > 0) {
                this.log.fine("### Importing " + bookmarkTags + " as tags for this webpage from zotero report");
            }
            for (String tagValue : bookmarkTags) {
                Topic tag = this.getTagTopic(tagValue);
                if (tag == null) {
                    tag = this.createTagTopic(tagValue);
                    this.log.info("NEW tag \"" + tagValue + "\" created during import");
                }
                if (tag == null) continue;
                this.createBookmarkRelations(importedNote, webpage, tag);
            }
        }
        return webpage;
    }

    private Topic createNoteImportTopic(String fileName) {
        ChildTopicsModel childValues = this.mf.newChildTopicsModel();
        childValues.set("dmx.notes.title", (Object)("Bookmarks Import, " + fileName + " by " + this.acl.getUsername()));
        childValues.set("dmx.notes.text", (Object)("This note relates all bookmarks created through an import process done by " + this.acl.getUsername() + " (" + fileName + "). Please do not delete this note as it might become helpful if you need to identify which bookmarks where imported when, by whom using which file."));
        Topic importerNote = this.dmx.createTopic(this.mf.newTopicModel("dmx.notes.note", childValues));
        this.log.info("### Importer Note Topic for \"" + fileName + "\" CREATED");
        return importerNote;
    }

    private Assoc createBookmarkRelations(Topic importerNote, Topic webResource, Topic folderNameTag) {
        Assoc importedAssoc = null;
        if (importerNote != null && (importedAssoc = this.dmx.getAssocBetweenTopicAndTopic("dmx.core.association", importerNote.getId(), webResource.getId(), "dmx.core.default", "dmx.core.default")) == null) {
            importedAssoc = this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(importerNote.getId(), "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(webResource.getId(), "dmx.core.default")));
        }
        if (folderNameTag != null) {
            this.getOrCreateSimpleAssoc(folderNameTag, webResource);
        }
        return importedAssoc;
    }

    private Assoc getOrCreateSimpleAssoc(Topic defaultPlayer1, Topic defaultPlayer2) {
        Assoc folderTagAssoc = this.dmx.getAssocBetweenTopicAndTopic("dmx.core.association", defaultPlayer1.getId(), defaultPlayer2.getId(), "dmx.core.parent", "dmx.core.child");
        if (folderTagAssoc == null) {
            folderTagAssoc = this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(defaultPlayer1.getId(), "dmx.core.parent"), (PlayerModel)this.mf.newTopicPlayerModel(defaultPlayer2.getId(), "dmx.core.child")));
            this.log.info("NEW relation from \"" + defaultPlayer1.getTypeUri() + "\" created to \"" + defaultPlayer2.getTypeUri() + "\"");
        }
        return folderTagAssoc;
    }

    private Topic getOrCreateWebResource(String url, String description, long created, long modified) {
        Topic webResource;
        try {
            webResource = this.dmx.getTopicByValue("dmx.base.url", new SimpleValue(url.trim()));
            if (webResource != null) {
                this.log.info("### Bookmark \"" + url + "\" EXISTS - NOT UPDATED");
                RelatedTopic webRsrcParent = webResource.getRelatedTopic("dmx.core.composition", "dmx.core.child", "dmx.core.parent", "dmx.bookmarks.bookmark");
                return webRsrcParent != null ? webRsrcParent : webResource;
            }
        }
        catch (RuntimeException re) {
            this.log.warning("Bookmark could not be created, either due to an access control issue or a messed up lucene KEY index (allowing web resources to exists just once in a DB), caused by: " + re.getLocalizedMessage());
        }
        ChildTopicsModel childValues = this.mf.newChildTopicsModel();
        childValues.set("dmx.base.url", (Object)url.trim());
        childValues.set("dmx.bookmarks.description", (Object)description);
        webResource = this.dmx.createTopic(this.mf.newTopicModel("dmx.bookmarks.bookmark", childValues));
        if (created != 0L) {
            webResource.setProperty(DMX_TIME_CREATED, (Object)created, true);
        }
        if (modified != 0L) {
            webResource.setProperty(DMX_TIME_MODIFIED, (Object)modified, true);
        }
        this.log.info("### Bookmark \"" + url + "\" CREATED");
        return webResource;
    }

    private void importTopics(JSONArray topicsArray, Map<Long, Long> mapTopicIds, long topicmapId) {
        int size = topicsArray.length();
        for (int i = 0; i < size; ++i) {
            try {
                JSONObject topic = topicsArray.getJSONObject(i);
                this.createTopic(topic, mapTopicIds, topicmapId);
                continue;
            }
            catch (Exception e) {
                this.log.warning("Topic NOT imported, caused by \"" + e.getCause().getLocalizedMessage().toString() + "\"");
            }
        }
    }

    private void importAssociations(JSONArray assocsArray, Map<Long, Long> mapTopicIds, long topicmapId) {
        int size = assocsArray.length();
        for (int i = 0; i < size; ++i) {
            try {
                JSONObject association = assocsArray.getJSONObject(i);
                this.createAssociation(association, mapTopicIds, topicmapId);
                continue;
            }
            catch (Exception e) {
                if (e.getCause() != null) {
                    this.log.warning("Assoc NOT imported, caused by \"" + e.getCause().getLocalizedMessage().toString() + "\"");
                    continue;
                }
                this.log.warning("Assoc NOT imported, caused by \"" + e.getLocalizedMessage() + "\"");
                throw new RuntimeException(e);
            }
        }
    }

    private String color(String typeUri) {
        if (typeUri.equals("dmx.contacts.institution")) {
            return "lightblue";
        }
        if (typeUri.equals("dmx.contacts.person")) {
            return "lightblue";
        }
        if (typeUri.equals("dmx.notes.note")) {
            return "lightblue";
        }
        return "lightblue";
    }

    private String typeIconDataUri(String typeUri) throws IOException {
        TopicType topicType = this.dmx.getTopicType(typeUri);
        String iconPath = (String)topicType.getViewConfigValue("dmx.webclient.view_config", "dmx.webclient.icon");
        InputStream iconIS = null;
        try {
            int sep = iconPath.indexOf("/", 2);
            String imagePath = "web" + iconPath.substring(sep);
            iconIS = this.getStaticResource(imagePath);
            this.log.fine("##### IconIS " + iconIS);
        }
        catch (Exception e) {
            this.log.info("### FALLBACK to standard grey icon as typeIcon for \"" + typeUri + "\" icon could not be determined during SVG Export");
            iconIS = this.dmx.getPlugin("systems.dmx.webclient").getStaticResource("web/images/ball-gray.png");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int count = 0;
        while ((count = iconIS.read(buffer)) != -1) {
            baos.write(buffer, 0, count);
        }
        byte[] fileContent = baos.toByteArray();
        byte[] encoded = Base64.encode((byte[])fileContent);
        String imgBase64Str = new String(encoded);
        this.log.fine("##### IMG BASE64 " + imgBase64Str);
        return "data:image/png;base64," + imgBase64Str;
    }

    private void createTopic(JSONObject topic, Map<Long, Long> mapTopicIds, long topicmapId) throws JSONException {
        TopicModel model = this.mf.newTopicModel(topic);
        ViewProps viewProps = this.mf.newViewProps(topic.getJSONObject("viewProps"));
        viewProps.set("dmx.topicmaps.pinned", (Object)false);
        long origTopicId = model.getId();
        Topic newTopic = this.dmx.createTopic(model);
        long topicId = newTopic.getId();
        mapTopicIds.put(origTopicId, topicId);
        this.topicmaps.addTopicToTopicmap(topicmapId, topicId, viewProps);
    }

    private void createAssociation(JSONObject association, Map<Long, Long> mapTopicIds, long topicmapId) {
        this.log.info("Imported mapTopics map size/count: " + mapTopicIds.size());
        AssocModel oldAssocModel = this.mf.newAssocModel(association);
        PlayerModel player1 = oldAssocModel.getPlayer1();
        PlayerModel player2 = oldAssocModel.getPlayer2();
        if (player1 != null && player2 != null) {
            long newPlayer1Id = mapTopicIds.getOrDefault(player1.getId(), new Long(-1L));
            long newPlayer2Id = mapTopicIds.getOrDefault(player2.getId(), new Long(-1L));
            if (newPlayer1Id == -1L || newPlayer2Id == -1L) {
                AssocModel newAssocModel = this.mf.newAssocModel(oldAssocModel.getTypeUri(), (PlayerModel)this.mf.newTopicPlayerModel(newPlayer1Id, player1.getRoleTypeUri()), (PlayerModel)this.mf.newTopicPlayerModel(newPlayer2Id, player2.getRoleTypeUri()), oldAssocModel.getChildTopics());
                Assoc newAssociation = this.dmx.createAssoc(newAssocModel);
                long assocId = newAssociation.getId();
                this.topicmaps.addAssocToTopicmap(topicmapId, assocId, this.mf.newViewProps(true, false));
            } else {
                this.log.warning("Could not re-create assoc due to failure reading topicIds from topcIds map for oldAssocModel=\"" + oldAssocModel + "\", probably some topics could not be imported succesfully and the topicIds printed here are involved in previous errors.");
            }
        } else {
            this.log.warning("Could not re-create assoc due to failure reading players from oldAssocModel=\"" + oldAssocModel + "\"");
        }
    }
}

