/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.ldap.profile.service.impl;

import de.deepamehta.accesscontrol.AccessControlService;
import de.deepamehta.ldap.profile.service.ProfileService;
import java.util.List;
import java.util.Map;

public class ProfileServiceAccessControl
implements ProfileService {
    private final AccessControlService acService;
    private final ProfileService delegate;

    public ProfileServiceAccessControl(AccessControlService accessControlService, ProfileService delegate) {
        this.acService = accessControlService;
        this.delegate = delegate;
    }

    private void checkLogin(String userNameToTest) {
        String loggedInUser = this.acService.getUsername();
        if (userNameToTest == null || loggedInUser == null || !loggedInUser.equals("admin") || !loggedInUser.equals(userNameToTest)) {
            throw new IllegalStateException(String.format("'%s' is not allowed to access the profile data.", loggedInUser));
        }
    }

    @Override
    public boolean update(String userName, ProfileService.Attribute attribute, String value) {
        this.checkLogin(userName);
        return this.delegate.update(userName, attribute, value);
    }

    @Override
    public boolean update(String userName, Map<ProfileService.Attribute, String> values) {
        this.checkLogin(userName);
        return this.delegate.update(userName, values);
    }

    @Override
    public String read(String userName, ProfileService.Attribute attribute) {
        this.checkLogin(userName);
        return this.delegate.read(userName, attribute);
    }

    @Override
    public Map<ProfileService.Attribute, String> read(String userName, List<ProfileService.Attribute> attributes) {
        this.checkLogin(userName);
        return this.delegate.read(userName, attributes);
    }
}

