/*
 * Decompiled with CFR 0.152.
 */
package de.deepamehta.ldap;

import de.deepamehta.ldap.PluginLog;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;

public class Configuration {
    public ProtocolType protocol;
    String server;
    String port;
    ImplementationType implementation;
    public LoggingMode loggingMode;
    boolean userCreationEnabled;
    public String manager;
    public String password;
    public String userBase;
    public String userAttribute;
    public String userFilter;
    String userMemberGroup;
    private String connectionUrl;

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    private Configuration() {
    }

    static boolean isApacheLDAPAvailable() {
        try {
            return Class.forName("org.apache.directory.ldap.client.api.LdapConnection") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static Configuration createFromProperties() {
        Configuration c = new Configuration();
        c.server = System.getProperty("dm4.ldap.server", "127.0.0.1");
        c.port = System.getProperty("dm4.ldap.port");
        c.protocol = ProtocolType.valueOf(System.getProperty("dm4.ldap.protocol", "ldap").toUpperCase());
        c.implementation = ImplementationType.valueOf(System.getProperty("dm4.ldap.implementation", "jndi").toUpperCase());
        c.loggingMode = LoggingMode.valueOf(System.getProperty("dm4.ldap.logging", "info").toUpperCase());
        c.userCreationEnabled = System.getProperty("dm4.ldap.user_creation.enabled", "false").equals("true");
        c.manager = System.getProperty("dm4.ldap.manager", "");
        c.password = System.getProperty("dm4.ldap.password", "");
        c.userBase = System.getProperty("dm4.ldap.user_base", "");
        c.userAttribute = System.getProperty("dm4.ldap.user_attribute", "");
        c.userFilter = System.getProperty("dm4.ldap.user_filter", "");
        c.userMemberGroup = System.getProperty("dm4.ldap.user_member_group", "");
        return c;
    }

    boolean check(PluginLog log) {
        int errorCount;
        block26: {
            errorCount = 0;
            log.configurationHint("Logging is set up for %s environment.", this.loggingMode.toString().toLowerCase());
            if (StringUtils.isEmpty((String)this.manager)) {
                log.configurationError("No manager account provided.", new Object[0]);
                ++errorCount;
            }
            if (StringUtils.isEmpty((String)this.password)) {
                log.configurationWarning("No manager password provided.", new Object[0]);
            }
            if (StringUtils.isEmpty((String)this.userBase)) {
                log.configurationError("No user base provided.", new Object[0]);
                ++errorCount;
            }
            if (StringUtils.isEmpty((String)this.userAttribute)) {
                log.configurationHint("User attribute not set. Defaults to 'uid'.", new Object[0]);
                this.userAttribute = "uid";
            }
            if (StringUtils.isEmpty((String)this.userFilter)) {
                log.configurationHint("No filter expression provided. Defaulting to mere existance check.", new Object[0]);
            }
            if (this.implementation == ImplementationType.APACHE && !Configuration.isApacheLDAPAvailable()) {
                log.configurationError("Apache LDAP configured but bundle not available. Falling back to JNDI.", new Object[0]);
                this.implementation = ImplementationType.JNDI;
            }
            if (this.userCreationEnabled) {
                log.configurationHint("User creation enabled. LDAP entry creation and attribute modification may occur.", new Object[0]);
                if (StringUtils.isEmpty((String)this.userMemberGroup)) {
                    log.configurationHint("No member group provided. Automatically adding inetOrgPerson entries to groups is disabled.", new Object[0]);
                    if (StringUtils.isNotEmpty((String)this.userFilter)) {
                        log.configurationWarning("Custom filter expression provided but no member group for new users. This might lead to new users not being able to log-in.", new Object[0]);
                    }
                } else {
                    log.configurationHint("Automatically adding inetOrgPerson entries to groups is enabled.", new Object[0]);
                    if (StringUtils.isEmpty((String)this.userFilter)) {
                        log.configurationWarning("Member group defined but no filter expression. As such group membership is not checked during log-in.", new Object[0]);
                    }
                }
            } else {
                log.configurationHint("User creation disabled. All LDAP accesses are read-only.", new Object[0]);
            }
            String trustStore = System.getProperty("javax.net.ssl.trustStore", "");
            String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", "");
            if (this.protocol != ProtocolType.LDAP) {
                if (StringUtils.isEmpty((String)trustStore)) {
                    log.configurationWarning("Secure connection requested but no custom SSL/TLS trust update defined. Connection negotiation may fail.", new Object[0]);
                } else {
                    if (StringUtils.isEmpty((String)trustStorePassword)) {
                        log.configurationWarning("Custom keystore was configured but password is empty. Opening the keystore and accessing its content may fail.", new Object[0]);
                    }
                    try {
                        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        keyStore.load(new FileInputStream(trustStore), trustStorePassword.toCharArray());
                        log.configurationHint("Configured trust update %s is usable with provided password.", trustStore);
                        int count = 0;
                        Enumeration<String> aliases = keyStore.aliases();
                        while (aliases.hasMoreElements()) {
                            ++count;
                            aliases.nextElement();
                        }
                        if (count == 0) {
                            log.configurationError("Configured trust update does not contain any aliases. Please check the file.", new Object[0]);
                            break block26;
                        }
                        log.configurationHint("Configured trust update contains %s aliases. It appears valid for SSL/TLS connections", count);
                    }
                    catch (KeyStoreException e) {
                        log.configurationError("Unable to initialize default trust update. Expecting \"Java Keystore\" format: %s", e.getLocalizedMessage());
                    }
                    catch (NoSuchAlgorithmException e) {
                        log.configurationError("Unable to read trust update. Check whether it is in the default \"Java Keystore\" format: %s", e.getLocalizedMessage());
                    }
                    catch (CertificateException e) {
                        log.configurationError("Unable to read trust update. Issue with certificates: %s", e.getLocalizedMessage());
                    }
                    catch (FileNotFoundException e) {
                        log.configurationError("Trust update configured to %s but file is not accessible: %s", trustStore, e.getLocalizedMessage());
                    }
                    catch (IOException e) {
                        log.configurationError("Trust update configured to %s but reading the file failed: %s", trustStore, e.getLocalizedMessage());
                    }
                }
            } else if (StringUtils.isNotEmpty((String)trustStore)) {
                log.configurationWarning("A trust update located at %s was specified but using a non-SSL/TLS protocol. Check configuration.", trustStore);
            }
        }
        return errorCount == 0;
    }

    void compile() {
        if (StringUtils.isEmpty((String)this.port)) {
            this.port = this.protocol == ProtocolType.LDAP ? "636" : "389";
        }
        this.connectionUrl = String.format("ldap%s://%s:%s", this.protocol == ProtocolType.LDAPS ? "s" : "", this.server, this.port);
    }

    String summary() {
        String trustStore = System.getProperty("javax.net.ssl.trustStore", "");
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", "");
        String trustStoreSummary = this.protocol != ProtocolType.LDAP || StringUtils.isNotEmpty((String)trustStore) ? String.format("\ntrustStore=%s\ntrustStorePassword=%s", trustStore, StringUtils.isEmpty((String)trustStorePassword) ? "" : "***") : "";
        return String.format("dm4.ldap.protocol=%s\ndm4.ldap.server=%s\ndm4.ldap.port=%s\ndm4.ldap.implementation=%s\ndm4.ldap.logging=%s\ndm4.ldap.user_creation.enabled=%s\ndm4.ldap.manager=%s\ndm4.ldap.password=%s\ndm4.ldap.user_base=%s\ndm4.ldap.user_attribute=%s\ndm4.ldap.user_acceptance_filter=%s\ndm4.ldap.user_member_group=%s%s", new Object[]{this.protocol, this.server, this.port, this.implementation, this.loggingMode, this.userCreationEnabled, this.manager, StringUtils.isEmpty((String)this.password) ? "" : "***", this.userBase, this.userAttribute, this.userFilter, this.userMemberGroup, trustStoreSummary});
    }

    public static enum LoggingMode {
        INFO,
        DEBUG;

    }

    public static enum ImplementationType {
        JNDI,
        APACHE;

    }

    public static enum ProtocolType {
        LDAP,
        LDAPS,
        STARTTLS;

    }
}

